<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('transactions', function (Blueprint $table) {
            $table->bigIncrements('transaction_id');
            $table->string('transaction_code', 60)->unique('transaction_code');
            $table->date('entry_date')->index('idx_transactions_entry_date');
            $table->text('narration');
            $table->string('reference', 120)->nullable();
            $table->unsignedBigInteger('gl_account_id')->index('gl_account_id');
            $table->unsignedBigInteger('subaccount_id')->nullable()->index('subaccount_id');
            $table->unsignedBigInteger('contra_gl_account_id')->nullable()->index('contra_gl_account_id');
            $table->unsignedBigInteger('contra_subaccount_id')->nullable()->index('contra_subaccount_id');
            $table->decimal('debit', 18)->default(0);
            $table->decimal('credit', 18)->default(0);
            $table->decimal('quantity', 18, 4)->nullable();
            $table->decimal('unit_price', 18)->nullable();
            $table->decimal('discount', 18)->nullable()->default(0);
            $table->decimal('tax_amount', 18)->nullable()->default(0);
            $table->unsignedBigInteger('tax_id')->nullable()->index('tax_id');
            $table->decimal('line_total', 18);
            $table->enum('source', ['invoice', 'supplier_invoice', 'receipt', 'quotation', 'journal', 'cashbook', 'payment', 'adjustment', 'other'])->nullable()->default('journal')->index('idx_transactions_source');
            $table->string('related_type', 50)->nullable();
            $table->unsignedBigInteger('related_id')->nullable();
            $table->string('batch_code', 80)->nullable();
            $table->string('document_path', 191)->nullable();
            $table->unsignedBigInteger('currency_id')->index('currency_id');
            $table->decimal('exchange_rate', 18, 6)->nullable()->default(1);
            $table->boolean('posted')->nullable()->default(false)->index('idx_transactions_posted');
            $table->dateTime('posted_at')->nullable();
            $table->boolean('is_reconciled')->nullable()->default(false);
            $table->string('reconcile_reference', 120)->nullable();
            $table->unsignedBigInteger('client_id')->nullable()->index('idx_transactions_client');
            $table->unsignedBigInteger('case_id')->nullable()->index('idx_transactions_case');
            $table->unsignedBigInteger('supplier_id')->nullable();
            $table->unsignedBigInteger('created_by')->nullable()->index('created_by');
            $table->unsignedBigInteger('updated_by')->nullable()->index('updated_by');
            $table->timestamp('created_at')->nullable()->useCurrent();
            $table->timestamp('updated_at')->useCurrentOnUpdate()->nullable()->useCurrent();

            $table->index(['related_type', 'related_id'], 'idx_transactions_related');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('transactions');
    }
};
