<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('uploaded_chat_files', function (Blueprint $table) {
            $table->bigIncrements('file_id');
            $table->unsignedBigInteger('user_id')->index('user_id');
            $table->unsignedBigInteger('chat_id')->nullable()->index('chat_id');
            $table->string('file_name', 191);
            $table->string('file_type', 50)->nullable();
            $table->bigInteger('file_size')->nullable();
            $table->string('file_url', 191);
            $table->timestamp('uploaded_at')->nullable()->useCurrent();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('uploaded_chat_files');
    }
};
