<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('user_chat_settings', function (Blueprint $table) {
            $table->bigIncrements('setting_id');
            $table->unsignedBigInteger('user_id')->index('user_id');
            $table->boolean('enable_sound')->nullable()->default(true);
            $table->boolean('auto_scroll')->nullable()->default(true);
            $table->boolean('show_typing_indicators')->nullable()->default(true);
            $table->boolean('dark_mode')->nullable()->default(false);
            $table->boolean('show_online_status')->nullable()->default(true);
            $table->boolean('save_chat_history')->nullable()->default(true);
            $table->timestamp('updated_at')->useCurrentOnUpdate()->nullable()->useCurrent();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('user_chat_settings');
    }
};
