<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('user_phones', function (Blueprint $table) {
            $table->bigIncrements('phone_id');
            $table->unsignedBigInteger('user_id')->index('idx_user_phones_user_id');
            $table->string('phone_number', 20)->index('idx_user_phones_number');
            $table->enum('phone_type', ['primary', 'secondary', 'work', 'emergency'])->nullable()->default('primary');
            $table->boolean('is_verified')->nullable()->default(false)->index('idx_user_phones_verified');
            $table->timestamp('created_at')->nullable()->useCurrent();
            $table->timestamp('updated_at')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('user_phones');
    }
};
