<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('users', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('created_by')->nullable();
            $table->string('name', 100);
            $table->string('email', 191)->unique('email');
            $table->text('password_hash');
            $table->unsignedBigInteger('role_id')->nullable()->index('idx_users_role_id');
            $table->unsignedBigInteger('group_id')->nullable()->index('idx_users_group_id');
            $table->unsignedBigInteger('tier_id')->nullable()->index('idx_users_tier_id');
            $table->string('status', 20)->nullable()->default('active')->index('idx_users_status');
            $table->string('location', 100)->nullable();
            $table->boolean('is_2fa_enabled')->nullable()->default(false);
            $table->boolean('uses_authenticator')->nullable()->default(false);
            $table->boolean('uses_sms')->nullable()->default(false);
            $table->text('authenticator_secret')->nullable();
            $table->boolean('sms_verified')->nullable()->default(false);
            $table->timestamp('created_at')->nullable()->useCurrent();
            $table->timestamp('updated_at')->useCurrentOnUpdate()->nullable()->useCurrent();
            $table->integer('failed_login_attempts')->nullable()->default(0);
            $table->timestamp('account_locked_until')->nullable();

            $table->index(['email'], 'idx_users_email');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('users');
    }
};
