Get-ChildItem -Path 'resources/views' -Filter '*.blade.php' -Recurse | ForEach-Object {
    $filePath = $_.FullName
    $content = Get-Content $filePath -Raw
    $newContent = $content -replace "@extends\('layouts\.app'\)", "@extends('layouts.master')"
    if ($content -ne $newContent) {
        Set-Content $filePath $newContent
        Write-Host "Updated: $filePath"
    }
}
