{{-- resources/views/reports/tax-report.blade.php --}}
@extends('layouts.master')
@section('title', 'Tax Report')
@section('content')

<div class="container-fluid py-3">
    <div class="d-flex justify-content-end mb-3">
        <a href="{{ route('home') }}" class="btn-back">
            <i class="fas fa-arrow-left me-2"></i> Back to Dashboard
        </a>
    </div>

    <div class="card shadow-sm">
        <div class="card-header bg-primary text-white py-3">
            <h5 class="mb-0"><i class="fas fa-percent me-2"></i> Tax Report</h5>
        </div>
        
        <div class="card-body">
            @if(session('success'))
                <div class="alert alert-success">{{ session('success') }}</div>
            @endif
            
            @if($errors->any())
                <div class="alert alert-danger">
                    <ul class="mb-0">
                        @foreach($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif
            
            <form action="{{ route('taxReport.generate') }}" method="POST">
                @csrf
                <div class="row mb-3">
                    <div class="col-md-4">
                        <label class="form-label"><strong>Tax Description</strong></label>
                        <select class="form-control" name="tax" required>
                            <option value="" disabled selected>Select Tax</option>
                            <option value="All" {{ old('tax', isset($taxId) ? $taxId : '') == 'All' ? 'selected' : '' }}>All Tax</option>
                            @foreach($taxes as $tax)
                                <option value="{{ $tax->tax_id }}" {{ old('tax', isset($taxId) ? $taxId : '') == $tax->tax_id ? 'selected' : '' }}>
                                    {{ $tax->tax_rate }}% {{ $tax->tax_description }}
                                </option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-md-4">
                        <label class="form-label"><strong>From Period</strong></label>
                        <input type="date" class="form-control" name="pfrom" value="{{ old('pfrom', isset($pfrom) ? $pfrom : date('Y-m-d')) }}" required>
                    </div>
                    <div class="col-md-4">
                        <label class="form-label"><strong>To Period</strong></label>
                        <input type="date" class="form-control" name="pto" value="{{ old('pto', isset($pto) ? $pto : date('Y-m-d')) }}" required>
                    </div>
                </div>
                
                <div class="row mb-3">
                    <div class="col-md-4">
                        <label class="form-label"><strong>Select Currency</strong></label>
                        <select class="form-control" name="curr" required>
                            <option value="" disabled selected>Select Currency</option>
                            @foreach($currencies as $currency)
                                <option value="{{ $currency->currency_id }}" {{ old('curr', isset($currencyId) ? $currencyId : '') == $currency->currency_id ? 'selected' : '' }}>
                                    {{ $currency->currency_name }}
                                </option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-md-4">
                        <label class="form-label"><strong>From</strong></label>
                        <input type="date" class="form-control" name="from" value="{{ old('from', isset($from) ? $from : date('Y-m-d')) }}" required>
                    </div>
                    <div class="col-md-4">
                        <label class="form-label"><strong>To</strong></label>
                        <input type="date" class="form-control" name="to" value="{{ old('to', isset($to) ? $to : date('Y-m-d')) }}" required>
                    </div>
                </div>
                
                <div class="d-flex justify-content-end">
                    <button type="submit" class="btn btn-primary me-2">View Report</button>
                    <button type="reset" class="btn btn-secondary">Refresh</button>
                </div>
            </form>
            
            <hr>
            
            @if(isset($outputTransactions) && isset($inputTransactions))
                <div class="d-flex justify-content-end mb-3">
                    <form action="{{ route('taxReport.downloadPdf') }}" method="POST">
                        @csrf
                        <input type="hidden" name="taxId" value="{{ $taxId }}">
                        <input type="hidden" name="pfrom" value="{{ $pfrom }}">
                        <input type="hidden" name="pto" value="{{ $pto }}">
                        <input type="hidden" name="from" value="{{ $from }}">
                        <input type="hidden" name="to" value="{{ $to }}">
                        <input type="hidden" name="currencyId" value="{{ $currencyId }}">
                        <button type="submit" class="btn btn-success">
                            <i class="fas fa-download me-2"></i> Download PDF
                        </button>
                    </form>
                </div>
                
                <div class="report-container">
                    <div class="report-header mb-4">
                        <div class="d-flex align-items-center mb-3">
                            <img src="{{ asset('img/logo.png') }}" alt="Logo" style="height: 60px;" class="me-3">
                            <h4 class="mb-0">Tax Statement</h4>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <p class="mb-1"><strong>Date:</strong> {{ date('F j, Y') }}</p>
                                <p class="mb-1"><strong>Account:</strong> 0000</p>
                            </div>
                            <div class="col-md-6 text-md-end">
                                <p class="mb-1"><strong>Currency:</strong> {{ $currnames }}</p>
                                <p class="mb-1"><strong>From:</strong> {{ $from }} <strong>To:</strong> {{ $to }}</p>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Output Tax Section -->
                    <h5 class="bg-light p-2 border-bottom">Output Tax [Tenants]</h5>
                    <div class="table-responsive mb-4">
                        <table class="table table-bordered">
                            <thead class="table-light">
                                <tr>
                                    <th>Date</th>
                                    <th>Name</th>
                                    <th>Inv No</th>
                                    <th>Inv Amount(USD)</th>
                                    <th>Tax%</th>
                                    <th>Tax Amount(USD)</th>
                                    <th>Total(incl)</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($outputTransactions as $transaction)
                                    @foreach($transaction->lines as $line)
                                        @php
                                            $invoiceAmount = $line->price * $line->quantity;
                                            $taxAmount = $invoiceAmount * ($line->tax_rate / 100);
                                            $amountIncl = $invoiceAmount + $taxAmount;
                                        @endphp
                                        <tr>
                                            <td>{{ $transaction->invoice_date }}</td>
                                            <td>{{ $transaction->customer->full_name ?? 'N/A' }}</td>
                                            <td>{{ $transaction->invoice_number }}</td>
                                            <td>{{ number_format($invoiceAmount, 2) }}</td>
                                            <td>{{ $transaction->tax_rate }}</td>
                                            <td>{{ number_format($taxAmount, 2) }}</td>
                                            <td>{{ number_format($amountIncl, 2) }}</td>
                                        </tr>
                                    @endforeach
                                @empty
                                    <tr>
                                        <td colspan="7" class="text-center">No output tax transactions found</td>
                                    </tr>
                                @endforelse
                            </tbody>
                            <tfoot class="table-secondary">
                                <tr>
                                    <td colspan="3" class="text-end"><strong>Total Output Tax</strong></td>
                                    <td><strong>{{ number_format($outputTotals['invoice'], 2) }}</strong></td>
                                    <td></td>
                                    <td><strong>{{ number_format($outputTotals['tax'], 2) }}</strong></td>
                                    <td><strong>{{ number_format($outputTotals['incl'], 2) }}</strong></td>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                    
                    <!-- Input Tax Section -->
                    <h5 class="bg-light p-2 border-bottom">Input Tax [Suppliers]</h5>
                    <div class="table-responsive mb-4">
                        <table class="table table-bordered">
                            <thead class="table-light">
                                <tr>
                                    <th>Date</th>
                                    <th>Name</th>
                                    <th>Inv No</th>
                                    <th>Inv Amount(USD)</th>
                                    <th>Tax%</th>
                                    <th>Tax Amount(USD)</th>
                                    <th>Total(incl)</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($inputTransactions as $transaction)
                                    @php
                                        $invoiceAmount = $transaction->price * $transaction->quantity;
                                        $taxAmount = $invoiceAmount * ($transaction->tax_rate / 100);
                                        $amountIncl = $invoiceAmount + $taxAmount;
                                    @endphp
                                    <tr>
                                        <td>{{ $transaction->invoice_date }}</td>
                                        <td>{{ $transaction->supplier->supplier_account ?? 'N/A' }}</td>
                                        <td>{{ $transaction->invoice_number }}</td>
                                        <td>{{ number_format($invoiceAmount, 2) }}</td>
                                        <td>{{ $transaction->tax_rate }}</td>
                                        <td>{{ number_format($taxAmount, 2) }}</td>
                                        <td>{{ number_format($amountIncl, 2) }}</td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="7" class="text-center">No input tax transactions found</td>
                                    </tr>
                                @endforelse
                            </tbody>
                            <tfoot class="table-primary">
                                <tr>
                                    <td colspan="3" class="text-end"><strong>Net Tax</strong></td>
                                    <td><strong>{{ number_format($outputTotals['invoice'] - $inputTotals['invoice'], 2) }}</strong></td>
                                    <td></td>
                                    <td><strong>{{ number_format($outputTotals['tax'] - $inputTotals['tax'], 2) }}</strong></td>
                                    <td><strong>{{ number_format($outputTotals['incl'] - $inputTotals['incl'], 2) }}</strong></td>
                                </tr>
                            </tfoot>
                            <tfoot class="table-secondary">
                                <tr>
                                    <td colspan="3" class="text-end"><strong>Total Input Tax</strong></td>
                                    <td><strong>{{ number_format($inputTotals['invoice'], 2) }}</strong></td>
                                    <td></td>
                                    <td><strong>{{ number_format($inputTotals['tax'], 2) }}</strong></td>
                                    <td><strong>{{ number_format($inputTotals['incl'], 2) }}</strong></td>
                                </tr>
                            </tfoot>
                             
                        </table>
                    </div>
                </div>
            @endif
        </div>
    </div>
</div>

@endsection

@section('styles')
<style>
.btn-back {
    text-decoration: none;
    color: #1AB9D9;
    font-weight: 500;
    display: inline-flex;
    align-items: center;
    padding: 5px 15px;
    border-radius: 4px;
    transition: all 0.3s;
}
.btn-back:hover {
    background-color: rgba(26, 185, 217, 0.1);
    text-decoration: none;
}
.card {
    border-radius: 8px;
    overflow: hidden;
    border: none;
    box-shadow: 0 0.5rem 1rem rgba(0, 0, 0, 0.1);
}
.card-header {
    border-bottom: 1px solid rgba(0,0,0,0.1);
    padding: 12px 20px;
}
.table th {
    background-color: #f8f9fa;
}
.report-header {
    border-bottom: 2px solid #dee2e6;
    padding-bottom: 20px;
}
select.form-control {
    color: #000000 !important;
}
select.form-control option {
    color: #000000 !important;
}
</style>
@endsection
