# Reports Module Cross-Reference

This document provides a cross-reference for all pages under the reports module, including page titles, fields on each page, and the database tables used for generating the reports.

## 1. Cashbook Report (cashbook.blade.php)
- **Title**: Cashbook Daily Transaction Report
- **Fields**: cashbook_account, date_from, date_to, currency
- **DB Tables**: Cashbook, CashbookEntry

## 2. Trial Balance Report (trial-balance.blade.php)
- **Title**: Trial Balance Report
- **Fields**: pfrom, pto, curr
- **DB Tables**: MainAccount, SubAccount, GeneralJournal

## 3. General Ledger Report (general-ledger.blade.php)
- **Title**: General Ledger - Prolex Law Firm
- **Fields**: from_date, to_date, account_type, currency
- **DB Tables**: GeneralJournal, MainAccount

## 4. Income Statements (income-statements.blade.php)
- **Title**: Income Statements
- **Fields**: pfrom, pto, curr
- **DB Tables**: GeneralJournal

## 5. Chart of Accounts (chart-of-accounts.blade.php)
- **Title**: Chart of Accounts - Prolex Law Firm
- **Fields**: account
- **DB Tables**: MainAccount, AccountType

## 6. Court Filings Report (court-filings.blade.php)
- **Title**: Court Filings Report - Prolex Law Firm
- **Fields**: pfrom, pto
- **DB Tables**: CourtFiling, LegalCase, Lawyer, CourtArea, CourtType, Judge

## 7. Supplier Statement Report (supplier-statement.blade.php)
- **Title**: Supplier Statement Report
- **Fields**: supplier_account, date_from, date_to, currency
- **DB Tables**: Supplier, SupplierInvoice, SupplierJournal

## 8. Fee Collection Report (fee-collection.blade.php)
- **Title**: Fee Collection Report
- **Fields**: client, from_date, to_date
- **DB Tables**: ClientInvoice, ClientReceiptLine, Client

## 9. Total Fees Report (total-fees.blade.php)
- **Title**: Total Fees Report
- **Fields**: client, startDate, endDate, status
- **DB Tables**: ClientInvoice, Client

## 10. Outstanding Fees Report (outstanding-fees.blade.php)
- **Title**: Outstanding Fees Report
- **Fields**: client, from_date, to_date
- **DB Tables**: ClientInvoice, ClientReceiptLine, Client

## 11. Lawyer Statement Report (lawyer-statement.blade.php)
- **Title**: Lawyer Performance Statement
- **Fields**: customer_account, date_from, date_to, currency
- **DB Tables**: Lawyer, LawyerJournal, LawyerInvoice

## 12. Journals (journals.blade.php)
- **Title**: Journals - Prolex Law Firm
- **Fields**: None (selection page)
- **DB Tables**: GeneralJournal, ClientJournal, SupplierJournal

## 13. GL Account Detail (gl-account-detail.blade.php)
- **Title**: GL Account Detail - Prolex Law Firm
- **Fields**: account, from_date, to_date
- **DB Tables**: GeneralJournal, MainAccount

## 14. Client Statement Report (client-statement.blade.php)
- **Title**: Client Statement Report
- **Fields**: client_id, date_from, date_to, currency
- **DB Tables**: Client, ClientJournal, ClientReceipt, ClientInvoice

## 15. Customer Journal (customer-journal.blade.php)
- **Title**: Customer Journal
- **Fields**: date_from, date_to, client
- **DB Tables**: ClientJournal

## 16. Supplier Journal (supplier-journal.blade.php)
- **Title**: Supplier Journal
- **Fields**: date_from, date_to, supplier
- **DB Tables**: SupplierJournal

## 17. General Journal (general-journal.blade.php)
- **Title**: General Journal
- **Fields**: date_from, date_to, account
- **DB Tables**: GeneralJournal

## 18. Case Status Report (case-status.blade.php)
- **Title**: Case Status Report
- **Fields**: status, date_from, date_to
- **DB Tables**: LegalCase, CaseStatus

## 19. Balance Sheet (balance-sheet.blade.php)
- **Title**: Balance Sheet Report
- **Fields**: pfrom, pto, curr
- **DB Tables**: MainAccount, GeneralJournal

## 20. Tax Reports (tax-reports.blade.php)
- **Title**: Tax Reports
- **Fields**: tax_type, period
- **DB Tables**: Tax, GeneralJournal

## 21. PDF Versions
- **Cashbook PDF (cashbook-pdf.blade.php)**: Same as cashbook.blade.php
- **Trial Balance PDF (trial-balance-pdf.blade.php)**: Same as trial-balance.blade.php
- **General Ledger PDF (general-ledger-pdf.blade.php)**: Same as general-ledger.blade.php
- **Court Filings PDF (court-filings-pdf.blade.php)**: Same as court-filings.blade.php
- **Outstanding Sales PDF (outstanding-sales-pdf.blade.php)**: ClientInvoice, ClientQuotation
- **Case Status PDF (case-status-pdf.blade.php)**: Same as case-status.blade.php

## 22. Placeholder (placeholder.blade.php)
- **Title**: Placeholder
- **Fields**: None
- **DB Tables**: None
