{{-- resources/views/balance-sheet.blade.php --}}
@extends('layouts.master')
@section('title', 'Balance Sheet')
@section('content')

<div class="container-fluid py-3">
    <div class="d-flex justify-content-end mb-3">
        <a href="{{ route('modules.reports') }}" class="btn-back">
            <i class="fas fa-arrow-left me-2"></i> Back to Reports
        </a>
    </div>

    <div class="card shadow-sm">
        <div class="card-header bg-primary text-white py-3">
            <h5 class="mb-0"><i class="fas fa-balance-scale me-2"></i> Balance Sheet</h5>
        </div>

        <div class="card-body">
            @if(session('success'))
                <div class="alert alert-success">{{ session('success') }}</div>
            @endif

            @if($errors->any())
                <div class="alert alert-danger">
                    <ul class="mb-0">
                        @foreach($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif

            <form action="{{ route('balanceSheet.generate') }}" method="POST">
                @csrf
                <div class="row mb-3">
                    <div class="col-md-4">
                        <label class="form-label"><strong>From Period</strong></label>
                        <input type="date" class="form-control" name="pfrom" value="{{ old('pfrom', date('Y-m-d')) }}" required>
                    </div>
                    <div class="col-md-4">
                        <label class="form-label"><strong>To Period</strong></label>
                        <input type="date" class="form-control" name="pto" value="{{ old('pto', date('Y-m-d')) }}" required>
                    </div>
                    <div class="col-md-4">
                        <label class="form-label"><strong>Select Currency</strong></label>
                        <select class="form-control" name="curr" required>
                            <option value="" disabled selected>Select Currency</option>
                            @foreach($currencies as $currency)
                                <option value="{{ $currency->id }}" {{ old('curr') == $currency->id ? 'selected' : '' }}>
                                    {{ $currency->name }}
                                </option>
                            @endforeach
                        </select>
                    </div>
                </div>

                <div class="d-flex justify-content-end">
                    <button type="submit" class="btn btn-primary me-2">View Report</button>
                    <button type="reset" class="btn btn-secondary">Refresh</button>
                </div>
            </form>

            <hr>

            @if(isset($assets) && isset($liabilities) && isset($equity))
                <div class="d-flex justify-content-end mb-3">
                    <form action="{{ route('balanceSheet.downloadPdf') }}" method="POST">
                        @csrf
                        <input type="hidden" name="pfrom" value="{{ $pfrom }}">
                        <input type="hidden" name="pto" value="{{ $pto }}">
                        <input type="hidden" name="currencyId" value="{{ $currencyId }}">
                        <button type="submit" class="btn btn-success">
                            <i class="fas fa-download me-2"></i> Download PDF
                        </button>
                    </form>
                </div>

                <div class="report-container">
                    <div class="report-header mb-4">
                        <div class="d-flex align-items-center mb-3">
                            <img src="{{ asset('img/logo.png') }}" alt="Logo" style="height: 60px;" class="me-3">
                            <h4 class="mb-0">Balance Sheet</h4>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <p class="mb-1"><strong>Date:</strong> {{ date('F j, Y') }}</p>
                                <p class="mb-1"><strong>Account:</strong> 0000</p>
                            </div>
                            <div class="col-md-6 text-md-end">
                                <p class="mb-1"><strong>Currency:</strong> {{ $currnames[$currencyId] ?? 'USD' }}</p>
                                <p class="mb-1"><strong>From:</strong> {{ $pfrom }} <strong>To:</strong> {{ $pto }}</p>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <!-- Assets Section -->
                        <div class="col-md-6">
                            <h5 class="bg-light p-2 border-bottom">Assets</h5>
                            <div class="table-responsive mb-4">
                                <table class="table table-bordered">
                                    <thead class="table-light">
                                        <tr>
                                            <th>Account</th>
                                            <th>Amount</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @forelse($assets as $asset)
                                            <tr>
                                                <td>{{ $asset['name'] }}</td>
                                                <td>{{ number_format($asset['amount'], 2) }}</td>
                                            </tr>
                                        @empty
                                            <tr>
                                                <td colspan="2" class="text-center">No assets found</td>
                                            </tr>
                                        @endforelse
                                    </tbody>
                                    <tfoot class="table-secondary">
                                        <tr>
                                            <td><strong>Total Assets</strong></td>
                                            <td><strong>{{ number_format($totalAssets, 2) }}</strong></td>
                                        </tr>
                                    </tfoot>
                                </table>
                            </div>
                        </div>

                        <!-- Liabilities and Equity Section -->
                        <div class="col-md-6">
                            <h5 class="bg-light p-2 border-bottom">Liabilities</h5>
                            <div class="table-responsive mb-4">
                                <table class="table table-bordered">
                                    <thead class="table-light">
                                        <tr>
                                            <th>Account</th>
                                            <th>Amount</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @forelse($liabilities as $liability)
                                            <tr>
                                                <td>{{ $liability['name'] }}</td>
                                                <td>{{ number_format($liability['amount'], 2) }}</td>
                                            </tr>
                                        @empty
                                            <tr>
                                                <td colspan="2" class="text-center">No liabilities found</td>
                                            </tr>
                                        @endforelse
                                    </tbody>
                                    <tfoot class="table-secondary">
                                        <tr>
                                            <td><strong>Total Liabilities</strong></td>
                                            <td><strong>{{ number_format($totalLiabilities, 2) }}</strong></td>
                                        </tr>
                                    </tfoot>
                                </table>
                            </div>

                            <h5 class="bg-light p-2 border-bottom">Equity</h5>
                            <div class="table-responsive mb-4">
                                <table class="table table-bordered">
                                    <thead class="table-light">
                                        <tr>
                                            <th>Account</th>
                                            <th>Amount</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @forelse($equity as $eq)
                                            <tr>
                                                <td>{{ $eq['name'] }}</td>
                                                <td>{{ number_format($eq['amount'], 2) }}</td>
                                            </tr>
                                        @empty
                                            <tr>
                                                <td colspan="2" class="text-center">No equity found</td>
                                            </tr>
                                        @endforelse
                                    </tbody>
                                    <tfoot class="table-primary">
                                        <tr>
                                            <td><strong>Total Equity</strong></td>
                                            <td><strong>{{ number_format($totalEquity, 2) }}</strong></td>
                                        </tr>
                                    </tfoot>
                                    <tfoot class="table-secondary">
                                        <tr>
                                            <td><strong>Total Liabilities & Equity</strong></td>
                                            <td><strong>{{ number_format($totalLiabilities + $totalEquity, 2) }}</strong></td>
                                        </tr>
                                    </tfoot>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            @endif
        </div>
    </div>
</div>

@endsection

@section('styles')
<style>
.btn-back {
    text-decoration: none;
    color: #1AB9D9;
    font-weight: 500;
    display: inline-flex;
    align-items: center;
    padding: 5px 15px;
    border-radius: 4px;
    transition: all 0.3s;
}
.btn-back:hover {
    background-color: rgba(26, 185, 217, 0.1);
    text-decoration: none;
}
.card {
    border-radius: 8px;
    overflow: hidden;
    border: none;
    box-shadow: 0 0.5rem 1rem rgba(0, 0, 0, 0.1);
}
.card-header {
    border-bottom: 1px solid rgba(0,0,0,0.1);
    padding: 12px 20px;
}
.table th {
    background-color: #f8f9fa;
}
.report-header {
    border-bottom: 2px solid #dee2e6;
    padding-bottom: 20px;
}
</style>
@endsection
