{{-- resources/views/case-status.blade.php --}}
@extends('layouts.master')
@section('title', 'Case Status Report')
@section('content')

<div class="container-fluid py-3">
    <div class="d-flex justify-content-end mb-3">
        <a href="{{ route('modules.reports') }}" class="btn-back">
            <i class="fas fa-arrow-left me-2"></i> Back to Reports
        </a>
    </div>

    <div class="card shadow-sm">
        <div class="card-header bg-primary text-white py-3">
            <h5 class="mb-0"><i class="fas fa-briefcase me-2"></i> Case Status Report</h5>
        </div>

        <div class="card-body">
            @if(session('success'))
                <div class="alert alert-success">{{ session('success') }}</div>
            @endif

            @if($errors->any())
                <div class="alert alert-danger">
                    <ul class="mb-0">
                        @foreach($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif

            <form action="{{ route('caseStatus.generate') }}" method="POST">
                @csrf
                <div class="row g-3 align-items-center">
                    <div class="col-md-4">
                        <label for="case_id" class="form-label"><strong>Search Case Number</strong></label>
                        <input type="text" id="case_search" name="case_search" class="form-control" placeholder="Type to search case number..." autocomplete="off" required>
                        <input type="hidden" id="case_id" name="case_id">
                        <div id="case_dropdown" class="dropdown-menu" style="display: none; width: 100%; max-height: 200px; overflow-y: auto;"></div>
                    </div>
                    <div class="col-md-3">
                        <label for="date_from" class="form-label"><strong>Date From</strong></label>
                        <input type="date" id="date_from" name="date_from" class="form-control" value="{{ request('date_from') ?? '' }}">
                    </div>
                    <div class="col-md-3">
                        <label for="date_to" class="form-label"><strong>Date To</strong></label>
                        <input type="date" id="date_to" name="date_to" class="form-control" value="{{ request('date_to') ?? '' }}">
                    </div>
                    <div class="col-md-2">
                        <button type="submit" class="btn btn-primary mt-4">Generate Report</button>
                    </div>
                </div>
            </form>

            <hr>

            @if(isset($selectedCase))
                <div class="d-flex justify-content-end mb-3">
                    <form action="{{ route('caseStatus.downloadPdf') }}" method="POST">
                        @csrf
                        <input type="hidden" name="case_id" value="{{ $selectedCase->id }}">
                        <button type="submit" class="btn btn-success">
                            <i class="fas fa-download me-2"></i> Download PDF
                        </button>
                    </form>
                </div>

                <div class="report-container">
                    <div class="report-header mb-4">
                        <div class="d-flex align-items-center mb-3">
                            <img src="{{ asset('img/logo.png') }}" alt="Logo" style="height: 60px;" class="me-3">
                            <h4 class="mb-0">Case Status Report</h4>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <p class="mb-1"><strong>Report Date:</strong> {{ date('F j, Y') }}</p>
                                <p class="mb-1"><strong>Case Number:</strong> {{ $selectedCase->case_id }}</p>
                            </div>
                            <div class="col-md-6 text-md-end">
                                <p class="mb-1"><strong>Status:</strong> {{ $selectedCase->caseStatus->name ?? 'N/A' }}</p>
                                <p class="mb-1"><strong>Generated On:</strong> {{ now()->format('F j, Y H:i') }}</p>
                            </div>
                        </div>
                    </div>

                    <div class="card">
                        <div class="card-header bg-secondary text-white">
                            <h6>Case Details</h6>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-6">
                                    <p><strong>Client Name:</strong> {{ $selectedCase->client_name }}</p>
                                    <p><strong>Lawyer:</strong> {{ $selectedCase->lawyer->name ?? 'N/A' }}</p>
                                    <p><strong>Category:</strong> {{ $selectedCase->caseCategory->name ?? 'N/A' }}</p>
                                    <p><strong>Reason:</strong> {{ $selectedCase->caseReason->name ?? 'N/A' }}</p>
                                </div>
                                <div class="col-md-6">
                                    <p><strong>Status:</strong> {{ $selectedCase->caseStatus->name ?? 'N/A' }}</p>
                                    <p><strong>Judgement:</strong> {{ $selectedCase->judgement->name ?? 'N/A' }}</p>
                                    <p><strong>Created Date:</strong> {{ $selectedCase->created_at->format('F j, Y') }}</p>
                                    <p><strong>Last Updated:</strong> {{ $selectedCase->updated_at->format('F j, Y H:i') }}</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            @elseif(request()->has('case_id'))
                <div class="alert alert-warning">No case found with the selected case number.</div>
            @endif
        </div>
    </div>
</div>

@endsection

@section('styles')
<style>
.btn-back {
    text-decoration: none;
    color: #1AB9D9;
    font-weight: 500;
    display: inline-flex;
    align-items: center;
    padding: 5px 15px;
    border-radius: 4px;
    transition: all 0.3s;
}
.btn-back:hover {
    background-color: rgba(26, 185, 217, 0.1);
    text-decoration: none;
}
.card {
    border-radius: 8px;
    overflow: hidden;
    border: none;
    box-shadow: 0 0.5rem 1rem rgba(0, 0, 0, 0.1);
}
.card-header {
    border-bottom: 1px solid rgba(0,0,0,0.1);
    padding: 12px 20px;
}
.dropdown-menu {
    position: absolute;
    z-index: 1000;
    background-color: white;
    border: 1px solid #ccc;
    border-radius: 4px;
    box-shadow: 0 2px 4px rgba(0,0,0,0.1);
}
.dropdown-menu div {
    padding: 8px 12px;
    cursor: pointer;
    border-bottom: 1px solid #eee;
}
.dropdown-menu div:last-child {
    border-bottom: none;
}
.dropdown-menu div:hover {
    background-color: #f8f9fa;
}
</style>
@endsection

@section('scripts')
<script>
document.addEventListener('DOMContentLoaded', function() {
    const caseSearchInput = document.getElementById('case_search');
    const caseIdInput = document.getElementById('case_id');
    const caseDropdown = document.getElementById('case_dropdown');

    // Sample case data - in a real app, this would come from the server
    const cases = @json($cases->map(function($case) {
        return ['id' => $case->id, 'case_id' => $case->case_id];
    }));

    function renderDropdown(filter = '') {
        caseDropdown.innerHTML = '';
        const filteredCases = cases.filter(caseItem =>
            caseItem.case_id.toLowerCase().includes(filter.toLowerCase())
        );

        if (filteredCases.length === 0) {
            caseDropdown.innerHTML = '<div class="px-4 py-2 text-muted">No cases found</div>';
        } else {
            filteredCases.forEach(caseItem => {
                const optionDiv = document.createElement('div');
                optionDiv.className = 'px-4 py-2 hover:bg-gray-100 cursor-pointer';
                optionDiv.textContent = caseItem.case_id;
                optionDiv.addEventListener('click', () => {
                    caseSearchInput.value = caseItem.case_id;
                    caseIdInput.value = caseItem.id;
                    caseDropdown.style.display = 'none';
                });
                caseDropdown.appendChild(optionDiv);
            });
        }
    }

    // Show dropdown on input focus
    caseSearchInput.addEventListener('focus', () => {
        renderDropdown();
        caseDropdown.style.display = 'block';
    });

    // Filter dropdown on input
    caseSearchInput.addEventListener('input', (e) => {
        renderDropdown(e.target.value);
        caseDropdown.style.display = 'block';
    });

    // Hide dropdown when clicking outside
    document.addEventListener('click', (e) => {
        if (!caseDropdown.contains(e.target) && e.target !== caseSearchInput) {
            caseDropdown.style.display = 'none';
        }
    });

    // Set initial value if selected
    const selectedCaseId = '{{ request("case_id") }}';
    if (selectedCaseId) {
        const selectedCase = cases.find(c => c.id == selectedCaseId);
        if (selectedCase) {
            caseSearchInput.value = selectedCase.case_id;
            caseIdInput.value = selectedCase.id;
        }
    }
});
</script>
@endsection
