@extends('layouts.master')

@section('title', 'Enter Passcode')
@section('page-title', 'Enter Passcode')

@section('styles')
<style>
    /* Override master layout for full-screen centering */
    .main-content {
        margin-left: 0;
        padding: 0;
        min-height: 100vh;
        display: flex;
        align-items: center;
        justify-content: center;
    }

.passcode-container-wrapper {
    display: flex;
    justify-content: center;
    align-items: center;
    min-height: 100vh;
    background: linear-gradient(135deg, #e0f2fe, #f0f4f8);
}
.passcode-container {
    background-color: #fff;
    padding: 40px 30px;
    border-radius: 16px;
    box-shadow: 0 12px 24px rgba(0,0,0,0.08);
    display: flex;
    flex-direction: column;
    align-items: center;
    width: 100%;
    max-width: 360px;
}
.passcode-container h2 {
    margin-bottom: 30px;
    text-align: center;
    font-weight: 600;
    font-size: 1.5em;
    color: #1e293b;
}
.passcode-wrapper {
    display: flex;
    flex-direction: column;
    align-items: center;
    gap: 15px;
}
.passcode-inputs {
    display: flex;
    gap: 12px;
    justify-content: center;
}
.passcode-inputs input {
    width: 48px;
    height: 60px;
    font-size: 2em;
    text-align: center;
    border: 2px solid #cbd5e0;
    border-radius: 10px;
    outline: none;
    transition: all 0.2s;
    -webkit-text-security: disc;
    font-family: 'Inter', sans-serif;
}
.passcode-inputs input:focus {
    border-color: #3b82f6;
    box-shadow: 0 0 0 3px rgba(59,130,246,0.1);
}
.passcode-inputs input.show { -webkit-text-security: none; }
.toggle-eye {
    cursor: pointer;
    font-size: 1.1em;
    color: #3b82f6;
    user-select: none;
}
.reset-link {
    margin-top: 20px;
    font-size: 0.95em;
    color: #3b82f6;
    text-decoration: none;
}
.reset-link:hover { color: #1d4ed8; text-decoration: underline; }
.modal {
    position: fixed;
    inset: 0;
    display: none;
    justify-content: center;
    align-items: center;
    background: rgba(0,0,0,0.5);
    z-index: 1000;
}
.modal-content {
    background: #fff;
    padding: 30px;
    border-radius: 12px;
    text-align: center;
    max-width: 300px;
    width: 90%;
    box-shadow: 0 8px 16px rgba(0,0,0,0.2);
}
.modal-buttons {
    display: flex;
    justify-content: space-around;
    margin-top: 15px;
}
.modal-buttons button {
    padding: 8px 20px;
    border: none;
    border-radius: 8px;
    cursor: pointer;
}
.ok-btn { background: #cbd5e0; color: #1e293b; }
.go-btn { background: #3b82f6; color: #fff; }
@media (max-width: 360px) {
    .passcode-inputs input { width: 40px; height: 52px; font-size: 1.8em; }
}
</style>
@endsection

@section('content')
<div class="passcode-container-wrapper">
    <div class="passcode-container">
        <h2>Enter 6-Digit Passcode</h2>

        <form method="POST" action="{{ route('chat.passcode.verify') }}" id="passcode-form">
            @csrf
            <input type="hidden" name="passcode" id="passcode-hidden">
            <div class="passcode-wrapper">
                <div class="passcode-inputs">
                    @for($i=1; $i<=6; $i++)
                        <input type="tel" maxlength="1" inputmode="numeric" class="digit" id="digit{{ $i }}" data-index="{{ $i-1 }}" required>
                    @endfor
                </div>
                <span class="toggle-eye" id="toggle-eye">👁️ Show</span>
            </div>
            <a href="#" class="reset-link" id="reset-link">Reset Code</a>
        </form>
    </div>
</div>

<div class="modal" id="modal">
    <div class="modal-content">
        <p>Visit profile page</p>
        <div class="modal-buttons">
            <button type="button" class="ok-btn" id="ok-btn">OK</button>
            <button type="button" class="go-btn" id="go-btn">Go</button>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
document.addEventListener('DOMContentLoaded', () => {
    const inputs = document.querySelectorAll('.digit');
    const toggleEye = document.getElementById('toggle-eye');
    const resetLink = document.getElementById('reset-link');
    const modal = document.getElementById('modal');
    const okBtn = document.getElementById('ok-btn');
    const goBtn = document.getElementById('go-btn');
    const passcodeHidden = document.getElementById('passcode-hidden');
    const form = document.getElementById('passcode-form');

    // --- Handle typing and enforce numeric input ---
    inputs.forEach((input, index) => {
        input.addEventListener('input', e => {
            let val = e.target.value.replace(/\D/g, ''); // Remove non-digits
            if (!val) {
                e.target.value = '';
                updateHidden();
                return;
            }
            // If user pasted or typed multiple digits
            const digits = val.split('');
            let nextIndex = index;
            digits.forEach(d => {
                if (nextIndex < inputs.length) {
                    inputs[nextIndex].value = d;
                    nextIndex++;
                }
            });
            if (nextIndex < inputs.length) {
                inputs[nextIndex].focus();
            }
            updateHidden();
        });

        input.addEventListener('keydown', e => {
            if (e.key === 'Backspace' && !input.value && index > 0) {
                inputs[index - 1].focus();
            } else if (e.key === 'ArrowLeft' && index > 0) {
                inputs[index - 1].focus();
            } else if (e.key === 'ArrowRight' && index < inputs.length - 1) {
                inputs[index + 1].focus();
            }
        });
    });

    // --- Update hidden field and submit if full ---
    function updateHidden() {
        const code = Array.from(inputs).map(i => i.value).join('');
        passcodeHidden.value = code;
        if (code.length === 6) form.submit();
    }

    // --- Toggle visibility ---
    toggleEye.addEventListener('click', () => {
        inputs.forEach(i => i.classList.toggle('show'));
        toggleEye.textContent = inputs[0].classList.contains('show') ? '🙈 Hide' : '👁️ Show';
    });

    // --- Reset link and modal ---
    resetLink.addEventListener('click', e => {
        e.preventDefault();
        modal.style.display = 'flex';
    });
    okBtn.addEventListener('click', () => { modal.style.display = 'none'; });
    goBtn.addEventListener('click', () => { window.location.href = '{{ route("profile") }}'; });
    modal.addEventListener('click', e => { if (e.target === modal) modal.style.display = 'none'; });
});
</script>
@endpush

