@extends('layouts.master')

@section('page-title', 'Prolex Dashboard')

@push('styles')
<link rel="stylesheet" href="{{ asset('build/assets/dashboard-CMf1SiHJ.css') }}">
@endpush

@section('content')
<div class="dashboard-container" role="main">
    <!-- Dashboard Header -->
    <header class="dashboard-header">
        <h1 class="dashboard-title">Welcome back, {{ auth()->user()->name ?? 'User' }}!</h1>
        <p class="dashboard-subtitle">Here's your comprehensive legal practice overview for {{ date('l, F j, Y') }}</p>
    </header>

    <!-- Executive KPI Summary -->
    <section class="kpi-section" aria-labelledby="kpi-title">
        <div class="kpi-header">
            <h2 id="kpi-title" class="kpi-title">
                <i class="fas fa-chart-line" aria-hidden="true"></i>
                Executive Summary
            </h2>
            <span class="update-timestamp" aria-live="polite">
                <i class="fas fa-sync-alt" aria-hidden="true"></i> 
                <span class="sr-only">Last updated</span>
                Updated 5 mins ago
            </span>
        </div>
        <div class="kpi-grid">
            <div class="kpi-item status-green" role="article" aria-labelledby="kpi-dso">
                <div class="kpi-label" id="kpi-dso">DSO (Days Sales Outstanding)</div>
                <div class="kpi-value" aria-label="{{ $dashboardData['kpi']['dso'] ?? 42 }} days">{{ $dashboardData['kpi']['dso'] ?? 42 }} days</div>
                <div class="kpi-change positive" aria-label="Decreased by 8% from last month">
                    <i class="fas fa-arrow-down" aria-hidden="true"></i> -8% from last month
                </div>
            </div>
            <div class="kpi-item status-green" role="article" aria-labelledby="kpi-collection">
                <div class="kpi-label" id="kpi-collection">Collection Rate</div>
                <div class="kpi-value" aria-label="{{ $dashboardData['kpi']['collection_rate'] ?? 94 }} percent">{{ $dashboardData['kpi']['collection_rate'] ?? 94 }}%</div>
                <div class="kpi-change positive" aria-label="Increased by 3% from last month">
                    <i class="fas fa-arrow-up" aria-hidden="true"></i> +3% from last month
                </div>
            </div>
            <div class="kpi-item status-amber" role="article" aria-labelledby="kpi-realization">
                <div class="kpi-label" id="kpi-realization">Realization Rate</div>
                <div class="kpi-value" aria-label="{{ $dashboardData['kpi']['realization_rate'] ?? 87 }} percent">{{ $dashboardData['kpi']['realization_rate'] ?? 87 }}%</div>
                <div class="kpi-change neutral" aria-label="No change from last month">
                    <i class="fas fa-minus" aria-hidden="true"></i> No change
                </div>
            </div>
            <div class="kpi-item status-green" role="article" aria-labelledby="kpi-utilization">
                <div class="kpi-label" id="kpi-utilization">Utilization Rate</div>
                <div class="kpi-value" aria-label="{{ $dashboardData['kpi']['utilization_rate'] ?? 78 }} percent">{{ $dashboardData['kpi']['utilization_rate'] ?? 78 }}%</div>
                <div class="kpi-change positive" aria-label="Increased by 5% from last month">
                    <i class="fas fa-arrow-up" aria-hidden="true"></i> +5% from last month
                </div>
            </div>
            <div class="kpi-item status-red" role="article" aria-labelledby="kpi-wip">
                <div class="kpi-label" id="kpi-wip">Unbilled WIP</div>
                <div class="kpi-value" aria-label="{{ number_format($dashboardData['kpi']['unbilled_wip'] ?? 125000) }} dollars">${{ number_format($dashboardData['kpi']['unbilled_wip'] ?? 125000) }}</div>
                <div class="kpi-change negative" aria-label="Increased by 12%, aging concern">
                    <i class="fas fa-arrow-up" aria-hidden="true"></i> +12% aging concern
                </div>
            </div>
            <div class="kpi-item status-green" role="article" aria-labelledby="kpi-retention">
                <div class="kpi-label" id="kpi-retention">Client Retention</div>
                <div class="kpi-value" aria-label="{{ $dashboardData['kpi']['client_retention'] ?? 92 }} percent">{{ $dashboardData['kpi']['client_retention'] ?? 92 }}%</div>
                <div class="kpi-change positive" aria-label="Increased by 2% from last quarter">
                    <i class="fas fa-arrow-up" aria-hidden="true"></i> +2% from last quarter
                </div>
            </div>
        </div>
    </section>

    <!-- Enhanced Statistics Cards -->
    <section class="stats-grid" aria-label="Key Statistics">
        <article class="stat-card">
            <div class="stat-icon revenue" aria-hidden="true">
                <i class="fas fa-dollar-sign"></i>
            </div>
            <div class="stat-label">Monthly Revenue</div>
            <div class="stat-value" aria-label="{{ number_format($dashboardData['financial']['revenue'] ?? 485000) }} dollars">${{ number_format($dashboardData['financial']['revenue'] ?? 485000) }}</div>
            <div class="stat-trend positive" aria-label="Increased by 18% from last month">
                <i class="fas fa-arrow-up" aria-hidden="true"></i>
                +18% from last month
            </div>
        </article>

        <article class="stat-card">
            <div class="stat-icon cases" aria-hidden="true">
                <i class="fas fa-gavel"></i>
            </div>
            <div class="stat-label">Total Cases</div>
            <div class="stat-value" aria-label="{{ number_format($dashboardData['total_cases']) }} cases">{{ number_format($dashboardData['total_cases']) }}</div>
            <div class="stat-trend positive" aria-label="Increased by 12% from last month">
                <i class="fas fa-arrow-up" aria-hidden="true"></i>
                +12% from last month
            </div>
        </article>

        <article class="stat-card">
            <div class="stat-icon active" aria-hidden="true">
                <i class="fas fa-clock"></i>
            </div>
            <div class="stat-label">Active Matters</div>
            <div class="stat-value" aria-label="{{ number_format($dashboardData['active_cases']) }} active matters">{{ number_format($dashboardData['active_cases']) }}</div>
            <div class="stat-trend positive" aria-label="Increased by 8% from last month">
                <i class="fas fa-arrow-up" aria-hidden="true"></i>
                +8% from last month
            </div>
        </article>

        <article class="stat-card">
            <div class="stat-icon clients" aria-hidden="true">
                <i class="fas fa-users"></i>
            </div>
            <div class="stat-label">Active Clients</div>
            <div class="stat-value" aria-label="{{ $dashboardData['clients']['active'] ?? 156 }} active clients">{{ $dashboardData['clients']['active'] ?? 156 }}</div>
            <div class="stat-trend positive" aria-label="6 new clients this month">
                <i class="fas fa-arrow-up" aria-hidden="true"></i>
                +6 new this month
            </div>
        </article>

        <article class="stat-card">
            <div class="stat-icon utilization" aria-hidden="true">
                <i class="fas fa-chart-bar"></i>
            </div>
            <div class="stat-label">Billable Hours (MTD)</div>
            <div class="stat-value" aria-label="{{ number_format($dashboardData['billable_hours'] ?? 1247) }} billable hours">{{ number_format($dashboardData['billable_hours'] ?? 1247) }}</div>
            <div class="stat-trend positive" aria-label="Increased by 14% from last month">
                <i class="fas fa-arrow-up" aria-hidden="true"></i>
                +14% from last month
            </div>
        </article>

        <article class="stat-card">
            <div class="stat-icon settled" aria-hidden="true">
                <i class="fas fa-check-circle"></i>
            </div>
            <div class="stat-label">Settled Cases</div>
            <div class="stat-value" aria-label="{{ number_format($dashboardData['settled_cases']) }} settled cases">{{ number_format($dashboardData['settled_cases']) }}</div>
            <div class="stat-trend positive" aria-label="Increased by 15% from last month">
                <i class="fas fa-arrow-up" aria-hidden="true"></i>
                +15% from last month
            </div>
        </article>

        <article class="stat-card">
            <div class="stat-icon win-rate" aria-hidden="true">
                <i class="fas fa-trophy"></i>
            </div>
            <div class="stat-label">Win Rate</div>
            <div class="stat-value" aria-label="{{ $dashboardData['win_rate'] }} percent win rate">{{ $dashboardData['win_rate'] }}<span class="stat-unit">%</span></div>
            <div class="stat-trend positive" aria-label="Increased by 5% from last month">
                <i class="fas fa-arrow-up" aria-hidden="true"></i>
                +5% from last month
            </div>
        </article>

        <article class="stat-card">
            <div class="stat-icon collection" aria-hidden="true">
                <i class="fas fa-wallet"></i>
            </div>
            <div class="stat-label">AR Balance</div>
            <div class="stat-value" aria-label="{{ number_format($dashboardData['financial']['ar_balance'] ?? 187500) }} dollars accounts receivable">${{ number_format($dashboardData['financial']['ar_balance'] ?? 187500) }}</div>
            <div class="stat-trend negative" aria-label="Needs attention">
                <i class="fas fa-exclamation-triangle" aria-hidden="true"></i>
                Needs attention
            </div>
        </article>
    </section>

    <!-- Charts Section -->
    <section class="charts-section" aria-label="Data Visualizations">
        <!-- Revenue Trend -->
        <article class="chart-card">
            <div class="chart-header">
                <div>
                    <h3 class="chart-title">
                        <i class="fas fa-chart-line" aria-hidden="true"></i>
                        Revenue Trend
                    </h3>
                    <p class="chart-subtitle">Last 6 months performance</p>
                </div>
            </div>
            <div class="chart-container">
                <canvas id="revenueChart" role="img" aria-label="Revenue trend chart showing monthly performance over the last 6 months"></canvas>
            </div>
        </article>

        <!-- Practice Area Distribution -->
        <article class="chart-card">
            <div class="chart-header">
                <div>
                    <h3 class="chart-title">
                        <i class="fas fa-balance-scale" aria-hidden="true"></i>
                        Practice Area Revenue
                    </h3>
                    <p class="chart-subtitle">Distribution by practice area</p>
                </div>
            </div>
            <div class="chart-container">
                <canvas id="practiceAreaChart" role="img" aria-label="Pie chart showing revenue distribution across practice areas"></canvas>
            </div>
        </article>

        <!-- Utilization Rate -->
        <article class="chart-card">
            <div class="chart-header">
                <div>
                    <h3 class="chart-title">
                        <i class="fas fa-user-clock" aria-hidden="true"></i>
                        Attorney Utilization
                    </h3>
                    <p class="chart-subtitle">Billable vs non-billable hours</p>
                </div>
            </div>
            <div class="chart-container">
                <canvas id="utilizationChart" role="img" aria-label="Bar chart comparing billable and non-billable hours by week"></canvas>
            </div>
        </article>

        <!-- AR Aging -->
        <article class="chart-card">
            <div class="chart-header">
                <div>
                    <h3 class="chart-title">
                        <i class="fas fa-money-bill-wave" aria-hidden="true"></i>
                        AR Aging Analysis
                    </h3>
                    <p class="chart-subtitle">Accounts receivable by age bucket</p>
                </div>
            </div>
            <div class="chart-container">
                <canvas id="arAgingChart" role="img" aria-label="Horizontal bar chart showing accounts receivable aging by time period"></canvas>
            </div>
        </article>

        <!-- Matter Performance -->
        <article class="chart-card chart-full-width">
            <div class="chart-header">
                <div>
                    <h3 class="chart-title">
                        <i class="fas fa-briefcase" aria-hidden="true"></i>
                        Matter Performance Tracker
                    </h3>
                    <p class="chart-subtitle">Budget vs Actual spend by matter</p>
                </div>
            </div>
            <div class="chart-container">
                <canvas id="matterPerformanceChart" role="img" aria-label="Bar chart comparing budgeted versus actual spending across different matters"></canvas>
            </div>
        </article>

        <!-- Time Tracking -->
        <article class="chart-card">
            <div class="chart-header">
                <div>
                    <h3 class="chart-title">
                        <i class="fas fa-clock" aria-hidden="true"></i>
                        Time Tracking Trends
                    </h3>
                    <p class="chart-subtitle">Billable hours over time</p>
                </div>
            </div>
            <div class="chart-container">
                <canvas id="timeTrackingChart" role="img" aria-label="Line chart showing billable hours trends over the past 6 weeks"></canvas>
            </div>
        </article>

        <!-- Financial Overview -->
        <article class="chart-card">
            <div class="chart-header">
                <div>
                    <h3 class="chart-title">
                        <i class="fas fa-chart-pie" aria-hidden="true"></i>
                        Financial Overview
                    </h3>
                    <p class="chart-subtitle">Revenue, Expenses & Profit</p>
                </div>
            </div>
            <div class="chart-container">
                <canvas id="financialChart" role="img" aria-label="Doughnut chart showing financial breakdown of revenue, expenses, and profit"></canvas>
            </div>
        </article>
    </section>

    <!-- Activity Section -->
    <section class="activity-section" aria-label="Recent Activity and Upcoming Deadlines">
        <article class="activity-card">
            <div class="activity-header">
                <h3 class="activity-title">Recent Activity</h3>
                <a href="#" class="view-all-link" aria-label="View all recent activity">View All</a>
            </div>
            <div class="activity-list">
                @foreach($dashboardData['recentActivity'] as $activity)
                <div class="activity-item">
                    <div class="activity-avatar" aria-hidden="true">
                        {{ strtoupper(substr($activity->client->full_name, 0, 1)) }}
                    </div>
                    <div class="activity-content">
                        <div class="activity-text">{{ $activity->client->full_name }}</div>
                        <div class="activity-meta">Case: {{ $activity->case_code }} • {{ $activity->updated_at->diffForHumans() }}</div>
                    </div>
                </div>
                @endforeach
            </div>
        </article>

        <article class="activity-card">
            <div class="activity-header">
                <h3 class="activity-title">Upcoming Deadlines</h3>
                <a href="#" class="view-all-link" aria-label="View calendar">View Calendar</a>
            </div>
            <div class="activity-list">
                @foreach($dashboardData['deadlines']['today'] as $deadline)
                <div class="activity-item">
                    <div class="activity-avatar activity-avatar-deadline" aria-hidden="true">
                        <i class="fas fa-calendar-day"></i>
                    </div>
                    <div class="activity-content">
                        <div class="activity-text">{{ $deadline['title'] }}</div>
                        <div class="activity-meta">{{ $deadline['time'] }} • {{ $deadline['location'] }}</div>
                    </div>
                </div>
                @endforeach
            </div>
        </article>
    </section>

    <!-- Tasks Section -->
    <section class="tasks-section" aria-labelledby="tasks-title">
        <div class="tasks-header">
            <h3 id="tasks-title" class="tasks-title">
                <i class="fas fa-tasks" aria-hidden="true"></i>
                Daily Tasks
            </h3>
            <a href="#" class="view-all-link" aria-label="View all tasks">View All Tasks</a>
        </div>

        <div class="task-tabs" role="tablist" aria-label="Task categories">
            <button class="task-tab active" 
                    role="tab" 
                    aria-selected="true" 
                    aria-controls="daily-tasks" 
                    id="tab-daily"
                    data-tab="daily">
                <i class="fas fa-calendar-day" aria-hidden="true"></i> Daily
            </button>
            <button class="task-tab" 
                    role="tab" 
                    aria-selected="false" 
                    aria-controls="overdue-tasks" 
                    id="tab-overdue"
                    data-tab="overdue">
                <i class="fas fa-exclamation-circle" aria-hidden="true"></i> Overdue
            </button>
        </div>

        <div id="daily-tasks" role="tabpanel" aria-labelledby="tab-daily">
            @foreach($dashboardData['tasks']['daily'] as $task)
            <div class="task-item">
                <input type="checkbox" 
                       class="task-checkbox" 
                       id="task-{{ $loop->index }}"
                       aria-label="Mark task as complete: {{ $task['title'] }}">
                <label for="task-{{ $loop->index }}" class="task-content">
                    <div class="task-title">{{ $task['title'] }}</div>
                    <div class="task-meta">
                        <span class="task-priority priority-{{ $task['priority'] }}" aria-label="Priority: {{ $task['priority'] }}">{{ $task['priority'] }}</span>
                        <span aria-hidden="true">•</span>
                        <span>Assigned to {{ $task['assigned'] }}</span>
                        <span aria-hidden="true">•</span>
                        <span>Due {{ $task['due'] }}</span>
                    </div>
                </label>
            </div>
            @endforeach
        </div>

        <div id="overdue-tasks" role="tabpanel" aria-labelledby="tab-overdue" hidden>
            @foreach($dashboardData['tasks']['overdue'] as $task)
            <div class="task-item task-item-overdue">
                <input type="checkbox" 
                       class="task-checkbox" 
                       id="task-overdue-{{ $loop->index }}"
                       aria-label="Mark overdue task as complete: {{ $task['title'] }}">
                <label for="task-overdue-{{ $loop->index }}" class="task-content">
                    <div class="task-title">{{ $task['title'] }}</div>
                    <div class="task-meta">
                        <span class="task-priority priority-high" aria-label="Priority: High">High</span>
                        <span aria-hidden="true">•</span>
                        <span>Assigned to {{ $task['assigned'] }}</span>
                        <span aria-hidden="true">•</span>
                        <span>Overdue by {{ $task['overdue'] }}</span>
                    </div>
                </label>
            </div>
            @endforeach
        </div>
    </section>

    <!-- Legal News & Research Section -->
    <section class="news-section" aria-labelledby="news-title">
        <div class="news-header">
            <h2 id="news-title" class="news-title">
                <i class="fas fa-newspaper" aria-hidden="true"></i>
                Legal News & Research
            </h2>
        </div>
        
        <div class="search-container">
            <label for="newsSearch" class="sr-only">Search legal news</label>
            <input 
                type="search" 
                class="search-input" 
                id="newsSearch" 
                placeholder="Search legal news, cases, regulations, and articles..."
                autocomplete="off"
                aria-describedby="search-help"
            >
            <button class="search-btn" 
                    onclick="DashboardApp.searchNews()" 
                    aria-label="Search for legal news">
                <i class="fas fa-search" aria-hidden="true"></i> Search
            </button>
            <span id="search-help" class="sr-only">Press Enter to search or click the search button</span>
        </div>

        <div id="newsResults" class="news-results" role="region" aria-live="polite" aria-label="Search results">
            <!-- Default placeholder content -->
            <div class="empty-state">
                <i class="fas fa-search" aria-hidden="true"></i>
                <p class="empty-state-title">Search for legal news and articles</p>
                <p class="empty-state-subtitle">Enter keywords to find relevant legal updates, case law, and industry news</p>
            </div>
        </div>
    </section>
</div>
@endsection

@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script src="{{ asset('build/assets/global-B6Q43Z5T.js') }}"></script>
<script src="{{ asset('build/assets/dashboard-CTGaDHB_.js') }}"></script>
<script src="{{ asset('build/assets/dashboard-charts-Em1mcUxC.js') }}"></script>
<script src="{{ asset('build/assets/dashboard-app-Bbyhp3xg.js') }}"></script>
<script>
    // Initialize dashboard with server data
    document.addEventListener('DOMContentLoaded', function() {
        const serverData = {
            timeTrackingData: {!! json_encode($dashboardData['timeTracking']['trends'] ?? [285, 310, 298, 354, 342, 368]) !!},
            financialData: {
                revenue: {{ $dashboardData['financial']['performance']['revenue'] ?? 485000 }},
                expenses: {{ $dashboardData['financial']['performance']['expenses'] ?? 312000 }},
                profit: {{ $dashboardData['financial']['performance']['profit'] ?? 173000 }}
            }
        };
        
        DashboardApp.init(serverData);
    });
</script>
@endpush