<!DOCTYPE html>
<html lang="en">
<body style="margin:0; padding:0; background-color:#eef1f4; font-family:Arial, Helvetica, sans-serif;">

<table width="100%" cellpadding="0" cellspacing="0" style="background-color:#eef1f4; padding:24px;">
    <tr>
        <td align="center">

            <!-- Container -->
            <table width="600" cellpadding="0" cellspacing="0" style="background-color:#ffffff; border-collapse:collapse;">

                <!-- Header -->
                <tr>
                    <td style="background-color:#0d6efd; padding:18px; text-align:center;">
                        <span style="color:#ffffff; font-size:18px; font-weight:bold;">
                            Password Reset Verification
                        </span>
                    </td>
                </tr>

                <!-- Body -->
                <tr>
                    <td style="padding:28px; font-size:15px; color:#333333; line-height:1.5;">

                        <!-- Multi-language fallback -->
                        <p style="margin:0 0 16px 0;">
                            {{ $user_language === 'en' ? 'Dear User,' : 'Cher Utilisateur,' }}
                        </p>

                        <p style="margin:0 0 16px 0;">
                            {{ $user_language === 'en' 
                                ? 'A request was received to reset the password for your account. To continue, please enter the One-Time Password (OTP) shown below.'
                                : 'Une demande de réinitialisation de mot de passe a été reçue pour votre compte. Pour continuer, veuillez saisir le code à usage unique (OTP) ci-dessous.' }}
                        </p>

                        <!-- OTP Block -->
                        <table align="center" cellpadding="0" cellspacing="0" style="margin:24px auto;">
                            <tr>
                                <td style="
                                    font-size:26px;
                                    font-weight:bold;
                                    letter-spacing:3px;
                                    color:#0d6efd;
                                    background-color:#f1f5ff;
                                    padding:14px 36px;
                                    border:1px solid #cdd9ff;
                                ">
                                    {{ $otp }}
                                </td>
                            </tr>
                        </table>

                        <p style="margin:0 0 16px 0;">
                            {{ $user_language === 'en'
                                ? 'This OTP is valid for' 
                                : "Ce code OTP est valable pendant" }}
                            <strong>{{ $expiry }} minutes</strong>
                            {{ $user_language === 'en'
                                ? 'and may only be used once.'
                                : "et ne peut être utilisé qu'une seule fois." }}
                        </p>

                        <p style="margin:0 0 16px 0;">
                            {{ $user_language === 'en'
                                ? 'If you did not request a password reset, no further action is required. For your security, we recommend reviewing your account activity.'
                                : "Si vous n'avez pas demandé de réinitialisation de mot de passe, aucune action supplémentaire n'est requise. Pour votre sécurité, nous vous recommandons de vérifier l'activité de votre compte." }}
                        </p>

                        <p style="margin:24px 0 0 0;">
                            {{ $user_language === 'en' 
                                ? 'Kind regards,' 
                                : 'Cordialement,' }}<br>
                            <strong>Melsoft Private Limited</strong><br>
                            <span style="color:#666666;">melsoftprolex@gmail.com</span>
                        </p>
                    </td>
                </tr>

                <!-- Footer -->
                <tr>
                    <td style="background-color:#f8f9fb; padding:14px; font-size:12px; color:#777777; text-align:center;">
                        {{ $user_language === 'en'
                            ? 'This is an automated message. Please do not reply.'
                            : "Ceci est un message automatique. Merci de ne pas répondre." }}
                    </td>
                </tr>

            </table>

        </td>
    </tr>
</table>

</body>
</html>
