<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Password Reset - Prolex Legal System</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            line-height: 1.6;
            color: #333;
            max-width: 600px;
            margin: 0 auto;
            padding: 20px;
            background-color: #f4f4f4;
        }
        .container {
            background-color: #ffffff;
            padding: 30px;
            border-radius: 8px;
            box-shadow: 0 0 10px rgba(0,0,0,0.1);
        }
        .header {
            text-align: center;
            margin-bottom: 30px;
        }
        .header h1 {
            color: #2c3e50;
            margin: 0;
            font-size: 24px;
        }
        .content {
            margin-bottom: 30px;
        }
        .button {
            display: inline-block;
            padding: 12px 24px;
            background-color: #3498db;
            color: #ffffff;
            text-decoration: none;
            border-radius: 5px;
            font-weight: bold;
            text-align: center;
        }
        .button:hover {
            background-color: #2980b9;
        }
        .footer {
            margin-top: 30px;
            padding-top: 20px;
            border-top: 1px solid #eee;
            font-size: 12px;
            color: #666;
            text-align: center;
        }
        .warning {
            background-color: #fff3cd;
            border: 1px solid #ffeaa7;
            padding: 15px;
            border-radius: 5px;
            margin: 20px 0;
        }
        .token-display {
            background-color: #f8f9fa;
            border: 1px solid #dee2e6;
            padding: 15px;
            border-radius: 5px;
            font-family: monospace;
            word-break: break-all;
            margin: 15px 0;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>Password Reset Request</h1>
        </div>

        <div class="content">
            <p>Dear {{ $userName }},</p>

            <p>You have requested to reset your password for your Prolex Legal System account. To proceed with the password reset, please click the button below:</p>

            <div style="text-align: center; margin: 30px 0;">
                <a href="{{ $resetLink }}" class="button">Reset Password</a>
            </div>

            <p>If the button doesn't work, you can copy and paste this link into your browser:</p>
            <p><a href="{{ $resetLink }}">{{ $resetLink }}</a></p>

            <div class="warning">
                <strong>Security Notice:</strong> This link will expire in 15 minutes for your security. If you did not request this password reset, please ignore this email.
            </div>

            <p>If you have any questions or need assistance, please contact our support team.</p>

            <p>Best regards,<br>
            Prolex Legal System Team</p>
        </div>

        <div class="footer">
            <p>This email was sent to you because a password reset was requested for your account. If you did not make this request, please contact support immediately.</p>
            <p>&copy; 2024 Prolex Legal System. All rights reserved.</p>
        </div>
    </div>
</body>
</html>
