<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>@yield('page-title', 'Prolex Legal System')</title>

    <!-- Font Awesome 6 -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">

    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Inter', sans-serif;
            background: linear-gradient(135deg, #1e3a8a 0%, #1e40af 50%, #2563eb 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            position: relative;
            overflow-x: hidden;
        }

        /* Animated Background Pattern - Scales of Justice */
        body::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background-image:
                radial-gradient(circle at 20% 50%, rgba(217, 119, 6, 0.1) 0%, transparent 50%),
                radial-gradient(circle at 80% 80%, rgba(245, 158, 11, 0.1) 0%, transparent 50%),
                url("data:image/svg+xml,%3Csvg width='60' height='60' viewBox='0 0 60 60' xmlns='http://www.w3.org/2000/svg'%3E%3Cg fill='none' fill-rule='evenodd'%3E%3Cg fill='%23ffffff' fill-opacity='0.03'%3E%3Cpath d='M36 34v-4h-2v4h-4v2h4v4h2v-4h4v-2h-4zm0-30V0h-2v4h-4v2h4v4h2V6h4V4h-4zM6 34v-4H4v4H0v2h4v4h2v-4h4v-2H6zM6 4V0H4v4H0v6h4v4h2V6h4V4H6z'/%3E%3C/g%3E%3C/g%3E%3C/svg%3E");
            opacity: 0.4;
            animation: backgroundShift 20s ease-in-out infinite;
            z-index: 0;
        }

        @keyframes backgroundShift {
            0%, 100% { transform: translateY(0) scale(1); }
            50% { transform: translateY(-20px) scale(1.05); }
        }

        /* Floating Justice Scale Decoration */
        .justice-scale {
            position: fixed;
            font-size: 200px;
            color: rgba(255, 255, 255, 0.05);
            z-index: 0;
            animation: float 6s ease-in-out infinite;
        }

        .justice-scale.left {
            top: 10%;
            left: -50px;
            transform: rotate(-15deg);
        }

        .justice-scale.right {
            bottom: 10%;
            right: -50px;
            transform: rotate(15deg);
            animation-delay: 3s;
        }

        @keyframes float {
            0%, 100% { transform: translateY(0) rotate(-15deg); }
            50% { transform: translateY(-30px) rotate(-12deg); }
        }

        .auth-container {
            background: rgba(255, 255, 255, 0.98);
            border-radius: 24px;
            box-shadow:
                0 20px 60px rgba(0, 0, 0, 0.3),
                0 0 100px rgba(37, 99, 235, 0.2),
                inset 0 1px 0 rgba(255, 255, 255, 0.9);
            overflow: hidden;
            max-width: 450px;
            width: 100%;
            margin: 20px;
            position: relative;
            z-index: 1;
            backdrop-filter: blur(20px);
            border: 1px solid rgba(255, 255, 255, 0.3);
        }

        .auth-header {
            background: linear-gradient(135deg, #1e3a8a 0%, #2563eb 100%);
            color: white;
            padding: 40px 30px 30px;
            text-align: center;
            position: relative;
            overflow: hidden;
        }

        .auth-header::before {
            content: '';
            position: absolute;
            top: -50%;
            left: -50%;
            width: 200%;
            height: 200%;
            background: radial-gradient(circle, rgba(255, 255, 255, 0.1) 0%, transparent 70%);
            animation: shimmer 8s linear infinite;
        }

        @keyframes shimmer {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }

        .logo-wrapper {
            position: relative;
            z-index: 1;
        }

        .logo-image {
            width: 100px;
            height: 100px;
            margin: 0 auto 20px;
            display: block;
            border-radius: 50%;
            border: 4px solid rgba(255, 255, 255, 0.3);
            padding: 10px;
            background: rgba(255, 255, 255, 0.1);
            backdrop-filter: blur(10px);
            box-shadow: 0 8px 20px rgba(0, 0, 0, 0.2);
            animation: logoGlow 3s ease-in-out infinite;
        }

        @keyframes logoGlow {
            0%, 100% { box-shadow: 0 8px 20px rgba(0, 0, 0, 0.2), 0 0 30px rgba(245, 158, 11, 0.3); }
            50% { box-shadow: 0 8px 20px rgba(0, 0, 0, 0.2), 0 0 50px rgba(245, 158, 11, 0.5); }
        }

        .auth-title {
            font-size: 28px;
            font-weight: 700;
            margin: 0 0 8px 0;
            text-shadow: 2px 2px 4px rgba(0, 0, 0, 0.2);
            letter-spacing: -0.5px;
        }

        .auth-subtitle {
            font-size: 15px;
            opacity: 0.95;
            margin: 0;
            font-weight: 400;
            color: #d1d5db;
        }

        .auth-body {
            padding: 35px 30px;
        }

        .form-group {
            margin-bottom: 24px;
            position: relative;
        }

        .form-label {
            font-weight: 600;
            color: #1f2937;
            margin-bottom: 10px;
            display: flex;
            align-items: center;
            font-size: 14px;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }

        .form-label i {
            margin-right: 8px;
            color: #2563eb;
        }

        .input-wrapper {
            position: relative;
        }

        .input-icon {
            position: absolute;
            left: 16px;
            top: 50%;
            transform: translateY(-50%);
            color: #6b7280;
            font-size: 18px;
            transition: color 0.3s ease;
            pointer-events: none;
        }

        .form-control {
            border: 2px solid #e5e7eb;
            border-radius: 12px;
            padding: 14px 16px 14px 48px;
            font-size: 16px;
            transition: all 0.3s ease;
            background: #f9fafb;
            width: 100%;
            font-family: 'Inter', sans-serif;
        }

        .form-control:focus {
            border-color: #2563eb;
            box-shadow: 0 0 0 4px rgba(37, 99, 235, 0.1);
            background: white;
            outline: none;
        }

        .form-control:focus + .input-icon {
            color: #2563eb;
        }

        .form-control.error {
            border-color: #ef4444;
            background: #fef2f2;
        }

        .form-control.success {
            border-color: #10b981;
            background: #f0fdf4;
        }

        .password-toggle {
            position: absolute;
            right: 16px;
            top: 50%;
            transform: translateY(-50%);
            color: #6b7280;
            cursor: pointer;
            font-size: 18px;
            transition: color 0.3s ease;
            z-index: 2;
        }

        .password-toggle:hover {
            color: #2563eb;
        }

        .error-message {
            color: #ef4444;
            font-size: 13px;
            margin-top: 6px;
            display: flex;
            align-items: center;
            animation: slideDown 0.3s ease;
        }

        .error-message i {
            margin-right: 6px;
        }

        @keyframes slideDown {
            from {
                opacity: 0;
                transform: translateY(-5px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        .success-message {
            color: #10b981;
            font-size: 13px;
            margin-top: 6px;
            display: flex;
            align-items: center;
            animation: slideDown 0.3s ease;
        }

        .success-message i {
            margin-right: 6px;
        }

        .form-check {
            display: flex;
            align-items: center;
            margin-bottom: 24px;
        }

        .form-check-input {
            width: 20px;
            height: 20px;
            margin-right: 12px;
            border: 2px solid #d1d5db;
            border-radius: 6px;
            cursor: pointer;
            transition: all 0.3s ease;
            appearance: none;
            position: relative;
        }

        .form-check-input:checked {
            background: #2563eb;
            border-color: #2563eb;
        }

        .form-check-input:checked::after {
            content: '\f00c';
            font-family: 'Font Awesome 6 Free';
            font-weight: 900;
            position: absolute;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            color: white;
            font-size: 12px;
        }

        .form-check-label {
            font-weight: 500;
            color: #4b5563;
            cursor: pointer;
            user-select: none;
        }

        .btn-auth {
            background: linear-gradient(135deg, #2563eb 0%, #1e40af 100%);
            border: none;
            border-radius: 12px;
            padding: 15px 30px;
            font-size: 16px;
            font-weight: 600;
            color: white;
            width: 100%;
            transition: all 0.3s ease;
            text-transform: uppercase;
            letter-spacing: 1px;
            cursor: pointer;
            position: relative;
            overflow: hidden;
            box-shadow: 0 4px 15px rgba(37, 99, 235, 0.3);
        }

        .btn-auth::before {
            content: '';
            position: absolute;
            top: 0;
            left: -100%;
            width: 100%;
            height: 100%;
            background: linear-gradient(90deg, transparent, rgba(255, 255, 255, 0.2), transparent);
            transition: left 0.5s ease;
        }

        .btn-auth:hover::before {
            left: 100%;
        }

        .btn-auth:hover {
            background: linear-gradient(135deg, #1e40af 0%, #1e3a8a 100%);
            transform: translateY(-2px);
            box-shadow: 0 6px 20px rgba(37, 99, 235, 0.4);
        }

        .btn-auth:active {
            transform: translateY(0);
        }

        .btn-auth:disabled {
            opacity: 0.6;
            cursor: not-allowed;
            transform: none;
        }

        .auth-footer {
            text-align: center;
            margin-top: 24px;
            padding-top: 24px;
            border-top: 1px solid #e5e7eb;
        }

        .auth-link {
            color: #2563eb;
            text-decoration: none;
            font-weight: 600;
            transition: all 0.3s ease;
            display: inline-flex;
            align-items: center;
        }

        .auth-link i {
            margin-right: 6px;
        }

        .auth-link:hover {
            color: #1e40af;
            text-decoration: underline;
        }

        .alert {
            border-radius: 12px;
            border: none;
            margin-bottom: 24px;
            padding: 14px 18px;
            display: flex;
            align-items: center;
            animation: slideDown 0.3s ease;
        }

        .alert i {
            margin-right: 10px;
            font-size: 18px;
        }

        .alert-danger {
            background: linear-gradient(135deg, #fee2e2 0%, #fecaca 100%);
            color: #991b1b;
            border-left: 4px solid #ef4444;
        }

        .alert-success {
            background: linear-gradient(135deg, #d1fae5 0%, #a7f3d0 100%);
            color: #065f46;
            border-left: 4px solid #10b981;
        }

        .alert-info {
            background: linear-gradient(135deg, #dbeafe 0%, #bfdbfe 100%);
            color: #1e40af;
            border-left: 4px solid #3b82f6;
        }

        .alert ul {
            margin: 0;
            padding-left: 20px;
        }

        .password-strength {
            margin-top: 8px;
            height: 4px;
            background: #e5e7eb;
            border-radius: 2px;
            overflow: hidden;
            transition: all 0.3s ease;
        }

        .password-strength-bar {
            height: 100%;
            transition: all 0.3s ease;
            border-radius: 2px;
        }

        .password-strength-text {
            font-size: 12px;
            margin-top: 4px;
            font-weight: 600;
        }

        @media (max-width: 480px) {
            .auth-container {
                margin: 10px;
                border-radius: 20px;
            }

            .auth-header {
                padding: 30px 20px 25px;
            }

            .logo-image {
                width: 80px;
                height: 80px;
            }

            .auth-title {
                font-size: 24px;
            }

            .auth-body {
                padding: 30px 20px;
            }

            .justice-scale {
                font-size: 150px;
            }
        }

        /* Loading Spinner */
        .spinner {
            display: inline-block;
            width: 16px;
            height: 16px;
            border: 2px solid rgba(255, 255, 255, 0.3);
            border-radius: 50%;
            border-top-color: white;
            animation: spin 0.8s linear infinite;
            margin-left: 10px;
        }

        @keyframes spin {
            to { transform: rotate(360deg); }
        }
    </style>

    @stack('styles')
</head>
<body>
    <!-- Floating Justice Scales -->
    <i class="fas fa-balance-scale justice-scale left"></i>
    <i class="fas fa-balance-scale justice-scale right"></i>

    @yield('content')

    <script src="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/js/all.min.js"></script>

    <script>
        // Enhanced Form Validation System
        class AuthValidator {
            constructor(form) {
                this.form = form;
                this.fields = {};
                this.isSubmitting = false;
                this.init();
            }

            init() {
                // Email validation
                const emailInput = this.form.querySelector('input[type="email"]');
                if (emailInput) {
                    this.fields.email = emailInput;
                    emailInput.addEventListener('input', () => this.validateEmail());
                    emailInput.addEventListener('blur', () => this.validateEmail());
                }

                // Password validation
                const passwordInput = this.form.querySelector('input[name="password"]');
                if (passwordInput) {
                    this.fields.password = passwordInput;
                    passwordInput.addEventListener('input', () => this.validatePassword());
                    passwordInput.addEventListener('blur', () => this.validatePassword());

                    // Password visibility toggle
                    this.setupPasswordToggle(passwordInput);
                }

                // Password confirmation validation
                const confirmInput = this.form.querySelector('input[name="password_confirmation"]');
                if (confirmInput) {
                    this.fields.passwordConfirmation = confirmInput;
                    confirmInput.addEventListener('input', () => this.validatePasswordConfirmation());
                    confirmInput.addEventListener('blur', () => this.validatePasswordConfirmation());

                    this.setupPasswordToggle(confirmInput);
                }

                // OTP validation
                const otpInput = this.form.querySelector('input[name="otp"]');
                if (otpInput) {
                    this.fields.otp = otpInput;
                    otpInput.addEventListener('input', () => this.validateOTP());
                    otpInput.addEventListener('blur', () => this.validateOTP());
                }

                // Form submission
                this.form.addEventListener('submit', (e) => this.handleSubmit(e));
            }

            setupPasswordToggle(input) {
                const wrapper = input.closest('.input-wrapper');
                const toggleBtn = wrapper.querySelector('.password-toggle');

                if (toggleBtn) {
                    toggleBtn.addEventListener('click', () => {
                        const type = input.type === 'password' ? 'text' : 'password';
                        input.type = type;

                        const icon = toggleBtn.querySelector('i');
                        icon.classList.toggle('fa-eye');
                        icon.classList.toggle('fa-eye-slash');
                    });
                }
            }

            validateEmail() {
                const input = this.fields.email;
                const value = input.value.trim();
                const wrapper = input.closest('.form-group');

                // Remove previous messages
                this.clearMessages(wrapper);

                if (!value) {
                    this.showError(wrapper, input, 'Email address is required');
                    return false;
                }

                const emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
                if (!emailRegex.test(value)) {
                    this.showError(wrapper, input, 'Please enter a valid email address');
                    return false;
                }

                // Advanced email validation
                const parts = value.split('@');
                if (parts[0].length < 2) {
                    this.showError(wrapper, input, 'Email username must be at least 2 characters');
                    return false;
                }

                const domain = parts[1];
                if (domain.split('.').some(part => part.length < 2)) {
                    this.showError(wrapper, input, 'Invalid email domain');
                    return false;
                }

                this.showSuccess(wrapper, input, 'Valid email address');
                return true;
            }

            validatePassword() {
                const input = this.fields.password;
                const value = input.value;
                const wrapper = input.closest('.form-group');

                this.clearMessages(wrapper);

                if (!value) {
                    this.showError(wrapper, input, 'Password is required');
                    this.updatePasswordStrength(0, '');
                    return false;
                }

                // Check password requirements
                const minLength = 8;
                const errors = [];

                if (value.length < minLength) {
                    errors.push(`at least ${minLength} characters`);
                }
                if (!/[a-z]/.test(value)) {
                    errors.push('lowercase letter');
                }
                if (!/[A-Z]/.test(value)) {
                    errors.push('uppercase letter');
                }
                if (!/[0-9]/.test(value)) {
                    errors.push('number');
                }
                if (!/[^a-zA-Z0-9]/.test(value)) {
                    errors.push('special character');
                }

                // Calculate password strength
                let strength = 0;
                if (value.length >= 8) strength += 20;
                if (value.length >= 12) strength += 20;
                if (/[a-z]/.test(value)) strength += 15;
                if (/[A-Z]/.test(value)) strength += 15;
                if (/[0-9]/.test(value)) strength += 15;
                if (/[^a-zA-Z0-9]/.test(value)) strength += 15;

                if (errors.length > 0) {
                    this.showError(wrapper, input, `Password must include: ${errors.join(', ')}`);
                    this.updatePasswordStrength(strength, this.getStrengthLabel(strength));
                    return false;
                }

                this.showSuccess(wrapper, input, 'Strong password');
                this.updatePasswordStrength(100, 'Strong');
                return true;
            }

            validatePasswordConfirmation() {
                const input = this.fields.passwordConfirmation;
                const password = this.fields.password.value;
                const value = input.value;
                const wrapper = input.closest('.form-group');

                this.clearMessages(wrapper);

                if (!value) {
                    this.showError(wrapper, input, 'Please confirm your password');
                    return false;
                }

                if (value !== password) {
                    this.showError(wrapper, input, 'Passwords do not match');
                    return false;
                }

                this.showSuccess(wrapper, input, 'Passwords match');
                return true;
            }

            validateOTP() {
                const input = this.fields.otp;
                const value = input.value.trim();
                const wrapper = input.closest('.form-group');

                this.clearMessages(wrapper);

                if (!value) {
                    this.showError(wrapper, input, 'OTP is required');
                    return false;
                }

                if (!/^\d{6}$/.test(value)) {
                    this.showError(wrapper, input, 'OTP must be exactly 6 digits');
                    return false;
                }

                this.showSuccess(wrapper, input, 'Valid OTP format');
                return true;
            }

            updatePasswordStrength(strength, label) {
                const strengthBar = this.form.querySelector('.password-strength-bar');
                const strengthText = this.form.querySelector('.password-strength-text');

                if (strengthBar) {
                    strengthBar.style.width = strength + '%';

                    if (strength < 40) {
                        strengthBar.style.background = '#ef4444';
                    } else if (strength < 70) {
                        strengthBar.style.background = '#f59e0b';
                    } else {
                        strengthBar.style.background = '#10b981';
                    }
                }

                if (strengthText) {
                    strengthText.textContent = label;
                    strengthText.style.color = strength < 40 ? '#ef4444' :
                                               strength < 70 ? '#f59e0b' : '#10b981';
                }
            }

            getStrengthLabel(strength) {
                if (strength < 40) return 'Weak';
                if (strength < 70) return 'Medium';
                return 'Strong';
            }

            showError(wrapper, input, message) {
                input.classList.add('error');
                input.classList.remove('success');

                const errorDiv = document.createElement('div');
                errorDiv.className = 'error-message';
                errorDiv.innerHTML = `<i class="fas fa-exclamation-circle"></i>${message}`;
                wrapper.appendChild(errorDiv);
            }

            showSuccess(wrapper, input, message) {
                input.classList.add('success');
                input.classList.remove('error');

                const successDiv = document.createElement('div');
                successDiv.className = 'success-message';
                successDiv.innerHTML = `<i class="fas fa-check-circle"></i>${message}`;
                wrapper.appendChild(successDiv);
            }

            clearMessages(wrapper) {
                const messages = wrapper.querySelectorAll('.error-message, .success-message');
                messages.forEach(msg => msg.remove());

                const input = wrapper.querySelector('.form-control');
                if (input) {
                    input.classList.remove('error', 'success');
                }
            }

            handleSubmit(e) {
                if (this.isSubmitting) {
                    e.preventDefault();
                    return;
                }

                let isValid = true;

                // Validate all fields
                if (this.fields.email) {
                    isValid = this.validateEmail() && isValid;
                }
                if (this.fields.password) {
                    isValid = this.validatePassword() && isValid;
                }
                if (this.fields.passwordConfirmation) {
                    isValid = this.validatePasswordConfirmation() && isValid;
                }
                if (this.fields.otp) {
                    isValid = this.validateOTP() && isValid;
                }

                if (!isValid) {
                    e.preventDefault();
                    return;
                }

                // Show loading state
                this.isSubmitting = true;
                const submitBtn = this.form.querySelector('button[type="submit"]');
                const originalText = submitBtn.innerHTML;
                submitBtn.disabled = true;
                submitBtn.innerHTML = originalText + ' <span class="spinner"></span>';
            }
        }

        // Initialize validator when DOM is ready
        document.addEventListener('DOMContentLoaded', function() {
            const authForm = document.querySelector('form');
            if (authForm) {
                new AuthValidator(authForm);
            }

            // Auto-dismiss alerts after 5 seconds
            const alerts = document.querySelectorAll('.alert');
            alerts.forEach(alert => {
                setTimeout(() => {
                    alert.style.opacity = '0';
                    setTimeout(() => alert.remove(), 300);
                }, 5000);
            });
        });
    </script>

    @stack('scripts')
</body>
</html>
