<!DOCTYPE html>
<html lang="en" data-bs-theme="light">
<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <title>Prolex Law Firm System</title>
    <link rel="icon" type="image/png" href="{{ asset('prolexlogo.png') }}">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700;800&display=swap" rel="stylesheet" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" />
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">

    <style>
        /* Enhanced Sky Blue Professional Theme */
        :root {
            --primary-blue: #0ea5e9;
            --sky-blue: #38bdf8;
            --light-blue: #7dd3fc;
            --dark-blue: #0284c7;
            --navy: #1e3a8a;
            --navy-dark: #1e293b;
            --accent-gold: #fbbf24;
            --text-primary: #1e293b;
            --text-secondary: #64748b;
            --text-light: #94a3b8;
            --bg-light: #f8fafc;
            --bg-white: #ffffff;
            --border-color: #e2e8f0;
            --shadow-sm: 0 1px 3px rgba(14, 165, 233, 0.08);
            --shadow-md: 0 4px 12px rgba(14, 165, 233, 0.12);
            --shadow-lg: 0 10px 30px rgba(14, 165, 233, 0.15);
            --shadow-xl: 0 20px 50px rgba(14, 165, 233, 0.2);
        }

        /* Dark Mode Variables */
        [data-bs-theme="dark"] {
            --primary-blue: #0ea5e9;
            --sky-blue: #38bdf8;
            --light-blue: #7dd3fc;
            --dark-blue: #0284c7;
            --navy: #1e3a8a;
            --navy-dark: #000000;
            --accent-gold: #fbbf24;
            --text-primary: #ffffff;
            --text-secondary: #cccccc;
            --text-light: #888888;
            --bg-light: #000000;
            --bg-white: #1a1a1a;
            --border-color: #444444;
            --shadow-sm: 0 1px 3px rgba(0, 0, 0, 0.3);
            --shadow-md: 0 4px 12px rgba(0, 0, 0, 0.4);
            --shadow-lg: 0 10px 30px rgba(0, 0, 0, 0.5);
            --shadow-xl: 0 20px 50px rgba(0, 0, 0, 0.6);
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Inter', sans-serif;
            line-height: 1.6;
            color: var(--text-primary);
            background: var(--bg-light);
            overflow-x: hidden;
        }

        /* Premium Sidebar with Enhanced Logo Space */
        .sidebar {
            width: 300px;
            height: 100vh;
            position: fixed;
            top: 0;
            left: 0;
            background: linear-gradient(180deg, #0ea5e9 0%, #0284c7 50%, #0369a1 100%);
            color: white;
            overflow-y: auto;
            overflow-x: hidden;
            z-index: 1000;
            display: flex;
            flex-direction: column;
            box-shadow: var(--shadow-xl);
            transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
        }

        [data-bs-theme="dark"] .sidebar {
            background: linear-gradient(180deg, #000000 0%, #1a1a1a 50%, #000000 100%);
        }

        /* Animated Background Pattern */
        .sidebar::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background-image: 
                radial-gradient(circle at 20% 50%, rgba(255, 255, 255, 0.05) 1px, transparent 1px),
                radial-gradient(circle at 80% 80%, rgba(255, 255, 255, 0.05) 1px, transparent 1px),
                radial-gradient(circle at 40% 20%, rgba(255, 255, 255, 0.03) 1px, transparent 1px);
            background-size: 50px 50px, 80px 80px, 100px 100px;
            animation: backgroundFloat 30s ease-in-out infinite;
            pointer-events: none;
        }

        @keyframes backgroundFloat {
            0%, 100% { transform: translate(0, 0); }
            33% { transform: translate(-10px, -10px); }
            66% { transform: translate(10px, 10px); }
        }

        /* Custom Scrollbar */
        .sidebar::-webkit-scrollbar {
            width: 6px;
        }

        .sidebar::-webkit-scrollbar-track {
            background: rgba(255, 255, 255, 0.05);
        }

        .sidebar::-webkit-scrollbar-thumb {
            background: rgba(255, 255, 255, 0.3);
            border-radius: 3px;
        }

        .sidebar::-webkit-scrollbar-thumb:hover {
            background: rgba(255, 255, 255, 0.5);
        }

        /* Enhanced Spacious Sidebar Header */
        .sidebar-header {
            background: rgba(255, 255, 255, 0.1);
            backdrop-filter: blur(10px);
            padding: 3rem 2rem;
            border-bottom: 1px solid rgba(255, 255, 255, 0.15);
            position: relative;
            z-index: 1;
            min-height: 220px;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .sidebar-header a {
            text-decoration: none;
            display: flex;
            flex-direction: column;
            align-items: center;
            gap: 1.5rem;
            width: 100%;
        }

        /* Enhanced Logo Container */
        .logo-container {
            width: 110px;
            height: 110px;
            background: white;
            border-radius: 24px;
            display: flex;
            align-items: center;
            justify-content: center;
            box-shadow: 0 12px 32px rgba(0, 0, 0, 0.3);
            transition: all 0.5s cubic-bezier(0.4, 0, 0.2, 1);
            position: relative;
            overflow: hidden;
        }

        .logo-container::before {
            content: '';
            position: absolute;
            inset: 0;
            background: linear-gradient(135deg, var(--primary-blue), var(--sky-blue));
            opacity: 0;
            transition: opacity 0.4s ease;
        }

        .logo-container::after {
            content: '';
            position: absolute;
            inset: -50%;
            background: conic-gradient(
                from 180deg at 50% 50%,
                rgba(255, 255, 255, 0) 0deg,
                rgba(255, 255, 255, 0.3) 180deg,
                rgba(255, 255, 255, 0) 360deg
            );
            animation: rotate 3s linear infinite;
            opacity: 0;
        }

        @keyframes rotate {
            100% { transform: rotate(360deg); }
        }

        .logo-container:hover::before {
            opacity: 1;
        }

        .logo-container:hover::after {
            opacity: 1;
        }

        .logo-container img {
            width: 100%;
            height: auto;
            position: relative;
            z-index: 1;
            transition: all 0.4s ease;
        }

        .sidebar-header a:hover .logo-container {
            transform: translateY(-8px) scale(1.08);
            box-shadow: 0 16px 40px rgba(0, 0, 0, 0.4);
        }

        .sidebar-header a:hover .logo-container img {
            filter: brightness(0) invert(1);
            transform: scale(1.1);
        }

        /* Enhanced Brand Text */
        .brand-text {
            display: flex;
            flex-direction: column;
            align-items: center;
            text-align: center;
            gap: 0.5rem;
        }

        .brand-name {
            font-size: 2.25rem;
            font-weight: 900;
            color: white;
            line-height: 1.1;
            letter-spacing: -1px;
            text-shadow: 0 4px 12px rgba(0, 0, 0, 0.3);
            transition: all 0.3s ease;
        }

        .sidebar-header a:hover .brand-name {
            transform: scale(1.05);
            letter-spacing: 1px;
        }

        .brand-tagline {
            font-size: 0.85rem;
            color: rgba(255, 255, 255, 0.8);
            font-weight: 600;
            letter-spacing: 2px;
            text-transform: uppercase;
            padding: 0.5rem 1.5rem;
            background: rgba(255, 255, 255, 0.15);
            border-radius: 12px;
            backdrop-filter: blur(5px);
            transition: all 0.3s ease;
        }

        .sidebar-header a:hover .brand-tagline {
            background: rgba(255, 255, 255, 0.25);
            letter-spacing: 3px;
        }

        /* Navigation Section */
        .nav {
            padding: 1.5rem 0;
            flex: 1;
        }

        .nav-section-title {
            padding: 1.5rem 1.75rem 0.75rem;
            font-size: 0.7rem;
            font-weight: 800;
            text-transform: uppercase;
            letter-spacing: 1.5px;
            color: rgba(255, 255, 255, 0.5);
            margin-top: 1rem;
        }

        .nav-item {
            margin: 0.25rem 0;
            position: relative;
        }

        .nav-link {
            padding: 1.1rem 1.75rem;
            margin: 0 1rem;
            border-radius: 16px;
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            font-weight: 600;
            font-size: 0.95rem;
            color: rgba(255, 255, 255, 0.85);
            display: flex;
            align-items: center;
            gap: 1.25rem;
            position: relative;
            overflow: hidden;
            border: 2px solid transparent;
        }

        .nav-link::before {
            content: '';
            position: absolute;
            left: 0;
            top: 0;
            bottom: 0;
            width: 4px;
            background: white;
            transform: scaleY(0);
            transition: transform 0.3s ease;
            border-radius: 0 4px 4px 0;
        }

        .nav-link::after {
            content: '';
            position: absolute;
            inset: 0;
            background: linear-gradient(135deg, rgba(255, 255, 255, 0.15), rgba(255, 255, 255, 0.05));
            opacity: 0;
            transition: opacity 0.3s ease;
            border-radius: 16px;
        }

        .nav-link:hover {
            color: white;
            transform: translateX(8px);
            border-color: rgba(255, 255, 255, 0.2);
        }

        .nav-link:hover::after {
            opacity: 1;
        }

        .nav-link:hover::before {
            transform: scaleY(1);
        }

        .nav-link.active {
            background: white;
            color: var(--primary-blue);
            box-shadow: 0 8px 24px rgba(0, 0, 0, 0.3);
            transform: translateX(0);
            border-color: white;
        }

        .nav-link.active::before {
            display: none;
        }

        .nav-link.active i {
            color: var(--primary-blue);
        }

        .nav-link i {
            width: 24px;
            text-align: center;
            font-size: 1.2rem;
            transition: all 0.3s ease;
        }

        .nav-link:hover i {
            transform: scale(1.15) rotate(5deg);
        }

        .nav-link .badge {
            margin-left: auto;
            background: var(--accent-gold);
            color: var(--navy-dark);
            font-weight: 700;
            font-size: 0.7rem;
            padding: 0.3rem 0.7rem;
            border-radius: 10px;
            box-shadow: 0 2px 8px rgba(0, 0, 0, 0.2);
        }

        /* User Profile Section */
        .user-profile-section {
            margin-top: auto;
            padding: 1.25rem;
            border-top: 1px solid rgba(255, 255, 255, 0.15);
            background: rgba(0, 0, 0, 0.15);
            backdrop-filter: blur(10px);
        }

        .user-profile-card {
            background: rgba(255, 255, 255, 0.1);
            border-radius: 16px;
            padding: 1.25rem;
            display: flex;
            align-items: center;
            gap: 1.25rem;
            transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
            cursor: pointer;
            border: 2px solid rgba(255, 255, 255, 0.1);
            text-decoration: none;
            color: white;
        }

        .user-profile-card:hover {
            background: rgba(255, 255, 255, 0.2);
            transform: translateY(-4px);
            box-shadow: 0 8px 24px rgba(0, 0, 0, 0.25);
            border-color: rgba(255, 255, 255, 0.3);
        }

        .user-avatar {
            width: 56px;
            height: 56px;
            border-radius: 16px;
            background: linear-gradient(135deg, white, rgba(255, 255, 255, 0.9));
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 1.6rem;
            color: var(--primary-blue);
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.2);
            transition: all 0.3s ease;
        }

        .user-profile-card:hover .user-avatar {
            transform: scale(1.1) rotate(-5deg);
            box-shadow: 0 6px 16px rgba(0, 0, 0, 0.3);
        }

        .user-info {
            flex: 1;
        }

        .user-name {
            font-weight: 700;
            font-size: 1rem;
            color: white;
            margin-bottom: 0.2rem;
        }

        .user-role {
            font-size: 0.8rem;
            color: rgba(255, 255, 255, 0.7);
            font-weight: 500;
        }

        .user-actions {
            color: rgba(255, 255, 255, 0.6);
            font-size: 1.2rem;
            transition: all 0.3s ease;
        }

        .user-profile-card:hover .user-actions {
            color: white;
            transform: translateX(6px);
        }

        /* Premium Topbar */
        .topbar {
            margin-left: 300px;
            height: 85px;
            background: white;
            border-bottom: 1px solid var(--border-color);
            display: flex;
            align-items: center;
            justify-content: space-between;
            padding: 0 2.5rem;
            box-shadow: var(--shadow-md);
            position: sticky;
            top: 0;
            z-index: 999;
            backdrop-filter: blur(10px);
            transition: all 0.3s ease;
        }

        /* Enhanced Search Bar */
        .search-container {
            position: relative;
            width: 100%;
            margin: 0 2rem;
            flex: 1;
        }

        .search-input {
            width: 100%;
            padding: 1rem 1.5rem;
            border: 2px solid var(--border-color);
            border-radius: 16px;
            font-size: 0.95rem;
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            background: var(--bg-light);
            font-weight: 500;
        }

        .search-input:focus {
            outline: none;
            border-color: var(--primary-blue);
            background: white;
            box-shadow: 0 0 0 4px rgba(14, 165, 233, 0.1);
            transform: translateY(-2px);
        }

        /* Mobile Toggle */
        .mobile-toggle {
            display: none;
        }

        /* Topbar Actions */
        .topbar-actions {
            display: flex;
            align-items: center;
            gap: 1.5rem;
        }

        .action-btn {
            width: 52px;
            height: 52px;
            border-radius: 16px;
            border: 2px solid var(--border-color);
            background: white;
            color: var(--text-secondary);
            display: flex;
            align-items: center;
            justify-content: center;
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            cursor: pointer;
            position: relative;
            font-size: 1.15rem;
        }

        .action-btn:hover {
            background: var(--bg-light);
            border-color: var(--primary-blue);
            color: var(--primary-blue);
            transform: translateY(-4px);
            box-shadow: var(--shadow-md);
        }

        .action-btn .badge {
            position: absolute;
            top: -8px;
            right: -8px;
            background: linear-gradient(135deg, #ef4444, #dc2626);
            color: white;
            font-size: 0.7rem;
            padding: 0.3rem 0.6rem;
            border-radius: 10px;
            font-weight: 700;
            box-shadow: 0 2px 8px rgba(239, 68, 68, 0.4);
            min-width: 24px;
            animation: pulse 2s ease-in-out infinite;
        }

        @keyframes pulse {
            0%, 100% { transform: scale(1); }
            50% { transform: scale(1.1); }
        }

        /* User Menu Button */
        .user-menu-btn {
            display: flex;
            align-items: center;
            gap: 1rem;
            padding: 0.6rem 1.5rem;
            border-radius: 16px;
            border: 2px solid var(--border-color);
            background: white;
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            cursor: pointer;
        }

        .user-menu-btn:hover {
            background: var(--bg-light);
            border-color: var(--primary-blue);
            transform: translateY(-2px);
            box-shadow: var(--shadow-md);
        }

        .user-menu-avatar {
            width: 44px;
            height: 44px;
            border-radius: 14px;
            background: linear-gradient(135deg, var(--primary-blue), var(--sky-blue));
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-weight: 700;
            font-size: 1rem;
            box-shadow: 0 2px 8px rgba(14, 165, 233, 0.3);
        }

        .user-menu-name {
            font-weight: 600;
            font-size: 0.95rem;
            color: var(--text-primary);
        }

        .user-menu-icon {
            color: var(--text-light);
            font-size: 0.875rem;
            transition: transform 0.3s ease;
        }

        .user-menu-btn:hover .user-menu-icon {
            transform: rotate(180deg);
        }

        /* Main Content */
        .main-content {
            margin-left: 300px;
            padding: 2.5rem;
            min-height: calc(100vh - 85px);
            transition: all 0.3s ease;
        }

        /* Dropdown Menu Enhancements */
        .dropdown-menu {
            border: none;
            box-shadow: var(--shadow-lg);
            border-radius: 16px;
            padding: 0.75rem;
            margin-top: 0.75rem;
            min-width: 260px;
            animation: dropdownSlide 0.3s ease;
        }

        @keyframes dropdownSlide {
            from {
                opacity: 0;
                transform: translateY(-10px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        .dropdown-item {
            border-radius: 12px;
            padding: 1rem 1.5rem;
            font-size: 0.95rem;
            font-weight: 500;
            transition: all 0.2s ease;
            display: flex;
            align-items: center;
            gap: 1rem;
            color: var(--text-primary);
        }

        .dropdown-item:hover {
            background: linear-gradient(135deg, rgba(14, 165, 233, 0.1), rgba(56, 189, 248, 0.1));
            color: var(--primary-blue);
            transform: translateX(6px);
        }

        .dropdown-item i {
            width: 22px;
            text-align: center;
            color: var(--text-light);
            font-size: 1.15rem;
            transition: all 0.2s ease;
        }

        .dropdown-item:hover i {
            color: var(--primary-blue);
            transform: scale(1.15);
        }

        .dropdown-header {
            padding: 1rem 1.5rem;
            font-weight: 700;
            font-size: 0.8rem;
            color: var(--text-primary);
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }

        .dropdown-divider {
            margin: 0.75rem 0;
            border-color: var(--border-color);
            opacity: 0.5;
        }

        /* Responsive Design */
        @media (max-width: 991px) {
            .sidebar {
                transform: translateX(-100%);
            }

            .sidebar.show {
                transform: translateX(0);
            }

            .topbar {
                margin-left: 0;
            }

            .main-content {
                margin-left: 0;
                padding: 1.5rem;
            }

            .mobile-toggle {
                display: flex;
            }

            .search-container {
                width: 250px;
            }

            .user-menu-name {
                display: none;
            }
        }

        @media (max-width: 576px) {
            .search-container {
                display: none;
            }

            .topbar {
                padding: 0 1rem;
            }

            .topbar-actions {
                gap: 0.5rem;
            }

            .action-btn {
                width: 44px;
                height: 44px;
            }

            .main-content {
                padding: 1rem;
            }

            .sidebar-header {
                padding: 2rem 1.5rem;
                min-height: 180px;
            }

            .logo-container {
                width: 90px;
                height: 90px;
            }

            .logo-container img {
                width: 70px;
            }

            .brand-name {
                font-size: 1.75rem;
            }
        }

        @yield('styles')
    </style>
    
    <!-- THIS IS THE FIX - ADDED @stack('styles') -->
    @stack('styles')
</head>
<body>
    <!-- Enhanced Sidebar -->
    <nav id="sidebar" class="sidebar">
        <!-- Spacious Premium Logo/Brand -->
        <div class="sidebar-header">
            <a href="{{ route('dashboard') }}">
                <div class="logo-container">
                    <img src="https://melsoftzim.co.zw/assets/uploads/logo.jpg" alt="Prolex Logo">
                </div>
                <div class="brand-text">
                    <span class="brand-name">Prolex</span>
                    <span class="brand-tagline">Legal Excellence</span>
                </div>
            </a>
        </div>

        <!-- Main Navigation -->
        <ul class="nav flex-column">
            <li class="nav-section-title">Main Menu</li>
            <li class="nav-item">
                <a href="{{ route('dashboard') }}" class="nav-link active">
                    <i class="fas fa-home"></i>
                    <span>Dashboard</span>
                </a>
            </li>
            <li class="nav-item">
                <a href="{{ route('modules.edit') }}" class="nav-link">
                    <i class="fas fa-edit"></i>
                    <span>Edit Menu</span>
                </a>
            </li>
            <li class="nav-item">
                <a href="{{ route('modules.processing') }}" class="nav-link">
                    <i class="fas fa-cogs"></i>
                    <span>Processing Center</span>
                </a>
            </li>
            <li class="nav-item">
                <a href="{{ route('modules.reports') }}" class="nav-link">
                    <i class="fas fa-chart-line"></i>
                    <span>Reports</span>
                </a>
            </li>

            <li class="nav-section-title">Communication</li>
            <li class="nav-item">
                <a href="{{ route('chat.passcode') }}" class="nav-link">
                    <i class="fas fa-comments"></i>
                    <span>Chat Room</span>
                    <span class="badge">3</span>
                </a>
            </li>
            <li class="nav-item">
                <a href="{{ route('proly.index') }}" class="nav-link">
                    <i class="fas fa-robot"></i>
                    <span>Proly AI Assistant</span>
                </a>
            </li>

            <li class="nav-section-title">System</li>
            <li class="nav-item">
                <a href="{{ route('administration') }}" class="nav-link">
                    <i class="fas fa-shield-alt"></i>
                    <span>Administration</span>
                </a>
            </li>
            <li class="nav-item">
                <a href="{{ route('help') }}" class="nav-link">
                    <i class="fas fa-question-circle"></i>
                    <span>Help Center</span>
                </a>
            </li>
        </ul>

        <!-- User Profile Section (Bottom) -->
        <div class="user-profile-section">
            <a href="{{ route('profile') }}" class="user-profile-card">
                <div class="user-avatar">
                    <i class="fas fa-user"></i>
                </div>
                <div class="user-info">
                    <div class="user-name">{{ auth()->user()->name ?? 'Guest' }}</div>
                    <div class="user-role">View Profile</div>
                </div>
                <div class="user-actions">
                    <i class="fas fa-chevron-right"></i>
                </div>
            </a>
        </div>
    </nav>

    <!-- Premium Topbar -->
    <header class="topbar">
        <!-- Mobile Toggle Button -->
        <button class="mobile-toggle action-btn" onclick="toggleSidebar()" aria-label="Toggle sidebar">
            <i class="fas fa-bars"></i>
        </button>

        <!-- Enhanced Search -->
        <div class="search-container">
            <input
                type="search"
                class="search-input"
                placeholder="Search cases, clients, documents..."
                aria-label="Search"
            />
        </div>

        <!-- Topbar Actions (Icons) -->
        <div class="topbar-actions">
            <!-- Notifications -->
            <div class="dropdown">
                <button class="action-btn" data-bs-toggle="dropdown" aria-expanded="false">
                    <i class="fas fa-bell"></i>
                    <span class="badge">5</span>
                </button>
                <ul class="dropdown-menu dropdown-menu-end">
                    <li class="dropdown-header">Notifications</li>
                    <li><a class="dropdown-item" href="#"><i class="fas fa-file-alt"></i>New case assigned</a></li>
                    <li><a class="dropdown-item" href="#"><i class="fas fa-comment"></i>3 new messages</a></li>
                    <li><a class="dropdown-item" href="#"><i class="fas fa-calendar"></i>Hearing tomorrow</a></li>
                    <li><hr class="dropdown-divider"></li>
                    <li><a class="dropdown-item text-center" href="#"><strong>View All</strong></a></li>
                </ul>
            </div>

            <!-- Settings -->
            <button class="action-btn">
                <i class="fas fa-cog"></i>
            </button>

            <!-- Dark Mode Toggle -->
            <button id="theme-toggle" class="action-btn" onclick="toggleTheme()" aria-label="Toggle dark mode">
                <i class="fas fa-moon"></i>
            </button>

            <!-- User Menu -->
            <div class="dropdown">
                <button class="user-menu-btn" data-bs-toggle="dropdown" aria-expanded="false">
                    <div class="user-menu-avatar">{{ strtoupper(substr(auth()->user()->name ?? 'G', 0, 1)) }}</div>
                    <span class="user-menu-name">{{ auth()->user()->name ?? 'Guest' }}</span>
                    <i class="fas fa-chevron-down user-menu-icon"></i>
                </button>
                <ul class="dropdown-menu dropdown-menu-end">
                    <li class="dropdown-header">Account</li>
                    <li><a class="dropdown-item" href="{{ route('profile') }}"><i class="fas fa-user"></i>My Profile</a></li>
                    <li><a class="dropdown-item" href="{{ route('system.settings') }}"><i class="fas fa-cog"></i>Settings</a></li>
                    <li><a class="dropdown-item" href="{{ route('help') }}"><i class="fas fa-question-circle"></i>Help Center</a></li>
                    <li><hr class="dropdown-divider"></li>
                    <li><a class="dropdown-item" href="{{ route('logout') }}"><i class="fas fa-sign-out-alt"></i>Sign Out</a></li>
                </ul>
            </div>
        </div>
    </header>

    <!-- Main Content -->
    <main class="main-content">
        @yield('content')
    </main>

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

    <!-- Global utilities loaded via Vite -->
    @vite('resources/js/global.js')

    @stack('scripts')
    
    <script>
        // Sidebar toggle for mobile
        function toggleSidebar() {
            document.getElementById('sidebar').classList.toggle('show');
        }
        
        // Theme toggle
        function toggleTheme() {
            const html = document.documentElement;
            const currentTheme = html.getAttribute('data-bs-theme');
            const newTheme = currentTheme === 'light' ? 'dark' : 'light';
            html.setAttribute('data-bs-theme', newTheme);
            
            // Update icon
            const icon = document.querySelector('#theme-toggle i');
            icon.className = newTheme === 'light' ? 'fas fa-moon' : 'fas fa-sun';
            
            // Save preference
            localStorage.setItem('theme', newTheme);
        }
        
        // Load saved theme
        document.addEventListener('DOMContentLoaded', function() {
            const savedTheme = localStorage.getItem('theme') || 'light';
            document.documentElement.setAttribute('data-bs-theme', savedTheme);
            
            const icon = document.querySelector('#theme-toggle i');
            if (icon) {
                icon.className = savedTheme === 'light' ? 'fas fa-moon' : 'fas fa-sun';
            }
        });
    </script>
</body>
</html>