@extends('layouts.master')

@section('title', 'Edit Role - Prolex Law Firm System')

@section('page-title', 'Edit Role')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header bg-primary text-white py-3">
                    <h5 class="mb-0"><i class="fas fa-user-shield me-2"></i>Edit Role</h5>
                </div>
                <div class="card-body">
<form action="{{ route('administration.roles.update', ['id' => $userRole->user_role_id]) }}" method="POST">
    @csrf
    @method('PUT')
    <div class="mb-3">
        <label for="name" class="form-label">Role Name</label>
        <input type="text" class="form-control" id="name" name="name" value="{{ $userRole->role_name }}" required>
    </div>
    <div class="mb-3">
        <label for="description" class="form-label">Description</label>
        <textarea class="form-control" id="description" name="description" rows="3">{{ $userRole->role_description }}</textarea>
    </div>
    <button type="submit" class="btn btn-primary">Update Role</button>
    <a href="{{ route('administration.roles.index') }}" class="btn btn-secondary">Cancel</a>
</form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

