@extends('layouts.master')

@section('title', 'Edit User - Prolex Law Firm System')

@section('page-title', 'Edit User')

@section('content')
<div class="container-fluid py-3">
    <nav aria-label="breadcrumb">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="{{ route('administration') }}">Administration</a></li>
            <li class="breadcrumb-item"><a href="{{ route('administration.user-settings') }}">User Settings</a></li>
            <li class="breadcrumb-item"><a href="{{ route('administration.user-management') }}">User Management</a></li>
            <li class="breadcrumb-item active" aria-current="page">Edit User</li>
        </ol>
    </nav>

    <div class="card shadow-sm">
        <div class="card-header bg-primary text-white py-3">
            <h5 class="mb-0"><i class="fas fa-user-edit"></i> Edit User</h5>
        </div>

        <div class="card-body">
            <form action="{{ route('administration.update-user', $user->id) }}" method="POST">
                @csrf
                @method('PUT')
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group mb-3">
                            <label for="name">Name</label>
                            <input type="text" class="form-control" id="name" name="name" value="{{ $user->name }}" required>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group mb-3">
                            <label for="email">Email</label>
                            <input type="email" class="form-control" id="email" name="email" value="{{ $user->email }}" required>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group mb-3">
                            <label for="phone">Phone</label>
                            <input type="text" class="form-control" id="phone" name="phone" value="{{ $user->phones->first() ? $user->phones->first()->phone_number : '' }}">
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group mb-3">
                            <label for="role">Role</label>
                            <select class="form-select" id="role" name="role">
                                <option value="">Select Role</option>
                                @foreach ($roles as $role)
                                    <option value="{{ $role->user_role_id }}" {{ $user->role_id == $role->user_role_id ? 'selected' : '' }}>
                                        {{ $role->role_name }}
                                    </option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group mb-3">
                            <label for="group">Group</label>
                            <select class="form-select" id="group" name="group">
                                <option value="">Select Group</option>
                                @foreach ($groups as $group)
                                <option value="{{ $group->user_group_id }}" {{ ($user->group_id == $group->user_group_id) ? 'selected' : '' }}>
                                    {{ $group->group_name }}
                                </option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                </div>
                <div class="d-flex justify-content-end">
                    <a href="{{ route('administration.user-management') }}" class="btn btn-secondary me-2">Cancel</a>
                    <button type="submit" class="btn btn-primary">Update User</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection

