@extends('layouts.master')

@section('title', 'General Settings - Prolex Law Firm System')

@section('page-title', 'General Settings')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title mb-0">General Settings Options</h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <!-- Company Information Card -->
                        <div class="col-md-6 mb-4">
                            <div class="card h-100 border-primary">
                                <div class="card-body text-center">
                                    <i class="fas fa-building fa-3x text-primary mb-3"></i>
                                    <h5 class="card-title">Company Information</h5>
                                    <p class="card-text text-muted">Manage company details, contact information, and basic settings.</p>
                                    <a href="{{ route('administration.company-info') }}" class="btn btn-primary">
                                        <i class="fas fa-arrow-right me-2"></i>Configure Company Info
                                    </a>
                                </div>
                            </div>
                        </div>

                        <!-- System Settings Card -->
                        <div class="col-md-6 mb-4">
                            <div class="card h-100 border-success">
                                <div class="card-body text-center">
                                    <i class="fas fa-cogs fa-3x text-success mb-3"></i>
                                    <h5 class="card-title">System Settings</h5>
                                    <p class="card-text text-muted">Configure system preferences, defaults, and application behavior.</p>
                                    <a href="{{ route('system.settings') }}" class="btn btn-success">
                                        <i class="fas fa-arrow-right me-2"></i>Configure System Settings
                                    </a>
                                </div>
                            </div>
                        </div>

                        <!-- Admin Approvals Card -->
                        <div class="col-md-6 mb-4">
                            <div class="card h-100 border-warning">
                                <div class="card-body text-center">
                                    <i class="fas fa-check-circle fa-3x text-warning mb-3"></i>
                                    <h5 class="card-title">Admin Approvals</h5>
                                    <p class="card-text text-muted">Review and manage pending approval requests across the system.</p>
                                    <a href="{{ route('administration.approvals') }}" class="btn btn-warning">
                                        <i class="fas fa-arrow-right me-2"></i>Manage Approvals
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

