@extends('layouts.master')

@section('title', 'Edit Group - Prolex Law Firm System')

@section('page-title', 'Edit Group')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header bg-primary text-white py-3">
                    <div class="d-flex justify-content-between align-items-center">
                        <h5 class="mb-0"><i class="fas fa-layer-group me-2"></i>Edit Group</h5>
                        <a href="{{ route('administration.groups.index') }}" class="btn btn-light">Back to Groups</a>
                    </div>
                </div>
                <div class="card-body">
                    <form action="{{ route('administration.groups.update', $group->user_group_id) }}" method="POST">
                        @csrf
                        @method('PUT')
                        <div class="mb-3">
                            <label for="name" class="form-label">Group Name</label>
                            <input type="text" class="form-control" id="name" name="name" value="{{ $group->group_name }}" required>
                        </div>
                        <div class="mb-3">
                            <label for="description" class="form-label">Description</label>
                            <textarea class="form-control" id="description" name="description" rows="3">{{ $group->group_description }}</textarea>
                        </div>
                        <button type="submit" class="btn btn-primary">Update Group</button>
                        <a href="{{ route('administration.groups.index') }}" class="btn btn-secondary">Cancel</a>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

