@extends('layouts.master')

@section('title', 'View Group - Prolex Law Firm System')

@section('page-title', 'View Group')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header bg-primary text-white py-3">
                    <div class="d-flex justify-content-between align-items-center">
                        <h5 class="mb-0"><i class="fas fa-layer-group me-2"></i>Group Details</h5>
                        <a href="{{ route('administration.groups.index') }}" class="btn btn-light">Back to Groups</a>
                    </div>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <h6>Group Name</h6>
                            <p>{{ $group->name }}</p>
                        </div>
                        <div class="col-md-6">
                            <h6>Description</h6>
                            <p>{{ $group->description ?: 'No description provided.' }}</p>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <h6>Created At</h6>
                            <p>{{ $group->created_at->format('d M Y, H:i') }}</p>
                        </div>
                        <div class="col-md-6">
                            <h6>Updated At</h6>
                            <p>{{ $group->updated_at->format('d M Y, H:i') }}</p>
                        </div>
                    </div>
                    <div class="mt-3 d-flex gap-2">
                        <a href="{{ route('administration.groups.index') }}" class="btn btn-secondary">Back to Groups</a>
                        <a href="{{ route('administration.groups.edit', $group->user_group_id) }}" class="btn btn-primary">Edit Group</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

