@extends('layouts.master')

@section('title', 'Groups - Prolex Law Firm System')

@section('page-title', 'Groups')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header bg-primary text-white py-3 d-flex align-items-center justify-content-between">
                    <a href="{{ route('administration.user-settings') }}" class="btn btn-primary me-auto">Back to User Settings</a>
                    <h5 class="mb-0 mx-3"><i class="fas fa-layer-group me-2"></i>Groups</h5>
                    <a href="{{ route('administration.groups.create') }}" class="btn btn-light">Add Group</a>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped">
                            <thead class="table-dark">
                                <tr>
                                    <th>#</th>
                                    <th>Group Name</th>
                                    <th>Description</th>
                                    <th width="180px">Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($groups as $group)
                                <tr>
                                    <td>{{ $loop->iteration }}</td>
                                    <td>{{ $group->group_name }}</td>
                                    <td>{{ $group->group_description }}</td>
                                    <td>
                                        <a href="{{ route('administration.groups.edit', $group->user_group_id) }}" class="btn btn-secondary btn-sm">Edit</a>
                                        <form action="{{ route('administration.groups.destroy', $group->user_group_id) }}" method="POST" style="display:inline;">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="btn btn-danger btn-sm" onclick="return confirm('Are you sure?')">Delete</button>
                                        </form>
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

