@extends('layouts.master')

@section('title', 'View Role - Prolex Law Firm System')

@section('page-title', 'View Role')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header bg-primary text-white py-3">
                    <div class="d-flex justify-content-between align-items-center">
                        <h5 class="mb-0"><i class="fas fa-user-shield me-2"></i>Role Details</h5>
                        <a href="{{ route('administration.roles.index') }}" class="btn btn-light">Back to Roles</a>
                    </div>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <h6>Role Name</h6>
                            <p>{{ $userRole->role_name }}</p>
                        </div>
                        <div class="col-md-6">
                            <h6>Description</h6>
                            <p>{{ $userRole->role_description ?: 'No description provided.' }}</p>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <h6>Created At</h6>
<p>{{ \Carbon\Carbon::parse($userRole->created_at)->format('d M Y, H:i') }}</p>
                        </div>
                        <div class="col-md-6">
                            <h6>Updated At</h6>
<p>{{ \Carbon\Carbon::parse($userRole->updated_at)->format('d M Y, H:i') }}</p>
                        </div>
                    </div>
<div class="mt-3 d-flex gap-2">
    <a href="{{ route('administration.user-settings') }}" class="btn btn-primary">Back to User Settings</a>
    <a href="{{ route('administration.roles.edit', ['id' => $userRole->user_role_id]) }}" class="btn btn-secondary">Edit Role</a>
</div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

