@extends('layouts.master')

@section('title', 'Roles - Prolex Law Firm System')

@section('page-title', 'Roles Management')

@section('content')
<div class="container-fluid">
    <div class="row mb-3">
        <div class="col-12">
            <a href="{{ route('administration.user-settings') }}" class="btn btn-primary">Back to User Settings</a>
        </div>
    </div>
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header bg-primary text-white py-3">
                    <div class="d-flex justify-content-between align-items-center">
                        <h5 class="mb-0"><i class="fas fa-user-shield me-2"></i>Roles</h5>
                        <a href="{{ route('administration.roles.create') }}" class="btn btn-light">Add Role</a>
                    </div>
                </div>
                <div class="card-body">
                    @if(session('success'))
                        <div class="alert alert-success">
                            {{ session('success') }}
                        </div>
                    @endif

                    @if($userRoles->count() > 0)
                        <div class="table-responsive">
                            <table class="table table-striped table-hover">
                                <thead class="table-dark">
                                    <tr>
                                        <th>user_role_id</th>
                                        <th>assigned_at</th>
                                        <th>updated_at</th>
                                        <th>role_name</th>
                                        <th>role_description</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($userRoles as $userRole)
                                        <tr>
                                            <td>{{ $userRole->user_role_id }}</td>
                                            <td>{{ $userRole->assigned_at }}</td>
                                            <td>{{ $userRole->updated_at }}</td>
                                            <td>{{ $userRole->role_name }}</td>
                                            <td>{{ $userRole->role_description }}</td>
                                            <td>
                                                <a href="{{ route('administration.roles.show', ['id' => $userRole->user_role_id]) }}" class="btn btn-sm btn-info me-1">
                                                    <i class="fas fa-eye"></i> View
                                                </a>
                                                <a href="{{ route('administration.roles.edit', ['id' => $userRole->user_role_id]) }}" class="btn btn-sm btn-warning me-1">
                                                    <i class="fas fa-edit"></i> Edit
                                                </a>
                                                <form action="{{ route('administration.roles.destroy', ['id' => $userRole->user_role_id]) }}" method="POST" class="d-inline">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('Are you sure you want to delete this user role?')">
                                                        <i class="fas fa-trash"></i> Delete
                                                    </button>
                                                </form>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    @else
                        <div class="text-center py-5">
                            <i class="fas fa-user-shield fa-3x text-muted mb-3"></i>
                            <h5 class="text-muted">No user roles found</h5>
                            <p class="text-muted">Start by assigning roles to users.</p>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

