@extends('layouts.master')

@section('title', 'User Management - Prolex Law Firm System')

@section('page-title', 'User Management')

@section('content')
<div class="container-fluid py-3">
    <nav aria-label="breadcrumb">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="{{ route('administration') }}">Administration</a></li>
            <li class="breadcrumb-item"><a href="{{ route('administration.user-settings') }}">User Settings</a></li>
            <li class="breadcrumb-item active" aria-current="page">User Management</li>
        </ol>
    </nav>
    <div class="d-flex justify-content-end mb-2">
        <a href="{{ route('administration.create-user') }}" class="btn btn-primary">Add User</a>
    </div>

    <div class="card shadow-sm">
        <div class="card-header bg-primary text-white py-3">
            <h5 class="mb-0"><i class="fas fa-users"></i> System Users</h5>
        </div>

        <div class="card-body">
            <form id="userManagementForm">
                <input type="hidden" name="_token" value="{{ csrf_token() }}" autocomplete="off">
            </form>
        </div>
    </div>

    <!-- Display Users Data -->
    <div class="card shadow-sm mt-4">
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered table-hover">
                    <thead style="background-color: #0b7c85;" class="text-white">
                        <tr>
                            <th style="width: 200px;">Name</th>
                            <th style="width: 190px;">Email</th>
                            <th style="width: 120px;">Phone</th>
                            <th style="width: 180px;">Role</th>
                            <th style="width: 180px;">Group</th>
                            <th style="width: 100px;">Status</th>
                            <th style="width: 180px;">Action</th>
                        </tr>
                    </thead>
                    <tbody style="font-weight: bold;">
                        @foreach($users as $user)
                        <tr>
                            <td>{{ $user->name }}</td>
                            <td>{{ $user->email }}</td>
                            <td>
                                @if($user->phones->count() > 0)
                                    <a href="#" data-bs-toggle="modal" data-bs-target="#phoneModal{{ $user->id }}" class="text-decoration-none">
                                        {{ $user->phones->first()->phone_number }}
                                        @if($user->phones->count() > 1)
                                            <span class="badge bg-info">+{{ $user->phones->count() - 1 }}</span>
                                        @endif
                                    </a>
                                @else
                                    N/A
                                @endif
                            </td>
                            <td>{{ $user->role->role_name ?? 'N/A' }}</td>
                            <td>{{ $user->group->group_name ?? 'N/A' }}</td>
                            <td><span class="badge bg-success text-white">Active</span></td>
                            <td>
                                <a href="{{ route('administration.edit-user', $user->id) }}" class="btn btn-sm btn-secondary">Edit</a>
                                <a href="{{ route('administration.user-permissions', $user->id) }}" class="btn btn-sm btn-info"><i class="fas fa-shield-alt"></i></a>
                                <form action="{{ route('administration.destroy-user', $user->id) }}" method="POST" style="display:inline;">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('Are you sure you want to delete this user?')">Delete</button>
                                </form>
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>


@endsection

@section('scripts')
<script>
    // Ensure Bootstrap JS is loaded for modals
    $(document).ready(function() {
        // Any additional JS if needed
    });
</script>
@endsection

<!-- Phone Modal -->
@foreach($users as $user)
<div class="modal fade" id="phoneModal{{ $user->id }}" tabindex="-1" aria-labelledby="phoneModalLabel{{ $user->id }}" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="phoneModalLabel{{ $user->id }}">Phone Numbers for {{ $user->name }}</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                @if($user->phones->count() > 0)
                    <ul class="list-group">
                        @foreach($user->phones as $phone)
                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                {{ $phone->phone_number }}
                                <span class="badge bg-secondary">{{ $phone->phone_type }}</span>
                                @if($phone->is_verified)
                                    <span class="badge bg-success">Verified</span>
                                @else
                                    <span class="badge bg-warning">Unverified</span>
                                @endif
                            </li>
                        @endforeach
                    </ul>
                @else
                    <p>No phone numbers available.</p>
                @endif
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>
@endforeach

