@extends('layouts.master')

@section('title', 'User Permissions - Prolex Law Firm System')

@section('page-title', 'User Permissions')

@section('content')
<div class="container-fluid py-3">
    <nav aria-label="breadcrumb">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="{{ route('administration') }}">Administration</a></li>
            <li class="breadcrumb-item"><a href="{{ route('administration.user-management') }}">User Management</a></li>
            <li class="breadcrumb-item active" aria-current="page">Permissions for {{ $user->name }}</li>
        </ol>
    </nav>

    <div class="card shadow-sm">
        <div class="card-header bg-primary text-white py-3">
            <h5 class="mb-0"><i class="fas fa-shield-alt"></i> Manage Permissions for {{ $user->name }}</h5>
        </div>
        <div class="card-body">
            <form action="{{ route('administration.update-user-permissions', $user->id) }}" method="POST">
                @csrf
                @method('PUT')
                <div class="row mb-3">
                    <div class="col-md-6">
                        <label class="form-label">Name: {{ $user->name }}</label>
                    </div>
                    <div class="col-md-6">
                        <label class="form-label">Email: {{ $user->email }}</label>
                    </div>
                </div>
                <div class="row mb-3">
                    <div class="col-md-4">
                        <label class="form-label">Role: {{ $user->role->role_name ?? 'N/A' }}</label>
                    </div>
                    <div class="col-md-4">
                        <label class="form-label">Group: {{ $user->group->group_name ?? 'N/A' }}</label>
                    </div>
                    <div class="col-md-4">
                        <label class="form-label">Status: <span class="badge bg-success">Active</span></label>
                    </div>
                </div>

                <h6 class="mt-4 mb-3">Module Permissions</h6>
                <div class="mb-3">
                    <button type="button" class="btn btn-success" id="check-all">Check All</button>
                    <button type="button" class="btn btn-warning" id="uncheck-all">Uncheck All</button>
                </div>
                <div class="table-responsive">
                    <table class="table table-bordered">
                        <thead class="table-light">
                            <tr>
                                <th>Module Name</th>
                                <th>Features</th>
                                <th colspan="4">Access Controls</th>
                            </tr>
                            <tr>
                                <th></th>
                                <th></th>
                                <th>View</th>
                                <th>Add</th>
                                <th>Edit</th>
                                <th>Delete</th>
                            </tr>
                        </thead>
                        <tbody>
                            @php
                                $userPermissions = $user->permissions ? json_decode($user->permissions, true) : [];
                                $noDeleteFeatures = ['Client Invoices', 'Client Receipts', 'Supplier Invoices'];
                            @endphp
                            @foreach($modules as $moduleName => $features)
                                @php
                                    $featureCount = count($features);
                                    $moduleViewChecked = $isAdmin;
                                    if (!$isAdmin) {
                                        foreach ($features as $feature => $defaults) {
                                            if (isset($userPermissions[$moduleName][$feature]['view']) && $userPermissions[$moduleName][$feature]['view']) {
                                                $moduleViewChecked = true;
                                                break;
                                            }
                                        }
                                    }
                                @endphp
                                <tr class="module-row" data-module="{{ $moduleName }}">
                                    <td rowspan="{{ $featureCount + 1 }}">{{ $moduleName }}</td>
                                    <td>Module View</td>
                                    <td>
                                        <div class="form-check">
                                            <input class="form-check-input module-view-checkbox" type="checkbox" name="module_views[{{ $moduleName }}]"
                                                   value="1" {{ $moduleViewChecked ? 'checked' : '' }}>
                                        </div>
                                    </td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                </tr>
                                @foreach($features as $feature => $defaults)
                                    <tr class="feature-row" data-module="{{ $moduleName }}">
                                        <td class="feature-name">{{ $feature }}</td>
                                        <td>
                                            <div class="form-check">
                                                <input class="form-check-input permission-checkbox view-checkbox" type="checkbox" name="permissions[{{ $moduleName }}][{{ $feature }}][view]"
                                                       value="1"
                                                       {{ $isAdmin ? 'checked' : (isset($userPermissions[$moduleName][$feature]['view']) ? 'checked' : ($defaults['view'] ? 'checked' : '')) }}>
                                            </div>
                                        </td>
                                        <td>
                                            <div class="form-check">
                                                <input class="form-check-input permission-checkbox" type="checkbox" name="permissions[{{ $moduleName }}][{{ $feature }}][add]"
                                                       value="1"
                                                       {{ $isAdmin ? 'checked' : (isset($userPermissions[$moduleName][$feature]['add']) ? 'checked' : ($defaults['add'] ? 'checked' : '')) }}>
                                            </div>
                                        </td>
                                        <td>
                                            <div class="form-check">
                                                <input class="form-check-input permission-checkbox" type="checkbox" name="permissions[{{ $moduleName }}][{{ $feature }}][edit]"
                                                       value="1"
                                                       {{ $isAdmin ? 'checked' : (isset($userPermissions[$moduleName][$feature]['edit']) ? 'checked' : ($defaults['edit'] ? 'checked' : '')) }}>
                                            </div>
                                        </td>
                                        @if(!in_array($feature, $noDeleteFeatures))
                                        <td>
                                            <div class="form-check">
                                                <input class="form-check-input permission-checkbox" type="checkbox" name="permissions[{{ $moduleName }}][{{ $feature }}][delete]"
                                                       value="1"
                                                       {{ $isAdmin ? 'checked' : (isset($userPermissions[$moduleName][$feature]['delete']) ? 'checked' : ($defaults['delete'] ? 'checked' : '')) }}>
                                            </div>
                                        </td>
                                        @else
                                        <td></td>
                                        @endif
                                    </tr>
                                @endforeach
                            @endforeach
                        </tbody>
                    </table>
                </div>
                <script>
                    document.addEventListener('DOMContentLoaded', function() {
                        const checkAllBtn = document.getElementById('check-all');
                        const uncheckAllBtn = document.getElementById('uncheck-all');
                        const allCheckboxes = document.querySelectorAll('.permission-checkbox, .module-view-checkbox');

                        checkAllBtn.addEventListener('click', function() {
                            allCheckboxes.forEach(cb => cb.checked = true);
                            updateFeatureStates();
                        });

                        uncheckAllBtn.addEventListener('click', function() {
                            allCheckboxes.forEach(cb => cb.checked = false);
                            updateFeatureStates();
                        });

                        function updateFeatureStates() {
                            document.querySelectorAll('.module-row').forEach(moduleRow => {
                                const module = moduleRow.dataset.module;
                                const moduleViewCb = moduleRow.querySelector('.module-view-checkbox');
                                const featureRows = document.querySelectorAll(`.feature-row[data-module="${module}"]`);
                                const enabled = moduleViewCb.checked;
                                featureRows.forEach(row => {
                                    const checkboxes = row.querySelectorAll('.permission-checkbox');
                                    checkboxes.forEach(cb => cb.disabled = !enabled);
                                    row.style.display = enabled ? '' : 'none';
                                });
                            });
                        }

                        // Initial state
                        updateFeatureStates();

                        // Update on module view change
                        document.querySelectorAll('.module-view-checkbox').forEach(cb => {
                            cb.addEventListener('change', updateFeatureStates);
                        });
                    });
                </script>
                <div class="d-flex justify-content-end mt-4">
                    <a href="{{ route('administration.user-management') }}" class="btn btn-secondary me-2">Back</a>
                    <button type="submit" class="btn btn-primary">Save Permissions</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection

