 @extends('layouts.master')

@section('title', 'User Settings - Prolex Law Firm System')

@section('page-title', 'User Settings')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title mb-0">User Settings Options</h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <!-- User Management Card -->
                        <div class="col-md-4 mb-4">
                            <div class="card h-100 border-primary">
                                <div class="card-body text-center">
                                    <i class="fas fa-user fa-3x text-primary mb-3"></i>
                                    <h5 class="card-title">User</h5>
                                    <p class="card-text text-muted">Manage user accounts and profiles.</p>
                                    <a href="{{ route('administration.user-management') }}" class="btn btn-primary">
                                        <i class="fas fa-arrow-right me-2"></i>Manage Users
                                    </a>
                                </div>
                            </div>
                        </div>

                        <!-- Groups Management Card -->
                        <div class="col-md-4 mb-4">
                            <div class="card h-100 border-success">
                                <div class="card-body text-center">
                                    <i class="fas fa-users fa-3x text-success mb-3"></i>
                                    <h5 class="card-title">Groups</h5>
                                    <p class="card-text text-muted">Manage user groups and permissions.</p>
                                    <a href="{{ route('administration.groups.index') }}" class="btn btn-success">
                                        <i class="fas fa-arrow-right me-2"></i>Manage Groups
                                    </a>
                                </div>
                            </div>
                        </div>

                        <!-- Roles Management Card -->
                        <div class="col-md-4 mb-4">
                            <div class="card h-100 border-warning">
                                <div class="card-body text-center">
                                    <i class="fas fa-user-tag fa-3x text-warning mb-3"></i>
                                    <h5 class="card-title">Roles</h5>
                                    <p class="card-text text-muted">Manage user roles and access levels.</p>
                                    <a href="{{ route('administration.roles.index') }}" class="btn btn-warning">
                                        <i class="fas fa-arrow-right me-2"></i>Manage Roles
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

