@extends('layouts.master')

@section('title', 'Edit Module - Prolex Law Firm')

@section('content')
<style>
    * {
        margin: 0;
        padding: 0;
        box-sizing: border-box;
    }

    .admin-container {
        min-height: 100vh;
        background: linear-gradient(135deg, #f8fafc 0%, #e0f2fe 100%);
        padding: 2rem 1.5rem;
    }

    .admin-header {
        max-width: 1200px;
        margin: 0 auto 3rem;
        text-align: center;
    }

    .admin-header h1 {
        font-size: 2.5rem;
        color: #1f2937;
        margin-bottom: 0.5rem;
        font-weight: bold;
    }

    .admin-header p {
        color: #6b7280;
        font-size: 1.125rem;
    }

    .services-grid {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
        gap: 1.5rem;
        max-width: 1200px;
        margin: 0 auto;
    }

    .service-card {
        background: white;
        border-radius: 12px;
        box-shadow: 0 4px 6px rgba(0,0,0,0.1);
        overflow: hidden;
        cursor: pointer;
        transition: all 0.3s ease;
        position: relative;
        text-decoration: none;
        display: block;
    }

    .service-card:hover {
        transform: translateY(-8px);
        box-shadow: 0 20px 25px rgba(0,0,0,0.15);
    }

    .card-header {
        height: 8px;
    }

    .card-header.red { background: linear-gradient(90deg, #f43f5e, #e11d48); }
    .card-header.blue { background: linear-gradient(90deg, #3b82f6, #2563eb); }
    .card-header.green { background: linear-gradient(90deg, #22c55e, #16a34a); }
    .card-header.yellow { background: linear-gradient(90deg, #eab308, #ca8a04); }
    .card-header.purple { background: linear-gradient(90deg, #8b5cf6, #7c3aed); }
    .card-header.pink { background: linear-gradient(90deg, #ec4899, #db2777); }
    .card-header.orange { background: linear-gradient(90deg, #f97316, #ea580c); }
    .card-header.teal { background: linear-gradient(90deg, #14b8a6, #0d9488); }
    .card-header.indigo { background: linear-gradient(90deg, #6366f1, #4f46e5); }

    .card-content {
        padding: 1.5rem;
    }

    .card-top {
        display: flex;
        justify-content: space-between;
        align-items: flex-start;
        margin-bottom: 1rem;
    }

    .icon-wrapper {
        padding: 0.75rem;
        border-radius: 8px;
        transition: transform 0.3s ease;
        display: flex;
        align-items: center;
        justify-content: center;
    }

    .icon-wrapper.red-bg { background: linear-gradient(135deg, #f43f5e, #e11d48); }
    .icon-wrapper.blue-bg { background: linear-gradient(135deg, #3b82f6, #2563eb); }
    .icon-wrapper.green-bg { background: linear-gradient(135deg, #22c55e, #16a34a); }
    .icon-wrapper.yellow-bg { background: linear-gradient(135deg, #eab308, #ca8a04); }
    .icon-wrapper.purple-bg { background: linear-gradient(135deg, #8b5cf6, #7c3aed); }
    .icon-wrapper.pink-bg { background: linear-gradient(135deg, #ec4899, #db2777); }
    .icon-wrapper.orange-bg { background: linear-gradient(135deg, #f97316, #ea580c); }
    .icon-wrapper.teal-bg { background: linear-gradient(135deg, #14b8a6, #0d9488); }
    .icon-wrapper.indigo-bg { background: linear-gradient(135deg, #6366f1, #4f46e5); }

    .service-card:hover .icon-wrapper {
        transform: scale(1.1);
    }

    .card-icon {
        font-size: 2rem;
        color: white;
    }

    .arrow-icon {
        width: 24px;
        height: 24px;
        transition: transform 0.3s ease;
    }

    .arrow-icon.red-arrow { fill: #f43f5e; }
    .arrow-icon.blue-arrow { fill: #3b82f6; }
    .arrow-icon.green-arrow { fill: #22c55e; }
    .arrow-icon.yellow-arrow { fill: #eab308; }
    .arrow-icon.purple-arrow { fill: #8b5cf6; }
    .arrow-icon.pink-arrow { fill: #ec4899; }
    .arrow-icon.orange-arrow { fill: #f97316; }
    .arrow-icon.teal-arrow { fill: #14b8a6; }
    .arrow-icon.indigo-arrow { fill: #6366f1; }

    .service-card:hover .arrow-icon {
        transform: translateX(4px);
    }

    .card-title {
        font-size: 1.25rem;
        font-weight: bold;
        color: #1f2937;
        margin-bottom: 0.5rem;
    }

    .card-description {
        color: #6b7280;
        line-height: 1.6;
        font-size: 0.95rem;
    }

    .learn-more {
        margin-top: 1rem;
        display: flex;
        align-items: center;
        gap: 0.5rem;
        font-weight: 600;
        opacity: 0;
        transition: all 0.3s ease;
    }

    .learn-more.red-text { color: #f43f5e; }
    .learn-more.blue-text { color: #3b82f6; }
    .learn-more.green-text { color: #22c55e; }
    .learn-more.yellow-text { color: #eab308; }
    .learn-more.purple-text { color: #8b5cf6; }
    .learn-more.pink-text { color: #ec4899; }
    .learn-more.orange-text { color: #f97316; }
    .learn-more.teal-text { color: #14b8a6; }
    .learn-more.indigo-text { color: #6366f1; }

    .service-card:hover .learn-more {
        opacity: 1;
    }

    .learn-more svg {
        width: 16px;
        height: 16px;
    }

    .card-footer {
        height: 4px;
        width: 0;
        transition: width 0.3s ease;
    }

    .card-footer.red-footer { background: linear-gradient(90deg, #f43f5e, #e11d48); }
    .card-footer.blue-footer { background: linear-gradient(90deg, #3b82f6, #2563eb); }
    .card-footer.green-footer { background: linear-gradient(90deg, #22c55e, #16a34a); }
    .card-footer.yellow-footer { background: linear-gradient(90deg, #eab308, #ca8a04); }
    .card-footer.purple-footer { background: linear-gradient(90deg, #8b5cf6, #7c3aed); }
    .card-footer.pink-footer { background: linear-gradient(90deg, #ec4899, #db2777); }
    .card-footer.orange-footer { background: linear-gradient(90deg, #f97316, #ea580c); }
    .card-footer.teal-footer { background: linear-gradient(90deg, #14b8a6, #0d9488); }
    .card-footer.indigo-footer { background: linear-gradient(90deg, #6366f1, #4f46e5); }

    .service-card:hover .card-footer {
        width: 100%;
    }

    @media (max-width: 768px) {
        .admin-header h1 {
            font-size: 1.875rem;
        }
        .services-grid {
            grid-template-columns: 1fr;
        }
    }
</style>

<div class="admin-container">
    <div class="admin-header">
        <h1>Edit Menu</h1>
        <p>Manage and configure your law firm's modules and settings</p>
    </div>

    <div class="services-grid">
        <!-- Chart of Accounts -->
        <a href="{{ route('modules.edit.chart-of-accounts') }}" class="service-card">
            <div class="card-header red"></div>
            <div class="card-content">
                <div class="card-top">
                    <div class="icon-wrapper red-bg">
                        <i class="fas fa-book card-icon"></i>
                    </div>
                    <svg class="arrow-icon red-arrow" viewBox="0 0 24 24" fill="currentColor">
                        <path d="M9 6L15 12L9 18"></path>
                    </svg>
                </div>
                <h3 class="card-title">Chart of Accounts</h3>
                <p class="card-description">Manage your accounting structure and financial categories</p>
                <div class="learn-more red-text">
                    Edit Settings
                    <svg viewBox="0 0 24 24" fill="currentColor">
                        <path d="M9 6L15 12L9 18"></path>
                    </svg>
                </div>
            </div>
            <div class="card-footer red-footer"></div>
        </a>

        <!-- Client -->
        <a href="{{ route('modules.edit.clients') }}" class="service-card">
            <div class="card-header pink"></div>
            <div class="card-content">
                <div class="card-top">
                    <div class="icon-wrapper pink-bg">
                        <i class="fas fa-user card-icon"></i>
                    </div>
                    <svg class="arrow-icon pink-arrow" viewBox="0 0 24 24" fill="currentColor">
                        <path d="M9 6L15 12L9 18"></path>
                    </svg>
                </div>
                <h3 class="card-title">Client</h3>
                <p class="card-description">Configure client management settings and information</p>
                <div class="learn-more pink-text">
                    Edit Settings
                    <svg viewBox="0 0 24 24" fill="currentColor">
                        <path d="M9 6L15 12L9 18"></path>
                    </svg>
                </div>
            </div>
            <div class="card-footer pink-footer"></div>
        </a>

        <!-- Cases -->
        <a href="{{ route('modules.edit.case') }}" class="service-card">
            <div class="card-header purple"></div>
            <div class="card-content">
                <div class="card-top">
                    <div class="icon-wrapper purple-bg">
                        <i class="fas fa-gavel card-icon"></i>
                    </div>
                    <svg class="arrow-icon purple-arrow" viewBox="0 0 24 24" fill="currentColor">
                        <path d="M9 6L15 12L9 18"></path>
                    </svg>
                </div>
                <h3 class="card-title">Cases</h3>
                <p class="card-description">Add new cases and view/manage existing cases</p>
                <div class="learn-more purple-text">
                    Manage Cases
                    <svg viewBox="0 0 24 24" fill="currentColor">
                        <path d="M9 6L15 12L9 18"></path>
                    </svg>
                </div>
            </div>
            <div class="card-footer purple-footer"></div>
        </a>

        <!-- Lawyer -->
        <a href="{{ route('modules.edit.lawyer') }}" class="service-card">
            <div class="card-header purple"></div>
            <div class="card-content">
                <div class="card-top">
                    <div class="icon-wrapper purple-bg">
                        <i class="fas fa-gavel card-icon"></i>
                    </div>
                    <svg class="arrow-icon purple-arrow" viewBox="0 0 24 24" fill="currentColor">
                        <path d="M9 6L15 12L9 18"></path>
                    </svg>
                </div>
                <h3 class="card-title">Lawyer</h3>
                <p class="card-description">Configure lawyer profiles, specializations, and assignments</p>
                <div class="learn-more purple-text">
                    Edit Settings
                    <svg viewBox="0 0 24 24" fill="currentColor">
                        <path d="M9 6L15 12L9 18"></path>
                    </svg>
                </div>
            </div>
            <div class="card-footer purple-footer"></div>
        </a>

        <!-- Court Details -->
        <a href="{{ route('modules.edit.court-details') }}" class="service-card">
            <div class="card-header indigo"></div>
            <div class="card-content">
                <div class="card-top">
                    <div class="icon-wrapper indigo-bg">
                        <i class="fas fa-balance-scale card-icon"></i>
                    </div>
                    <svg class="arrow-icon indigo-arrow" viewBox="0 0 24 24" fill="currentColor">
                        <path d="M9 6L15 12L9 18"></path>
                    </svg>
                </div>
                <h3 class="card-title">Court Details</h3>
                <p class="card-description">Manage court information, jurisdictions, and proceedings</p>
                <div class="learn-more indigo-text">
                    Edit Settings
                    <svg viewBox="0 0 24 24" fill="currentColor">
                        <path d="M9 6L15 12L9 18"></path>
                    </svg>
                </div>
            </div>
            <div class="card-footer indigo-footer"></div>
        </a>

        <!-- Suppliers -->
        <a href="{{ route('modules.edit.suppliers') }}" class="service-card">
            <div class="card-header yellow"></div>
            <div class="card-content">
                <div class="card-top">
                    <div class="icon-wrapper yellow-bg">
                        <i class="fas fa-truck card-icon"></i>
                    </div>
                    <svg class="arrow-icon yellow-arrow" viewBox="0 0 24 24" fill="currentColor">
                        <path d="M9 6L15 12L9 18"></path>
                    </svg>
                </div>
                <h3 class="card-title">Suppliers</h3>
                <p class="card-description">Configure supplier details and vendor management settings</p>
                <div class="learn-more yellow-text">
                    Edit Settings
                    <svg viewBox="0 0 24 24" fill="currentColor">
                        <path d="M9 6L15 12L9 18"></path>
                    </svg>
                </div>
            </div>
            <div class="card-footer yellow-footer"></div>
        </a>

        <!-- Tax -->
        <a href="{{ route('taxes.index') }}" class="service-card">
            <div class="card-header green"></div>
            <div class="card-content">
                <div class="card-top">
                    <div class="icon-wrapper green-bg">
                        <i class="fas fa-calculator card-icon"></i>
                    </div>
                    <svg class="arrow-icon green-arrow" viewBox="0 0 24 24" fill="currentColor">
                        <path d="M9 6L15 12L9 18"></path>
                    </svg>
                </div>
                <h3 class="card-title">Tax</h3>
                <p class="card-description">Manage tax rates, categories, and calculation settings</p>
                <div class="learn-more green-text">
                    Edit Settings
                    <svg viewBox="0 0 24 24" fill="currentColor">
                        <path d="M9 6L15 12L9 18"></path>
                    </svg>
                </div>
            </div>
            <div class="card-footer green-footer"></div>
        </a>

        <!-- Multi Currency -->
        <a href="{{ route('modules.edit.multi-currency') }}" class="service-card">
            <div class="card-header blue"></div>
            <div class="card-content">
                <div class="card-top">
                    <div class="icon-wrapper blue-bg">
                        <i class="fas fa-dollar-sign card-icon"></i>
                    </div>
                    <svg class="arrow-icon blue-arrow" viewBox="0 0 24 24" fill="currentColor">
                        <path d="M9 6L15 12L9 18"></path>
                    </svg>
                </div>
                <h3 class="card-title">Multi Currency</h3>
                <p class="card-description">Configure currency settings and exchange rate management</p>
                <div class="learn-more blue-text">
                    Edit Settings
                    <svg viewBox="0 0 24 24" fill="currentColor">
                        <path d="M9 6L15 12L9 18"></path>
                    </svg>
                </div>
            </div>
            <div class="card-footer blue-footer"></div>
        </a>
    </div>
</div>

<script src="https://unpkg.com/alpinejs@3.x.x/dist/cdn.min.js"></script>
@endsection