@extends('layouts.master')

@section('title', 'Add Age Analysis - Prolex Law Firm')

@push('styles')
<style>
    body {
      background: #f8f9fa;
    }
    .container {
      margin-top: 2rem;
    }
    .btn-toggle-group, .btn-toggle-interval {
      margin-bottom: 1rem;
    }
    .btn-toggle-group .btn, .btn-toggle-interval .btn {
      margin-right: 0.5rem;
    }
    .card-header h4 {
      margin: 0;
    }
    .action-btn {
      min-width: 40px;
    }
</style>
@endpush

@section('content')
<div class="container">
  <!-- Header -->
  <div class="d-flex justify-content-between align-items-center mb-4">
    <h2>Supplier Ageing Analysis</h2>
    <div>
      <a href="{{ route('modules.edit.suppliers') }}" class="btn btn-outline-primary me-2"><i class="fas fa-arrow-left"></i> Back to Suppliers</a>
      <button class="btn btn-secondary" onclick="resetForm()"><i class="fas fa-undo"></i> Reset</button>
    </div>
  </div>

  <!-- Form Card -->
  <div class="card mb-4 shadow">
    <div class="card-header bg-primary text-white">
      <h4 id="form-title">Create New Analysis</h4>
    </div>
    <div class="card-body">
      <form id="ageingForm" action="{{ route('age-analysis.store') }}" method="POST">
        @csrf
        <input type="hidden" id="analysisId" name="id" />

        <!-- Age Code & Description -->
        <div class="mb-3">
          <label for="ageCode" class="form-label">Age Code</label>
          <input type="text" class="form-control" id="ageCode" name="age_code" placeholder="Enter Age Code" value="{{ old('age_code') }}" required />
          @error('age_code')
            <div class="text-danger">{{ $message }}</div>
          @enderror
        </div>
        <div class="mb-3">
          <label for="description" class="form-label">Description</label>
          <input type="text" class="form-control" id="description" name="description" placeholder="Enter Description" value="{{ old('description') }}" required />
          @error('description')
            <div class="text-danger">{{ $message }}</div>
          @enderror
        </div>

        <!-- Tabs for Group & Interval -->
        <ul class="nav nav-tabs mb-3" id="analysisTabs" role="tablist">
          <li class="nav-item" role="presentation">
            <button class="nav-link active" id="group-tab" data-bs-toggle="tab" data-bs-target="#group-pane" type="button" role="tab" aria-controls="group-pane" aria-selected="true">Group</button>
          </li>
          <li class="nav-item" role="presentation">
            <button class="nav-link" id="interval-tab" data-bs-toggle="tab" data-bs-target="#interval-pane" type="button" role="tab" aria-controls="interval-pane" aria-selected="false">Interval</button>
          </li>
        </ul>

        <div class="tab-content" id="tabContent">
          <!-- Group Tab -->
          <div class="tab-pane fade show active" id="group-pane" role="tabpanel" aria-labelledby="group-tab">
            <div class="mb-3">
              <label class="form-label">Select Group Type</label>
              <div class="btn-group" id="groupTypeBtns" role="group">
                <button type="button" class="btn btn-outline-primary active" data-group="monthly">Monthly</button>
                <button type="button" class="btn btn-outline-primary" data-group="daily">Daily</button>
                <button type="button" class="btn btn-outline-primary" data-group="custom">Custom</button>
              </div>
            </div>
            <div id="groupFields"></div>
          </div>
          <!-- Interval Tab -->
          <div class="tab-pane fade" id="interval-pane" role="tabpanel" aria-labelledby="interval-tab">
            <div class="mb-3">
              <label class="form-label">Select Interval Type</label>
              <div class="btn-group" id="intervalTypeBtns" role="group">
                <button type="button" class="btn btn-outline-primary active" data-interval="statement_date">Statement Date</button>
                <button type="button" class="btn btn-outline-primary" data-interval="invoice_date">Invoice Date</button>
              </div>
            </div>
            <div class="mb-3">
              <label class="form-label">Select Duration</label>
              <div class="btn-group" id="intervalDurationBtns" role="group">
                <button type="button" class="btn btn-outline-primary active" data-duration="30">30 Days</button>
                <button type="button" class="btn btn-outline-primary" data-duration="7">7 Days</button>
                <button type="button" class="btn btn-outline-primary" data-duration="custom">Custom</button>
              </div>
            </div>
            <div id="intervalFields"></div>
          </div>
        </div>

        <!-- Submit Buttons -->
        <div class="mt-4 text-center">
          <button type="submit" class="btn btn-success" id="submitBtn">Create</button>
        </div>
      </form>
    </div>
  </div>

  <!-- DataTable -->
  <div class="card shadow mb-4">
    <div class="card-header bg-info text-white">
      <h4 class="mb-0">Saved Analyses</h4>
    </div>
    <div class="card-body">
      <table id="analysesTable" class="table table-striped table-bordered" style="width:100%">
        <thead>
          <tr>
            <th>Age Code</th>
            <th>Description</th>
            <th>Group Type</th>
            <th>Interval Type</th>
            <th>Duration</th>
            <th>Actions</th>
          </tr>
        </thead>
        <tbody id="tableBody">
          @forelse($ageingAnalyses ?? [] as $analysis)
          <tr>
            <td>{{ $analysis->age_code }}</td>
            <td>{{ $analysis->description }}</td>
            <td>{{ ucfirst($analysis->group_type) }}</td>
            <td>{{ ucfirst(str_replace('_', ' ', $analysis->interval_type)) }}</td>
            <td>{{ $analysis->interval_days }} Days</td>
            <td class="text-center">
              <button class="btn btn-sm btn-primary action-btn" onclick="editAnalysis({{ $analysis->id }})" title="Edit"><i class="fas fa-edit"></i></button>
              <form action="{{ route('ageing.delete', $analysis->id) }}" method="POST" style="display: inline;">
                @csrf
                @method('DELETE')
                <button type="submit" class="btn btn-sm btn-danger action-btn" onclick="return confirm('Are you sure you want to delete this analysis?')" title="Delete"><i class="fas fa-trash"></i></button>
              </form>
            </td>
          </tr>
          @empty
          <tr>
            <td colspan="6" class="text-center">No ageing analyses found.</td>
          </tr>
          @endforelse
        </tbody>
      </table>
    </div>
  </div>
</div>
@endsection

@push('scripts')
<script>
  // Variables
  let deleteId = null;

  // Data for dynamic fields
  const groupOptions = {
    monthly: ["Current", "30 Days", "60 Days", "90 Days", "120 Days", "150 Days", "180 Days"],
    daily: ["Today", "1 Day", "2 Days", "3 Days", "4 Days", "5 Days", "6 Days"],
    custom: ["Custom Age 1", "Custom Age 2", "Custom Age 3", "Custom Age 4", "Custom Age 5", "Custom Age 6", "Custom Age 7"]
  };

  const intervalOptions = {
    "30": ["30 Days", "60 Days", "90 Days", "120 Days", "150 Days", "180 Days"],
    "7": ["7 Days", "14 Days", "21 Days", "28 Days", "35 Days", "42 Days"],
    custom: ["Custom Interval 1", "Custom Interval 2", "Custom Interval 3", "Custom Interval 4", "Custom Interval 5", "Custom Interval 6"]
  };

  // Generate input fields
  function generateFields(fields, prefix) {
    return fields.map((field, index) => `
      <div class="mb-2">
        <label class="form-label">Age ${index + 1}</label>
        <input type="text" class="form-control" name="${prefix}_age_${index + 1}" value="${field}" />
      </div>
    `).join('');
  }

  // Handle Group Buttons
  document.querySelectorAll('#groupTypeBtns .btn').forEach(btn => {
    btn.addEventListener('click', () => {
      document.querySelectorAll('#groupTypeBtns .btn').forEach(b => b.classList.remove('active'));
      btn.classList.add('active');
      const groupType = btn.dataset.group;
      updateGroupFields(groupType);
    });
  });

  function updateGroupFields(type) {
    document.getElementById('groupFields').innerHTML = generateFields(groupOptions[type], 'group');
  }

  // Initialize default group fields
  updateGroupFields('monthly');

  // Handle Interval Buttons
  document.querySelectorAll('#intervalDurationBtns .btn').forEach(btn => {
    btn.addEventListener('click', () => {
      document.querySelectorAll('#intervalDurationBtns .btn').forEach(b => b.classList.remove('active'));
      btn.classList.add('active');
      const duration = btn.dataset.duration;
      updateIntervalFields(duration);
    });
  });

  function updateIntervalFields(duration) {
    document.getElementById('intervalFields').innerHTML = generateFields(intervalOptions[duration], 'interval');
  }

  // Initialize default interval fields
  updateIntervalFields('30');

  // Edit Analysis
  function editAnalysis(id) {
    // Fetch data via AJAX or redirect to edit route
    window.location.href = '{{ route("ageing.edit", ":id") }}'.replace(':id', id);
  }

  // Reset form
  function resetForm() {
    document.getElementById('ageingForm').reset();
    document.getElementById('form-title').innerText = 'Create New Analysis';
    document.getElementById('submitBtn').innerText = 'Create';
    updateGroupFields('monthly');
    updateIntervalFields('30');
  }
</script>
@endpush
