@extends('layouts.master')

@section('title', 'Add Case Outcome - Prolex Law Firm')

@section('content')
<style>
    .container {
        max-width: 800px;
        margin: 40px auto;
        background-color: #f8fafc;
        padding: 30px;
        border-radius: 12px;
        box-shadow: 0 4px 6px rgba(0,0,0,0.1);
    }

    h1 {
        text-align: center;
        color: #1e40af;
        margin-bottom: 30px;
        font-size: 2.5rem;
        font-weight: 700;
    }

    .form-section {
        background: white;
        border-radius: 8px;
        padding: 25px;
        margin-bottom: 25px;
        border: 1px solid #e2e8f0;
        box-shadow: 0 2px 4px rgba(0,0,0,0.05);
    }

    .section-title {
        color: #2d3748;
        font-size: 1.5rem;
        font-weight: 600;
        margin-bottom: 20px;
        border-bottom: 2px solid #e2e8f0;
        padding-bottom: 10px;
    }

    .form-group {
        margin-bottom: 20px;
    }

    .form-row {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
        gap: 20px;
    }

    label {
        display: block;
        margin-bottom: 8px;
        font-weight: 600;
        color: #4a5568;
        font-size: 0.95rem;
    }

    input, select, textarea {
        width: 100%;
        padding: 12px 16px;
        border: 2px solid #e2e8f0;
        border-radius: 6px;
        font-size: 1rem;
        transition: all 0.3s ease;
        background-color: #ffffff;
    }

    input:focus, select:focus, textarea:focus {
        outline: none;
        border-color: #3b82f6;
        box-shadow: 0 0 0 3px rgba(59, 130, 246, 0.1);
    }

    textarea {
        resize: vertical;
        min-height: 100px;
    }

    .required::after {
        content: ' *';
        color: #e53e3e;
    }

    .form-help {
        font-size: 0.85rem;
        color: #6b7280;
        margin-top: 5px;
        font-style: italic;
    }

    .submit-btn {
        background: linear-gradient(135deg, #3b82f6, #1d4ed8);
        color: white;
        padding: 15px 40px;
        border: none;
        border-radius: 8px;
        font-size: 1.1rem;
        font-weight: 600;
        cursor: pointer;
        transition: all 0.3s ease;
        box-shadow: 0 4px 6px rgba(59, 130, 246, 0.3);
    }

    .submit-btn:hover {
        transform: translateY(-2px);
        box-shadow: 0 6px 12px rgba(59, 130, 246, 0.4);
    }

    .submit-btn:active {
        transform: translateY(0);
    }

    .back-btn {
        background: #6b7280;
        color: white;
        padding: 12px 24px;
        border: none;
        border-radius: 8px;
        font-size: 1rem;
        font-weight: 600;
        cursor: pointer;
        transition: all 0.3s ease;
        text-decoration: none;
        display: inline-block;
        margin-bottom: 20px;
    }

    .back-btn:hover {
        background: #4b5563;
        transform: translateY(-1px);
    }

    .checkbox-group {
        display: flex;
        align-items: center;
        gap: 10px;
    }

    .checkbox-group input[type="checkbox"] {
        width: auto;
        margin: 0;
    }

    .checkbox-group label {
        margin-bottom: 0;
        cursor: pointer;
    }
</style>

<div class="container">
    <a href="{{ route('modules.edit.case-outcomes.list') }}" class="back-btn">← Back to List</a>
    <h1>Add New Case Outcome</h1>

    <form id="caseOutcomeForm" action="{{ route('case-outcomes.store') }}" method="POST">
        @csrf

        <div class="form-section">
            <h2 class="section-title">Basic Information</h2>

            <div class="form-row">
                <div class="form-group">
                    <label for="code" class="required">Outcome Code</label>
                    <input type="text" id="code" name="code" required placeholder="e.g., WON, LOST, SETTLED">
                    <div class="form-help">Enter a unique code for this case outcome</div>
                </div>
                <div class="form-group">
                    <label for="name" class="required">Outcome Name</label>
                    <input type="text" id="name" name="name" required placeholder="e.g., Won, Lost, Settled">
                    <div class="form-help">Enter the display name for this case outcome</div>
                </div>
            </div>

            <div class="form-group">
                <label for="description" class="required">Outcome Description</label>
                <textarea id="description" name="description" rows="4" required placeholder="Provide a detailed description of this case outcome..."></textarea>
                <div class="form-help">Describe when and why this case outcome would be used</div>
            </div>
        </div>

        <div style="text-align: center; margin-top: 30px;">
            <button type="submit" class="submit-btn">Save Case Outcome</button>
        </div>
    </form>
</div>

<script>
    // Form validation
    document.getElementById('caseOutcomeForm').addEventListener('submit', function(e) {
        const code = document.getElementById('code').value.trim();
        const name = document.getElementById('name').value.trim();
        const description = document.getElementById('description').value.trim();

        if (!code || !name || !description) {
            e.preventDefault();
            alert('Please fill in all required fields.');
            return false;
        }

        // Validate code format (alphanumeric, underscores, hyphens only)
        const codePattern = /^[A-Z0-9_-]+$/;
        if (!codePattern.test(code)) {
            e.preventDefault();
            alert('Outcome code can only contain uppercase letters, numbers, underscores, and hyphens.');
            return false;
        }
    });
</script>
@endsection
