@extends('layouts.master')

@section('title', 'Add Case - Prolex Law Firm')

@section('content')
<style>
    .container {
        max-width: 1200px;
        margin: 40px auto;
        background-color: #f8fafc;
        padding: 30px;
        border-radius: 12px;
        box-shadow: 0 4px 6px rgba(0,0,0,0.1);
    }

    h1 {
        text-align: center;
        color: #1e40af;
        margin-bottom: 30px;
        font-size: 2.5rem;
        font-weight: 700;
    }

    .form-section {
        background: white;
        border-radius: 8px;
        padding: 25px;
        margin-bottom: 25px;
        border: 1px solid #e2e8f0;
        box-shadow: 0 2px 4px rgba(0,0,0,0.05);
        overflow: visible;
    }

    .section-title {
        color: #2d3748;
        font-size: 1.5rem;
        font-weight: 600;
        margin-bottom: 20px;
        border-bottom: 2px solid #e2e8f0;
        padding-bottom: 10px;
    }

    .form-group {
        margin-bottom: 20px;
    }

    .form-row {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
        gap: 20px;
    }

    label {
        display: block;
        margin-bottom: 8px;
        font-weight: 600;
        color: #4a5568;
        font-size: 0.95rem;
    }

    input, select, textarea {
        width: 100%;
        padding: 12px 16px;
        border: 2px solid #e2e8f0;
        border-radius: 6px;
        font-size: 1rem;
        transition: all 0.3s ease;
        background-color: #ffffff;
    }

    input:focus, select:focus, textarea:focus {
        outline: none;
        border-color: #3b82f6;
        box-shadow: 0 0 0 3px rgba(59, 130, 246, 0.1);
    }

    select {
        background-color: #ffffff !important;
        color: #000000 !important;
        position: relative;
        z-index: 10;
    }

    option {
        background-color: #ffffff !important;
        color: #000000 !important;
    }

    .required::after {
        content: ' *';
        color: #e53e3e;
    }

    .submit-btn {
        background: linear-gradient(135deg, #3b82f6, #1d4ed8);
        color: white;
        padding: 15px 40px;
        border: none;
        border-radius: 8px;
        font-size: 1.1rem;
        font-weight: 600;
        cursor: pointer;
        transition: all 0.3s ease;
        box-shadow: 0 4px 6px rgba(59, 130, 246, 0.3);
    }

    .submit-btn:hover {
        transform: translateY(-2px);
        box-shadow: 0 6px 12px rgba(59, 130, 246, 0.4);
    }

    .submit-btn:active {
        transform: translateY(0);
    }

    .party-row, .lawyer-row {
        display: flex;
        gap: 15px;
        align-items: end;
        margin-bottom: 15px;
        padding: 15px;
        background: #f8fafc;
        border-radius: 6px;
        border: 1px solid #e2e8f0;
    }

    .party-row .form-group, .lawyer-row .form-group {
        flex: 1;
        margin-bottom: 0;
    }

    .remove-btn {
        background: #ef4444;
        color: white;
        border: none;
        padding: 8px 12px;
        border-radius: 4px;
        cursor: pointer;
        font-size: 0.9rem;
    }

    .add-btn {
        background: #10b981;
        color: white;
        border: none;
        padding: 10px 20px;
        border-radius: 6px;
        cursor: pointer;
        font-size: 0.95rem;
        margin-top: 10px;
    }

    .hidden {
        display: none;
    }
</style>

<div class="container">
    <h1>Add New Case</h1>

    @if(session('success'))
        <div style="background-color: #d1fae5; color: #065f46; padding: 15px; border-radius: 6px; margin-bottom: 20px;">
            {{ session('success') }}
        </div>
    @endif

    @if($errors->any())
        <div style="background-color: #fee2e2; color: #991b1b; padding: 15px; border-radius: 6px; margin-bottom: 20px;">
            <ul style="margin: 0; padding-left: 20px;">
                @foreach($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    <form action="{{ route('case.store') }}" method="POST" novalidate>
        @csrf

        <!-- Case Core Details -->
        <div class="form-section">
            <h2 class="section-title">1️⃣ Core Case Details</h2>
            <div class="form-row">
                <div class="form-group">
                    <label for="case_id" class="required">Case ID</label>
                    <input type="text" id="case_id" name="case_id" value="{{ old('case_id', 'CASE' . str_pad(\App\Models\LegalCase::count() + 1, 3, '0', STR_PAD_LEFT)) }}" required readonly>
                </div>
                <div class="form-group">
                    <label for="case_name" class="required">Case Name</label>
                    <input type="text" id="case_name" name="case_name" value="{{ old('case_name') }}" required>
                </div>
                <div class="form-group">
                    <label for="client_id" class="required">Client ID</label>
                    <select id="client_id" name="client_id" required>
                        <option value="">Select Client</option>
                        @foreach($clients as $client)
                            <option value="{{ $client->id }}" {{ old('client_id') == $client->id ? 'selected' : '' }}>
                                {{ $client->full_name }} ({{ $client->client_id }})
                            </option>
                        @endforeach
                    </select>
                </div>
            </div>
            <div class="form-row">
                <div class="form-group">
                    <label for="category_code" class="required">Category Code</label>
                    <select id="category_code" name="category_code" required>
                        <option value="">Select Case Category</option>
                        @foreach($caseCategories as $category)
                            <option value="{{ $category->category_code }}" {{ old('category_code') == $category->category_code ? 'selected' : '' }}>
                                {{ $category->category_name }}
                            </option>
                        @endforeach
                    </select>
                </div>
                <div class="form-group">
                    <label for="type_id" class="required">Type ID</label>
                    <select id="type_id" name="type_id" required>
                        <option value="">Select Case Type</option>
                        @foreach($caseTypes as $type)
                            <option value="{{ $type->id }}" {{ old('type_id') == $type->id ? 'selected' : '' }}>
                                {{ $type->type_name }}
                            </option>
                        @endforeach
                    </select>
                </div>
                <div class="form-group">
                    <label for="priority_id" class="required">Priority ID</label>
                    <select id="priority_id" name="priority_id" required>
                        <option value="">Select Priority</option>
                        @foreach(\App\Models\CasePriority::all() as $priority)
                            <option value="{{ $priority->id }}" {{ old('priority_id') == $priority->id ? 'selected' : '' }}>
                                {{ $priority->priority_name }}
                            </option>
                        @endforeach
                    </select>
                </div>
            </div>
            <div class="form-row">
                <div class="form-group">
                    <label for="role_id" class="required">Role ID</label>
                    <select id="role_id" name="role_id" required>
                        <option value="">Select Role</option>
                        @foreach(\App\Models\CaseRole::all() as $role)
                            <option value="{{ $role->id }}" {{ old('role_id') == $role->id ? 'selected' : '' }}>
                                {{ $role->role_name }}
                            </option>
                        @endforeach
                    </select>
                </div>
            </div>
        </div>

        <!-- Assigned Lawyers -->
        <div class="form-section">
            <h2 class="section-title">2️⃣ Assigned Lawyers</h2>
            <div id="lawyers-container">
                <!-- Dynamic lawyer rows will be added here -->
            </div>
            <button type="button" class="add-btn" onclick="addLawyerRow()">Add Lawyer</button>
        </div>

        <!-- Dates -->
        <div class="form-section">
            <h2 class="section-title">3️⃣ Dates</h2>
            <div class="form-row">
                <div class="form-group">
                    <label for="date_of_incident">Date of Incident</label>
                    <input type="date" id="date_of_incident" name="date_of_incident" value="{{ old('date_of_incident') }}">
                </div>
                <div class="form-group">
                    <label for="court_appearance_date">Court Appearance Date</label>
                    <input type="date" id="court_appearance_date" name="court_appearance_date" value="{{ old('court_appearance_date') }}">
                </div>
            </div>
        </div>

        <!-- Notes -->
        <div class="form-section">
            <h2 class="section-title">4️⃣ Notes</h2>
            <div class="form-group">
                <label for="notes">Notes</label>
                <textarea id="notes" name="notes" rows="4" placeholder="Internal remarks, optional">{{ old('notes') }}</textarea>
            </div>
        </div>

        <div style="text-align: center; margin-top: 30px;">
            <button type="button" class="submit-btn" style="background: linear-gradient(135deg, #6b7280, #4b5563); margin-right: 15px;" onclick="clearForm()">Clear Form</button>
            <button type="submit" class="submit-btn">Save Case</button>
        </div>
    </form>
</div>

<script>
let lawyerIndex = 0;

function addLawyerRow() {
    const container = document.getElementById('lawyers-container');
    const row = document.createElement('div');
    row.className = 'lawyer-row';
    row.innerHTML = `
        <div class="form-group">
            <label>Lawyer ID</label>
            <select name="lawyers[${lawyerIndex}][lawyer_id]" required>
                <option value="">Select Lawyer</option>
                @foreach($lawyers as $lawyer)
                    <option value="{{ $lawyer->id }}">{{ $lawyer->full_name }} ({{ $lawyer->tier }})</option>
                @endforeach
            </select>
        </div>
        <div class="form-group">
            <label>Role</label>
            <select name="lawyers[${lawyerIndex}][role]" required>
                <option value="">Select Role</option>
                @foreach(\App\Models\LawyerRole::all() as $role)
                    <option value="{{ $role->code }}">{{ $role->name }}</option>
                @endforeach
            </select>
        </div>
        <button type="button" class="remove-btn" onclick="removeRow(this)">Remove</button>
    `;
    container.appendChild(row);
    lawyerIndex++;
}

function removeRow(button) {
    button.parentElement.remove();
}

// Initialize with one lawyer row
document.addEventListener('DOMContentLoaded', function() {
    addLawyerRow();
});

function clearForm() {
    // Clear all input fields except readonly ones
    const inputs = document.querySelectorAll('input:not([readonly]), select, textarea');
    inputs.forEach(input => {
        if (input.type === 'date') {
            // Reset date to today
            input.value = new Date().toISOString().split('T')[0];
        } else {
            input.value = '';
        }
    });

    // Clear dynamic lawyer rows
    const lawyersContainer = document.getElementById('lawyers-container');

    // Remove all existing rows
    lawyersContainer.innerHTML = '';

    // Reset index
    lawyerIndex = 0;

    // Add back one row
    addLawyerRow();
}
</script>
@endsection

