@extends('layouts.master')

@section('title', 'Add Tax - Prolex Law Firm')

@section('content')
<style>
    .container {
        max-width: 1200px;
        margin: 40px auto;
        background-color: #ffffff;
        padding: 40px;
        border-radius: 16px;
        box-shadow: 0 8px 24px rgba(0, 0, 0, 0.08);
        border: 1px solid #e6f2ff;
    }

    h1 {
        text-align: center;
        color: #0ea5e9;
        margin-bottom: 40px;
        font-size: 2.5rem;
        font-weight: 700;
        position: relative;
        padding-bottom: 15px;
    }

    h1:after {
        content: '';
        position: absolute;
        bottom: 0;
        left: 50%;
        transform: translateX(-50%);
        width: 80px;
        height: 4px;
        background: linear-gradient(90deg, #0ea5e9, #7dd3fc);
        border-radius: 2px;
    }

    .form-section {
        background: #f8fcff;
        border-radius: 12px;
        padding: 30px;
        margin-bottom: 30px;
        border: 1px solid #e0f2fe;
        box-shadow: 0 4px 12px rgba(14, 165, 233, 0.05);
        transition: all 0.3s ease;
    }

    .form-section:hover {
        box-shadow: 0 6px 16px rgba(14, 165, 233, 0.08);
    }

    .section-title {
        color: #0c4a6e;
        font-size: 1.5rem;
        font-weight: 600;
        margin-bottom: 25px;
        border-bottom: 2px solid #e0f2fe;
        padding-bottom: 12px;
        display: flex;
        align-items: center;
    }

    .section-title:before {
        content: '';
        display: inline-block;
        width: 6px;
        height: 24px;
        background: #0ea5e9;
        border-radius: 3px;
        margin-right: 12px;
    }

    .form-group {
        margin-bottom: 24px;
    }

    .form-row {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
        gap: 24px;
    }

    label {
        display: block;
        margin-bottom: 8px;
        font-weight: 600;
        color: #475569;
        font-size: 0.95rem;
    }

    input, select, textarea {
        width: 100%;
        padding: 14px 16px;
        border: 2px solid #e0f2fe;
        border-radius: 8px;
        font-size: 1rem;
        transition: all 0.3s ease;
        background-color: #ffffff;
        color: #334155;
    }

    input:focus, select:focus, textarea:focus {
        outline: none;
        border-color: #0ea5e9;
        box-shadow: 0 0 0 3px rgba(14, 165, 233, 0.15);
    }

    textarea {
        resize: vertical;
        min-height: 100px;
    }

    .required::after {
        content: ' *';
        color: #ef4444;
    }

    .checkbox-group {
        display: flex;
        align-items: center;
        gap: 10px;
        background: #ffffff;
        padding: 12px 16px;
        border-radius: 8px;
        border: 2px solid #e0f2fe;
        width: fit-content;
    }

    .checkbox-group input[type="checkbox"] {
        width: auto;
        margin: 0;
        accent-color: #0ea5e9;
    }

    .checkbox-group label {
        margin-bottom: 0;
        color: #475569;
    }

    .button-group {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-top: 40px;
        padding-top: 30px;
        border-top: 1px solid #e0f2fe;
    }

    .submit-btn, .refresh-btn, .back-btn {
        padding: 16px 42px;
        border: none;
        border-radius: 10px;
        font-size: 1.1rem;
        font-weight: 600;
        cursor: pointer;
        transition: all 0.3s ease;
        display: inline-flex;
        align-items: center;
        justify-content: center;
        gap: 8px;
    }

    .submit-btn {
        background: linear-gradient(135deg, #0ea5e9, #0284c7);
        color: white;
        box-shadow: 0 4px 12px rgba(14, 165, 233, 0.3);
    }

    .refresh-btn {
        background: linear-gradient(135deg, #ffffff, #f1f5f9);
        color: #0ea5e9;
        border: 2px solid #0ea5e9;
        box-shadow: 0 4px 12px rgba(14, 165, 233, 0.1);
    }

    .back-btn {
        background: linear-gradient(135deg, #ffffff, #f1f5f9);
        color: #475569;
        border: 2px solid #cbd5e1;
        text-decoration: none;
        display: inline-flex;
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.05);
    }

    .submit-btn:hover {
        transform: translateY(-3px);
        box-shadow: 0 6px 16px rgba(14, 165, 233, 0.4);
        background: linear-gradient(135deg, #0284c7, #0369a1);
    }

    .refresh-btn:hover {
        transform: translateY(-3px);
        box-shadow: 0 6px 16px rgba(14, 165, 233, 0.2);
        background: linear-gradient(135deg, #f8fafc, #e2e8f0);
    }

    .back-btn:hover {
        transform: translateY(-3px);
        box-shadow: 0 6px 16px rgba(0, 0, 0, 0.1);
        background: linear-gradient(135deg, #f8fafc, #e2e8f0);
        color: #334155;
    }

    .submit-btn:active, .refresh-btn:active, .back-btn:active {
        transform: translateY(0);
    }

    .icon {
        width: 20px;
        height: 20px;
        fill: currentColor;
    }

    @media (max-width: 768px) {
        .container {
            padding: 20px;
            margin: 20px;
        }
        
        .form-row {
            grid-template-columns: 1fr;
        }
        
        .button-group {
            flex-direction: column;
            gap: 15px;
        }
        
        .button-group > div {
            display: flex;
            flex-direction: column;
            width: 100%;
            gap: 10px;
        }
        
        .submit-btn, .refresh-btn, .back-btn {
            width: 100%;
            justify-content: center;
        }
    }
</style>

<div class="container">
    <h1>Add Tax</h1>

    <form id="taxForm" action="{{ route('taxes.store') }}" method="POST">
        @csrf

        <div class="form-section">
            <div class="section-title">Tax Information</div>

            <div class="form-row">
                <div class="form-group">
                    <label for="tax_name" class="required">Tax Name</label>
                    <input type="text" id="tax_name" name="tax_name" required placeholder="Enter tax name">
                </div>

                <div class="form-group">
                    <label for="tax_rate" class="required">Tax Rate (%)</label>
                    <input type="number" id="tax_rate" name="tax_rate" step="0.01" min="0" max="100" required placeholder="Enter tax rate">
                </div>
            </div>

            <div class="form-row">
                <div class="form-group">
                    <label for="tax_type" class="required">Tax Type</label>
                    <select id="tax_type" name="tax_type" required>
                        <option value="">Select Tax Type</option>
                        <option value="Corporate Income Tax">Corporate Income Tax</option>
                        <option value="PAYE / Payroll Tax">PAYE / Payroll Tax</option>
                        <option value="VAT">VAT</option>
                        <option value="Withholding Tax">Withholding Tax</option>
                        <option value="Capital Gains Tax">Capital Gains Tax</option>
                        <option value="Presumptive/Turnover Tax">Presumptive/Turnover Tax</option>
                        <option value="Local Business Taxes">Local Business Taxes</option>
                    </select>
                </div>

                <div class="form-group">
                    <label for="tax_description">Tax Description</label>
                    <input type="text" id="tax_description" name="tax_description" placeholder="Enter tax description (optional)">
                </div>
            </div>

            <div class="form-group">
                <div class="checkbox-group">
                    <input type="checkbox" id="is_active" name="is_active" value="1" checked>
                    <label for="is_active">Is Active</label>
                </div>
            </div>
        </div>

        <div class="button-group">
            <a href="{{ route('taxes.index') }}" class="back-btn">
                <svg class="icon" viewBox="0 0 24 24">
                    <path d="M19 12H5M12 19l-7-7 7-7"/>
                </svg>
                Back to Tax List
            </a>
            <div>
                <button type="button" class="refresh-btn" onclick="resetForm()">
                    <svg class="icon" viewBox="0 0 24 24">
                        <path d="M17.65 6.35C16.2 4.9 14.21 4 12 4c-4.42 0-7.99 3.58-7.99 8s3.57 8 7.99 8c3.73 0 6.84-2.55 7.73-6h-2.08c-.82 2.33-3.04 4-5.65 4-3.31 0-6-2.69-6-6s2.69-6 6-6c1.66 0 3.14.69 4.22 1.78L13 11h7V4l-2.35 2.35z"/>
                    </svg>
                    Refresh
                </button>
                <button type="submit" class="submit-btn">
                    <svg class="icon" viewBox="0 0 24 24">
                        <path d="M17 3H5c-1.11 0-2 .9-2 2v14c0 1.1.89 2 2 2h14c1.1 0 2-.9 2-2V7l-4-4zm-5 16c-1.66 0-3-1.34-3-3s1.34-3 3-3 3 1.34 3 3-1.34 3-3 3zm3-10H5V5h10v4z"/>
                    </svg>
                    Save Tax
                </button>
            </div>
        </div>
    </form>
</div>

<script>
    function resetForm() {
        document.getElementById('taxForm').reset();
        // Reset Tax Rate requirement on reset
        taxRateInput.required = true;
    }

    const taxTypeSelect = document.getElementById('tax_type');
    const taxRateInput = document.getElementById('tax_rate');

    // Function to toggle tax rate based on tax type
    function toggleTaxRateRequirement() {
        const taxType = taxTypeSelect.value;
        if (taxType === 'fixed') {
            taxRateInput.value = '';
            taxRateInput.required = false;
            taxRateInput.disabled = true;
        } else if (taxType === 'percentage') {
            taxRateInput.required = true;
            taxRateInput.disabled = false;
        } else {
            taxRateInput.required = true;
            taxRateInput.disabled = false;
        }
    }

    taxTypeSelect.addEventListener('change', toggleTaxRateRequirement);

    // Initialize on page load
    document.addEventListener('DOMContentLoaded', function() {
        toggleTaxRateRequirement();
    });

    document.getElementById('taxForm').addEventListener('submit', function(e) {
        const submitBtn = document.querySelector('.submit-btn');
        submitBtn.disabled = true;
        submitBtn.innerHTML = `
            <svg class="icon" viewBox="0 0 24 24">
                <path d="M12 4V2A10 10 0 0 0 2 12h2a8 8 0 0 1 8-8z"/>
            </svg>
            Saving...
        `;
    });
</script>

@endsection
