@extends('layouts.master')

@section('title', 'Add Case Category - Prolex Law Firm')

@section('content')
<style>
    .container {
        max-width: 600px;
        margin: 40px auto;
        background-color: #f8fafc;
        padding: 30px;
        border-radius: 12px;
        box-shadow: 0 4px 6px rgba(0,0,0,0.1);
    }

    h1 {
        text-align: center;
        color: #1e40af;
        margin-bottom: 30px;
        font-size: 2rem;
        font-weight: 700;
    }

    .form-group {
        margin-bottom: 20px;
    }

    label {
        display: block;
        margin-bottom: 8px;
        font-weight: 600;
        color: #374151;
    }

    input[type="text"] {
        width: 100%;
        padding: 12px 15px;
        border: 2px solid #e2e8f0;
        border-radius: 8px;
        font-size: 1rem;
        transition: border-color 0.3s ease;
    }

    input[type="text"]:focus {
        outline: none;
        border-color: #3b82f6;
        box-shadow: 0 0 0 3px rgba(59, 130, 246, 0.1);
    }

    .error {
        color: #ef4444;
        font-size: 0.875rem;
        margin-top: 5px;
    }

    .btn-container {
        display: flex;
        gap: 15px;
        justify-content: center;
        margin-top: 30px;
    }

    .btn {
        padding: 12px 24px;
        border: none;
        border-radius: 8px;
        font-size: 1rem;
        font-weight: 600;
        cursor: pointer;
        text-decoration: none;
        display: inline-block;
        transition: all 0.3s ease;
    }

    .btn-primary {
        background: linear-gradient(135deg, #3b82f6, #1d4ed8);
        color: white;
    }

    .btn-primary:hover {
        transform: translateY(-2px);
        box-shadow: 0 6px 12px rgba(59, 130, 246, 0.4);
    }

    .btn-secondary {
        background-color: #6b7280;
        color: white;
    }

    .btn-secondary:hover {
        background-color: #4b5563;
        transform: translateY(-2px);
    }
</style>

<div class="container">
    <h1>Add Case Category</h1>

    <form action="{{ route('modules.edit.case-categories.store') }}" method="POST">
        @csrf

        <div class="form-group">
            <label for="category_code">Category Code</label>
            <input
                type="text"
                id="category_code"
                name="category_code"
                value="{{ old('category_code') }}"
                required
                placeholder="Enter category code"
            />
            @error('category_code')
                <div class="error">{{ $message }}</div>
            @enderror
        </div>

        <div class="form-group">
            <label for="category_description">Category Description</label>
            <input
                type="text"
                id="category_description"
                name="category_description"
                value="{{ old('category_description') }}"
                required
                placeholder="Enter category description"
            />
            @error('category_description')
                <div class="error">{{ $message }}</div>
            @enderror
        </div>

        <div class="btn-container">
            <button type="submit" class="btn btn-primary">Save Case Category</button>
            <a href="{{ route('modules.edit.case-categories') }}" class="btn btn-secondary">Cancel</a>
        </div>
    </form>
</div>
@endsection
