@extends('layouts.master')

@section('title', 'Cases - Prolex Law Firm')

@section('content')
<style>
    .container {
        max-width: 1200px;
        margin: 40px auto;
        background-color: #f8fafc;
        padding: 30px;
        border-radius: 12px;
        box-shadow: 0 4px 6px rgba(0,0,0,0.1);
    }

    h1 {
        text-align: center;
        color: #1e40af;
        margin-bottom: 30px;
        font-size: 2.5rem;
        font-weight: 700;
    }

    .actions {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-bottom: 20px;
    }

    .add-btn {
        background: linear-gradient(135deg, #3b82f6, #1d4ed8);
        color: white;
        padding: 12px 24px;
        border: none;
        border-radius: 8px;
        font-size: 1rem;
        font-weight: 600;
        cursor: pointer;
        transition: all 0.3s ease;
        text-decoration: none;
        display: inline-block;
    }

    .add-btn:hover {
        transform: translateY(-2px);
        box-shadow: 0 6px 12px rgba(59, 130, 246, 0.4);
    }

    .search-container {
        display: flex;
        align-items: center;
        gap: 10px;
    }

    #searchInput {
        padding: 10px 15px;
        border: 2px solid #e2e8f0;
        border-radius: 6px;
        font-size: 1rem;
        width: 300px;
    }

    #searchInput:focus {
        outline: none;
        border-color: #3b82f6;
        box-shadow: 0 0 0 3px rgba(59, 130, 246, 0.1);
    }

    .table-container {
        background: white;
        border-radius: 8px;
        overflow: hidden;
        box-shadow: 0 2px 4px rgba(0,0,0,0.05);
    }

    table {
        width: 100%;
        border-collapse: collapse;
    }

    th, td {
        padding: 15px;
        text-align: left;
        border-bottom: 1px solid #e2e8f0;
    }

    th {
        background-color: #f8fafc;
        font-weight: 600;
        color: #374151;
        font-size: 0.95rem;
    }

    td {
        color: #4b5563;
        font-size: 0.9rem;
    }

    tr:hover {
        background-color: #f9fafb;
    }

    .action-btn {
        padding: 6px 12px;
        border: none;
        border-radius: 4px;
        font-size: 0.85rem;
        font-weight: 500;
        cursor: pointer;
        text-decoration: none;
        display: inline-block;
        margin-right: 5px;
    }

    .edit-btn {
        background-color: #f59e0b;
        color: white;
    }

    .edit-btn:hover {
        background-color: #d97706;
    }

    .delete-btn {
        background-color: #ef4444;
        color: white;
    }

    .delete-btn:hover {
        background-color: #dc2626;
    }

    .view-btn {
        background-color: #10b981;
        color: white;
    }

    .view-btn:hover {
        background-color: #059669;
    }

    .no-cases {
        text-align: center;
        padding: 40px;
        color: #6b7280;
        font-size: 1.1rem;
    }

    .status-badge {
        padding: 4px 8px;
        border-radius: 12px;
        font-size: 0.8rem;
        font-weight: 500;
        text-transform: uppercase;
    }

    .status-ongoing {
        background-color: #fef3c7;
        color: #d97706;
    }

    .status-settled {
        background-color: #d1fae5;
        color: #059669;
    }
</style>

<div class="container">
    <h1>Cases</h1>

    <div class="actions">
        <a href="{{ route('modules.edit.add-case') }}" class="add-btn">Add New Case</a>
        <div class="search-container">
            <input type="text" id="searchInput" placeholder="Search cases...">
        </div>
    </div>

    <div class="table-container">
        <table id="casesTable">
            <thead>
                <tr>
                    <th>Case ID</th>
                    <th>Client Name</th>
                    <th>Case Type</th>
                    <th>Case Category</th>
                    <th>Case Reason</th>
                    <th>Case Status</th>
                    <th>Lawyer</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                @forelse($cases as $case)
                <tr>
                    <td>{{ $case->case_code }}</td>
                    <td>{{ $case->client ? $case->client->full_name : 'N/A' }}</td>
                    <td>{{ $case->type }}</td>
                    <td>{{ $case->caseCategory ? $case->caseCategory->category_description : 'N/A' }}</td>
                    <td>{{ $case->caseReason ? $case->caseReason->reason_code . ' - ' . $case->caseReason->reason_name : 'N/A' }}</td>
                    <td>
                        @if($case->caseStatus)
                            <span class="status-badge" style="background-color: {{ $case->caseStatus->color_code }}20; color: {{ $case->caseStatus->color_code }};">
                                {{ $case->caseStatus->status_code }} - {{ $case->caseStatus->status_name }}
                            </span>
                        @else
                            <span class="status-badge">N/A</span>
                        @endif
                    </td>
                    <td>{{ $case->lawyer ? $case->lawyer->full_name : 'N/A' }}</td>
                    <td>
                        <a href="{{ route('case.show', $case->id) }}" class="action-btn view-btn">View</a>
                        <a href="{{ route('case.edit', $case->id) }}" class="action-btn edit-btn">Edit</a>
                        <form action="{{ route('case.destroy', $case->id) }}" method="POST" style="display: inline;">
                            @csrf
                            @method('DELETE')
                            <button type="submit" class="action-btn delete-btn" onclick="return confirm('Are you sure you want to delete this case?')">Delete</button>
                        </form>
                    </td>
                </tr>
                @empty
                <tr>
                    <td colspan="8" class="no-cases">No cases found.</td>
                </tr>
                @endforelse
            </tbody>
        </table>
    </div>
</div>

<script>
    // Search functionality
    document.getElementById('searchInput').addEventListener('input', function() {
        const searchTerm = this.value.toLowerCase();
        const rows = document.querySelectorAll('#casesTable tbody tr');

        rows.forEach(row => {
            if (row.cells.length > 1) { // Skip the "no cases" row
                const text = row.textContent.toLowerCase();
                row.style.display = text.includes(searchTerm) ? '' : 'none';
            }
        });
    });
</script>
@endsection

