@extends('layouts.master')

@section('title', 'Case Outcomes List - Prolex Law Firm')

@section('content')
<style>
    .container {
        max-width: 1200px;
        margin: 40px auto;
        background-color: #ffffff;
        padding: 20px 30px 30px;
        border-radius: 10px;
        box-shadow: 0 4px 6px rgba(0,0,0,0.1);
        animation: fadeInUp 0.6s ease forwards;
        opacity: 0;
        transform: translateY(20px);
    }

    @keyframes fadeInUp {
        to {
            opacity: 1;
            transform: translateY(0);
        }
    }

    h1 {
        text-align: center;
        color: #1e40af;
        margin-bottom: 25px;
        user-select: none;
    }

    .add-btn {
        background-color: #10b981;
        color: white;
        padding: 10px 20px;
        border: none;
        border-radius: 5px;
        font-size: 1em;
        font-weight: 600;
        text-decoration: none;
        cursor: pointer;
        transition: background-color 0.3s ease;
        display: inline-block;
        margin-bottom: 20px;
    }

    .add-btn:hover {
        background-color: #059669;
    }

    .search-container {
        margin-bottom: 20px;
        text-align: center;
    }

    #searchInput {
        width: 100%;
        max-width: 400px;
        padding: 10px 15px;
        font-size: 1em;
        border: 2px solid #3b82f6;
        border-radius: 8px;
        transition: border-color 0.3s ease;
    }

    #searchInput:focus {
        outline: none;
        border-color: #2563eb;
        box-shadow: 0 0 8px rgba(37, 99, 235, 0.5);
    }

    table {
        width: 100%;
        border-collapse: collapse;
        margin-top: 20px;
        background-color: #f9fafb;
        border-radius: 8px;
        overflow: hidden;
        box-shadow: 0 2px 4px rgba(0,0,0,0.1);
    }

    th, td {
        padding: 12px 15px;
        text-align: left;
        border-bottom: 1px solid #e5e7eb;
    }

    th {
        background-color: #3b82f6;
        color: white;
        font-weight: 600;
    }

    tr:hover {
        background-color: #f3f4f6;
    }

    .action-btn {
        padding: 6px 12px;
        border: none;
        border-radius: 4px;
        font-size: 0.9em;
        font-weight: 500;
        text-decoration: none;
        cursor: pointer;
        transition: background-color 0.3s ease;
        margin-right: 5px;
    }

    .view-btn {
        background-color: #3b82f6;
        color: white;
    }

    .view-btn:hover {
        background-color: #2563eb;
    }

    .edit-btn {
        background-color: #f59e0b;
        color: white;
    }

    .edit-btn:hover {
        background-color: #d97706;
    }

    .delete-btn {
        background-color: #ef4444;
        color: white;
    }

    .delete-btn:hover {
        background-color: #dc2626;
    }

    .back-btn {
        background-color: #6b7280;
        color: white;
        padding: 10px 20px;
        border: none;
        border-radius: 5px;
        font-size: 1em;
        font-weight: 600;
        text-decoration: none;
        cursor: pointer;
        transition: background-color 0.3s ease;
        display: inline-block;
        margin-bottom: 20px;
    }

    .back-btn:hover {
        background-color: #4b5563;
    }

    .no-data {
        text-align: center;
        padding: 40px;
        color: #6b7280;
        font-size: 1.1rem;
    }
</style>

<div class="container">
    <a href="{{ route('modules.edit.case') }}" class="back-btn">← Back to Cases</a>
    <h1>Case Outcomes</h1>

    <a href="{{ route('modules.edit.case-outcomes.add') }}" class="add-btn">+ Add New Case Outcome</a>

    <div class="search-container">
        <input type="text" id="searchInput" placeholder="Search case outcomes..." autocomplete="off">
    </div>

    <table id="outcomesTable">
        <thead>
            <tr>
                <th>Code</th>
                <th>Name</th>
                <th>Description</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            @forelse($caseOutcomes as $outcome)
            <tr>
                <td>{{ $outcome->code }}</td>
                <td>{{ $outcome->name }}</td>
                <td>{{ $outcome->description ?: 'No description' }}</td>
                <td>
                    <a href="{{ route('modules.edit.case-outcomes.show', $outcome->id) }}" class="action-btn view-btn">View</a>
                    <a href="{{ route('modules.edit.case-outcomes.edit', $outcome->id) }}" class="action-btn edit-btn">Edit</a>
                    <form action="{{ route('case-outcomes.destroy', $outcome->id) }}" method="POST" style="display: inline;">
                        @csrf
                        @method('DELETE')
                        <button type="submit" class="action-btn delete-btn" onclick="return confirm('Are you sure you want to delete this case outcome?')">Delete</button>
                    </form>
                </td>
            </tr>
            @empty
            <tr>
                <td colspan="4" class="no-data">
                    No case outcomes found. <a href="{{ route('modules.edit.case-outcomes.add') }}" class="add-btn" style="display: inline-block; margin-left: 10px;">Add your first case outcome</a>
                </td>
            </tr>
            @endforelse
        </tbody>
    </table>
</div>

<script>
    // Search functionality
    const searchInput = document.getElementById('searchInput');
    const table = document.getElementById('outcomesTable');
    const rows = table.querySelectorAll('tbody tr');

    searchInput.addEventListener('input', () => {
        const query = searchInput.value.toLowerCase().trim();
        rows.forEach(row => {
            const text = row.textContent.toLowerCase();
            row.style.display = text.includes(query) ? '' : 'none';
        });
    });
</script>
@endsection
