@extends('layouts.master')

@section('title', 'Case Outcome Details - Prolex Law Firm')

@section('content')
<style>
    .container {
        max-width: 800px;
        margin: 40px auto;
        background-color: #ffffff;
        padding: 20px 30px 30px;
        border-radius: 10px;
        box-shadow: 0 4px 6px rgba(0,0,0,0.1);
        animation: fadeInUp 0.6s ease forwards;
        opacity: 0;
        transform: translateY(20px);
    }

    @keyframes fadeInUp {
        to {
            opacity: 1;
            transform: translateY(0);
        }
    }

    h1 {
        text-align: center;
        color: #1e40af;
        margin-bottom: 25px;
        user-select: none;
    }

    .back-btn {
        background-color: #6b7280;
        color: white;
        padding: 10px 20px;
        border: none;
        border-radius: 5px;
        font-size: 1em;
        font-weight: 600;
        text-decoration: none;
        cursor: pointer;
        transition: background-color 0.3s ease;
        display: inline-block;
        margin-bottom: 20px;
    }

    .back-btn:hover {
        background-color: #4b5563;
    }

    .info-section {
        background-color: #f9fafb;
        padding: 20px;
        border-radius: 8px;
        margin-bottom: 20px;
        border-left: 4px solid #3b82f6;
    }

    .info-label {
        font-weight: 600;
        color: #374151;
        margin-bottom: 5px;
        display: block;
    }

    .info-value {
        color: #1f2937;
        font-size: 1.1em;
        margin-bottom: 15px;
    }

    .description-text {
        color: #4b5563;
        line-height: 1.6;
        white-space: pre-wrap;
    }

    .action-buttons {
        text-align: center;
        margin-top: 30px;
    }

    .action-btn {
        padding: 12px 25px;
        border: none;
        border-radius: 5px;
        font-size: 1em;
        font-weight: 600;
        text-decoration: none;
        cursor: pointer;
        transition: background-color 0.3s ease;
        margin: 0 10px;
        display: inline-block;
    }

    .edit-btn {
        background-color: #f59e0b;
        color: white;
    }

    .edit-btn:hover {
        background-color: #d97706;
    }

    .back-btn.action-btn {
        background-color: #6b7280;
        color: white;
    }

    .back-btn.action-btn:hover {
        background-color: #4b5563;
    }
</style>

<div class="container">
    <a href="{{ route('modules.edit.case-outcomes.list') }}" class="back-btn">← Back to Case Outcomes</a>
    <h1>Case Outcome Details</h1>

    <div class="info-section">
        <div class="info-label">Outcome Code</div>
        <div class="info-value">{{ $caseOutcome->code }}</div>

        <div class="info-label">Outcome Name</div>
        <div class="info-value">{{ $caseOutcome->name }}</div>

        <div class="info-label" style="margin-bottom: 10px;">Description</div>
        <div class="description-text">{{ $caseOutcome->description ?: 'No description provided.' }}</div>
    </div>

    <div class="action-buttons">
        <a href="{{ route('modules.edit.case-outcomes.edit', $caseOutcome->id) }}" class="action-btn edit-btn">Edit Case Outcome</a>
        <a href="{{ route('modules.edit.case-outcomes.list') }}" class="action-btn back-btn">Back to Case Outcomes</a>
    </div>
</div>
@endsection
