@extends('layouts.master')

@section('title', 'Add Case Party - Prolex Law Firm')

@section('content')
<style>
    .container {
        max-width: 800px;
        margin: 40px auto;
        background-color: #f0f9ff;
        padding: 30px;
        border-radius: 10px;
        box-shadow: 0 4px 6px rgba(0,0,0,0.1);
    }

    h1 {
        text-align: center;
        color: #1e40af;
        margin-bottom: 30px;
        user-select: none;
    }

    .form-group {
        margin-bottom: 20px;
    }

    label {
        display: block;
        margin-bottom: 5px;
        font-weight: 600;
        color: #374151;
    }

    input, select, textarea {
        width: 100%;
        padding: 10px 15px;
        border: 2px solid #3b82f6;
        border-radius: 8px;
        font-size: 1em;
        transition: border-color 0.3s ease;
    }

    input:focus, select:focus, textarea:focus {
        outline: none;
        border-color: #2563eb;
        box-shadow: 0 0 8px rgba(37, 99, 235, 0.5);
    }

    textarea {
        resize: vertical;
        min-height: 100px;
    }

    .form-row {
        display: flex;
        gap: 20px;
    }

    .form-row .form-group {
        flex: 1;
    }

    .btn {
        background-color: #3b82f6;
        color: white;
        padding: 12px 30px;
        border: none;
        border-radius: 8px;
        font-size: 1.1em;
        font-weight: 600;
        cursor: pointer;
        transition: background-color 0.3s ease;
        margin-right: 10px;
    }

    .btn:hover {
        background-color: #2563eb;
    }

    .btn-secondary {
        background-color: #6b7280;
    }

    .btn-secondary:hover {
        background-color: #4b5563;
    }

    .button-group {
        text-align: center;
        margin-top: 30px;
    }
</style>

<div class="container">
    <h1>Add Case Party</h1>

    <form action="{{ route('modules.edit.case-parties.store') }}" method="POST">
        @csrf

        <div class="form-row">
            <div class="form-group">
                <label for="case_id">Case *</label>
                <select name="case_id" id="case_id" required>
                    <option value="">Select a case</option>
                    @foreach($legalCases as $case)
                        <option value="{{ $case->case_id }}">{{ $case->case_title }} ({{ $case->case_number }})</option>
                    @endforeach
                </select>
            </div>

            <div class="form-group">
                <label for="party_type">Party Type *</label>
                <select name="party_type" id="party_type" required>
                    <option value="">Select party type</option>
                    <option value="individual">Individual</option>
                    <option value="company">Company</option>
                    <option value="organization">Organization</option>
                </select>
            </div>
        </div>

        <div class="form-group">
            <label for="party_name">Party Name *</label>
            <input type="text" name="party_name" id="party_name" required>
        </div>

        <div class="form-row">
            <div class="form-group">
                <label for="email">Email</label>
                <input type="email" name="email" id="email">
            </div>

            <div class="form-group">
                <label for="phone">Phone</label>
                <input type="text" name="phone" id="phone">
            </div>
        </div>

        <div class="form-group">
            <label for="contact_info">Contact Information</label>
            <textarea name="contact_info" id="contact_info" placeholder="Additional contact details"></textarea>
        </div>

        <div class="form-group">
            <label for="address">Address</label>
            <textarea name="address" id="address" placeholder="Full address"></textarea>
        </div>

        <div class="form-group">
            <label for="role_id">Role *</label>
            <select name="role_id" id="role_id" required>
                <option value="">Select a role</option>
                @foreach($caseRoles as $role)
                    <option value="{{ $role->role_id }}">{{ $role->role_name }}</option>
                @endforeach
            </select>
        </div>

        <div class="form-group">
            <label>
                <input type="checkbox" name="is_active" value="1" checked>
                Active
            </label>
        </div>

        <div class="button-group">
            <button type="submit" class="btn">Add Party</button>
            <a href="{{ route('modules.edit.case-parties') }}" class="btn btn-secondary">Cancel</a>
        </div>
    </form>
</div>
@endsection
