@extends('layouts.master')

@section('title', 'Case Parties List - Prolex Law Firm')

@section('content')
<style>
    .container {
        max-width: 1200px;
        margin: 40px auto;
        background-color: #f0f9ff;
        padding: 30px;
        border-radius: 10px;
        box-shadow: 0 4px 6px rgba(0,0,0,0.1);
    }

    h1 {
        text-align: center;
        color: #1e40af;
        margin-bottom: 30px;
        user-select: none;
    }

    .actions {
        margin-bottom: 20px;
        text-align: right;
    }

    .btn {
        background-color: #3b82f6;
        color: white;
        padding: 10px 20px;
        border: none;
        border-radius: 8px;
        font-size: 1em;
        font-weight: 600;
        cursor: pointer;
        text-decoration: none;
        display: inline-block;
        transition: background-color 0.3s ease;
        margin-left: 10px;
    }

    .btn:hover {
        background-color: #2563eb;
    }

    .btn-secondary {
        background-color: #6b7280;
    }

    .btn-secondary:hover {
        background-color: #4b5563;
    }

    .btn-danger {
        background-color: #dc2626;
    }

    .btn-danger:hover {
        background-color: #b91c1c;
    }

    table {
        width: 100%;
        border-collapse: collapse;
        margin-top: 20px;
        background-color: white;
        border-radius: 8px;
        overflow: hidden;
        box-shadow: 0 2px 4px rgba(0,0,0,0.1);
    }

    th, td {
        padding: 12px 15px;
        text-align: left;
        border-bottom: 1px solid #e5e7eb;
    }

    th {
        background-color: #3b82f6;
        color: white;
        font-weight: 600;
    }

    tr:hover {
        background-color: #f9fafb;
    }

    .status-active {
        color: #059669;
        font-weight: 600;
    }

    .status-inactive {
        color: #dc2626;
        font-weight: 600;
    }

    .no-data {
        text-align: center;
        padding: 40px;
        color: #6b7280;
        font-size: 1.1em;
    }
</style>

<div class="container">
    <h1>Case Parties List</h1>

    <div class="actions">
        <a href="{{ route('modules.edit.add-parties') }}" class="btn">Add New Party</a>
        <a href="{{ route('modules.edit.case-parties') }}" class="btn btn-secondary">Back to Menu</a>
    </div>

    @if($caseParties->count() > 0)
        <table>
            <thead>
                <tr>
                    <th>Party Name</th>
                    <th>Case</th>
                    <th>Role</th>
                    <th>Type</th>
                    <th>Contact</th>
                    <th>Status</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                @foreach($caseParties as $party)
                    <tr>
                        <td>{{ $party->party_name }}</td>
                        <td>{{ $party->legalCase ? $party->legalCase->case_title : 'N/A' }}</td>
                        <td>{{ $party->caseRole ? $party->caseRole->role_name : 'N/A' }}</td>
                        <td>{{ ucfirst($party->party_type) }}</td>
                        <td>
                            @if($party->email)
                                {{ $party->email }}<br>
                            @endif
                            @if($party->phone)
                                {{ $party->phone }}
                            @endif
                        </td>
                        <td>
                            <span class="status-{{ $party->is_active ? 'active' : 'inactive' }}">
                                {{ $party->is_active ? 'Active' : 'Inactive' }}
                            </span>
                        </td>
                        <td>
                            <a href="{{ route('modules.edit.edit-parties', $party->id) }}" class="btn btn-secondary">Edit</a>
                            <form action="{{ route('modules.edit.case-parties.destroy', $party->id) }}" method="POST" style="display: inline;">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="btn btn-danger" onclick="return confirm('Are you sure you want to delete this party?')">Delete</button>
                            </form>
                        </td>
                    </tr>
                @endforeach
            </tbody>
        </table>

        <div style="margin-top: 20px;">
            {{ $caseParties->links() }}
        </div>
    @else
        <div class="no-data">
            <p>No case parties found.</p>
            <a href="{{ route('modules.edit.add-parties') }}" class="btn">Add First Party</a>
        </div>
    @endif
</div>
@endsection
