@extends('layouts.master')

@section('title', 'Add Case Priority - Prolex Law Firm')

@section('content')
<style>
    .container {
        max-width: 800px;
        margin: 40px auto;
        background-color: #f8f9fa;
        padding: 30px;
        border-radius: 10px;
        box-shadow: 0 4px 6px rgba(0,0,0,0.1);
    }

    h1 {
        text-align: center;
        color: #1e40af;
        margin-bottom: 30px;
        font-size: 2.5rem;
        font-weight: 700;
    }

    .back-btn {
        display: inline-block;
        background-color: #6b7280;
        color: white;
        padding: 10px 20px;
        text-decoration: none;
        border-radius: 5px;
        margin-bottom: 20px;
        transition: background-color 0.3s ease;
    }

    .back-btn:hover {
        background-color: #4b5563;
    }

    .form-group {
        margin-bottom: 20px;
    }

    label {
        display: block;
        margin-bottom: 5px;
        font-weight: 600;
        color: #374151;
    }

    input[type="text"], textarea, select {
        width: 100%;
        padding: 12px;
        border: 1px solid #d1d5db;
        border-radius: 5px;
        font-size: 1rem;
        transition: border-color 0.3s ease;
    }

    input[type="text"]:focus, textarea:focus, select:focus {
        outline: none;
        border-color: #3b82f6;
        box-shadow: 0 0 0 3px rgba(59, 130, 246, 0.1);
    }

    textarea {
        resize: vertical;
        min-height: 100px;
    }

    .submit-btn {
        background-color: #10b981;
        color: white;
        padding: 12px 24px;
        border: none;
        border-radius: 5px;
        font-size: 1rem;
        font-weight: 600;
        cursor: pointer;
        transition: background-color 0.3s ease;
    }

    .submit-btn:hover {
        background-color: #059669;
    }

    .error-message {
        color: #ef4444;
        font-size: 0.875rem;
        margin-top: 5px;
    }
</style>

<div class="container">
    <a href="{{ route('modules.edit.case-priorities') }}" class="back-btn">← Back to Case Priorities</a>
    <h1>Add New Case Priority</h1>

    @if(session('success'))
        <div style="background-color: #d1fae5; color: #065f46; padding: 12px; border-radius: 5px; margin-bottom: 20px;">
            {{ session('success') }}
        </div>
    @endif

    @if($errors->any())
        <div style="background-color: #fee2e2; color: #991b1b; padding: 12px; border-radius: 5px; margin-bottom: 20px;">
            <ul style="margin: 0; padding-left: 20px;">
                @foreach($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    <form id="casePriorityForm" action="{{ route('case-priorities.store') }}" method="POST">
        @csrf
        <div class="form-group">
            <label for="priority_name">Priority Name *</label>
            <input type="text" id="priority_name" name="priority_name" value="{{ old('priority_name') }}" required>
            @error('priority_name')
                <div class="error-message">{{ $message }}</div>
            @enderror
        </div>

        <div class="form-group">
            <label for="description">Description</label>
            <textarea id="description" name="description">{{ old('description') }}</textarea>
            @error('description')
                <div class="error-message">{{ $message }}</div>
            @enderror
        </div>

        <div class="form-group">
            <label for="severity_rank">Severity Rank *</label>
            <select id="severity_rank" name="severity_rank" required>
                <option value="">Select Severity Rank</option>
                <option value="1" {{ old('severity_rank') == '1' ? 'selected' : '' }}>1 - Lowest</option>
                <option value="2" {{ old('severity_rank') == '2' ? 'selected' : '' }}>2</option>
                <option value="3" {{ old('severity_rank') == '3' ? 'selected' : '' }}>3</option>
                <option value="4" {{ old('severity_rank') == '4' ? 'selected' : '' }}>4</option>
                <option value="5" {{ old('severity_rank') == '5' ? 'selected' : '' }}>5</option>
                <option value="6" {{ old('severity_rank') == '6' ? 'selected' : '' }}>6 - Highest</option>
            </select>
            @error('severity_rank')
                <div class="error-message">{{ $message }}</div>
            @enderror
        </div>

        <button type="submit" class="submit-btn">Create Case Priority</button>
    </form>
</div>

<script>
    // Form validation
    document.getElementById('casePriorityForm').addEventListener('submit', function(e) {
        const priorityName = document.getElementById('priority_name').value.trim();
        const severityRank = document.getElementById('severity_rank').value;

        if (!priorityName) {
            e.preventDefault();
            alert('Please enter a priority name.');
            return false;
        }

        if (!severityRank) {
            e.preventDefault();
            alert('Please select a severity rank.');
            return false;
        }
    });
</script>
@endsection
