@extends('layouts.master')

@section('title', 'View Case Priority - Prolex Law Firm')

@section('content')
<style>
    .container {
        max-width: 1200px;
        margin: 40px auto;
        background-color: #f8fafc;
        padding: 30px;
        border-radius: 12px;
        box-shadow: 0 4px 6px rgba(0,0,0,0.1);
    }

    h1 {
        text-align: center;
        color: #1e40af;
        margin-bottom: 30px;
        font-size: 2.5rem;
        font-weight: 700;
    }

    .info-section {
        background: white;
        border-radius: 8px;
        padding: 25px;
        margin-bottom: 25px;
        border: 1px solid #e2e8f0;
        box-shadow: 0 2px 4px rgba(0,0,0,0.05);
    }

    .section-title {
        color: #2d3748;
        font-size: 1.5rem;
        font-weight: 600;
        margin-bottom: 20px;
        border-bottom: 2px solid #e2e8f0;
        padding-bottom: 10px;
    }

    .info-row {
        display: flex;
        margin-bottom: 15px;
    }

    .info-label {
        font-weight: 600;
        color: #4a5568;
        width: 200px;
        flex-shrink: 0;
    }

    .info-value {
        color: #2d3748;
        flex: 1;
    }

    .button-group {
        display: flex;
        justify-content: center;
        gap: 20px;
        margin-top: 30px;
    }

    .edit-btn, .back-btn {
        padding: 15px 40px;
        border: none;
        border-radius: 8px;
        font-size: 1.1rem;
        font-weight: 600;
        cursor: pointer;
        transition: all 0.3s ease;
        text-decoration: none;
        display: inline-block;
        box-shadow: 0 4px 6px rgba(59, 130, 246, 0.3);
    }

    .edit-btn {
        background: linear-gradient(135deg, #f59e0b, #d97706);
        color: white;
    }

    .back-btn {
        background: linear-gradient(135deg, #6b7280, #4b5563);
        color: white;
    }

    .edit-btn:hover, .back-btn:hover {
        transform: translateY(-2px);
        box-shadow: 0 6px 12px rgba(59, 130, 246, 0.4);
    }

    .edit-btn:active, .back-btn:active {
        transform: translateY(0);
    }
</style>

<div class="container">
    <h1>View Case Priority</h1>

    <div class="info-section">
        <div class="section-title">Case Priority Information</div>

        <div class="info-row">
            <div class="info-label">Priority ID:</div>
            <div class="info-value">{{ $casePriority->priority_id }}</div>
        </div>

        <div class="info-row">
            <div class="info-label">Priority Name:</div>
            <div class="info-value">{{ $casePriority->priority_name }}</div>
        </div>

        <div class="info-row">
            <div class="info-label">Description:</div>
            <div class="info-value">{{ $casePriority->description ?? 'N/A' }}</div>
        </div>

        <div class="info-row">
            <div class="info-label">Severity Rank:</div>
            <div class="info-value">{{ $casePriority->severity_rank }}</div>
        </div>

        <div class="info-row">
            <div class="info-label">Created At:</div>
            <div class="info-value">{{ $casePriority->created_at->format('Y-m-d H:i:s') }}</div>
        </div>

        <div class="info-row">
            <div class="info-label">Updated At:</div>
            <div class="info-value">{{ $casePriority->updated_at->format('Y-m-d H:i:s') }}</div>
        </div>
    </div>

    <div class="button-group">
        <a href="{{ route('modules.edit.case-priorities.edit', $casePriority->priority_id) }}" class="edit-btn">Edit</a>
        <a href="{{ route('modules.edit.case-priorities') }}" class="back-btn">Back to Case Priorities</a>
    </div>
</div>

@endsection
