@extends('layouts.master')

@section('title', 'Cancelled Reasons List - Prolex Law Firm')

@section('content')
<style>
    .container {
        max-width: 1200px;
        margin: 40px auto;
        background-color: #f8fafc;
        padding: 30px;
        border-radius: 12px;
        box-shadow: 0 4px 6px rgba(0,0,0,0.1);
    }

    h1 {
        text-align: center;
        color: #1e40af;
        margin-bottom: 30px;
        font-size: 2.5rem;
        font-weight: 700;
    }

    .actions {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-bottom: 20px;
    }

    .add-btn {
        background: linear-gradient(135deg, #3b82f6, #1d4ed8);
        color: white;
        padding: 12px 24px;
        border: none;
        border-radius: 8px;
        font-size: 1rem;
        font-weight: 600;
        cursor: pointer;
        transition: all 0.3s ease;
        text-decoration: none;
        display: inline-block;
    }

    .add-btn:hover {
        transform: translateY(-2px);
        box-shadow: 0 6px 12px rgba(59, 130, 246, 0.4);
    }

    .search-container {
        display: flex;
        align-items: center;
        gap: 10px;
    }

    #searchInput {
        padding: 10px 15px;
        border: 2px solid #e2e8f0;
        border-radius: 6px;
        font-size: 1rem;
        width: 300px;
    }

    #searchInput:focus {
        outline: none;
        border-color: #3b82f6;
        box-shadow: 0 0 0 3px rgba(59, 130, 246, 0.1);
    }

    .table-container {
        background: white;
        border-radius: 8px;
        overflow: hidden;
        box-shadow: 0 2px 4px rgba(0,0,0,0.05);
    }

    table {
        width: 100%;
        border-collapse: collapse;
    }

    th, td {
        padding: 15px;
        text-align: left;
        border-bottom: 1px solid #e2e8f0;
    }

    th {
        background-color: #f8fafc;
        font-weight: 600;
        color: #374151;
        font-size: 0.95rem;
    }

    td {
        color: #4b5563;
        font-size: 0.9rem;
    }

    tr:hover {
        background-color: #f9fafb;
    }

    .action-btn {
        padding: 6px 12px;
        border: none;
        border-radius: 4px;
        font-size: 0.85rem;
        font-weight: 500;
        cursor: pointer;
        text-decoration: none;
        display: inline-block;
        margin-right: 5px;
    }

    .edit-btn {
        background-color: #f59e0b;
        color: white;
    }

    .edit-btn:hover {
        background-color: #d97706;
    }

    .delete-btn {
        background-color: #ef4444;
        color: white;
    }

    .delete-btn:hover {
        background-color: #dc2626;
    }

    .view-btn {
        background-color: #10b981;
        color: white;
    }

    .view-btn:hover {
        background-color: #059669;
    }

    .status-badge {
        padding: 4px 8px;
        border-radius: 12px;
        font-size: 0.8rem;
        font-weight: 500;
        text-transform: uppercase;
    }

    .status-active {
        background-color: #d1fae5;
        color: #059669;
    }

    .status-inactive {
        background-color: #fee2e2;
        color: #dc2626;
    }

    .priority-badge {
        padding: 4px 8px;
        border-radius: 12px;
        font-size: 0.8rem;
        font-weight: 500;
        text-transform: uppercase;
    }

    .priority-low {
        background-color: #e0f2fe;
        color: #0369a1;
    }

    .priority-medium {
        background-color: #fef3c7;
        color: #d97706;
    }

    .priority-high {
        background-color: #fee2e2;
        color: #dc2626;
    }

    .back-btn {
        background: #6b7280;
        color: white;
        padding: 12px 24px;
        border: none;
        border-radius: 8px;
        font-size: 1rem;
        font-weight: 600;
        cursor: pointer;
        transition: all 0.3s ease;
        text-decoration: none;
        display: inline-block;
        margin-bottom: 20px;
    }

    .back-btn:hover {
        background: #4b5563;
        transform: translateY(-1px);
    }
</style>

<div class="container">
    <a href="{{ route('modules.edit.case') }}" class="back-btn">← Back to Cases</a>
    <h1>Cancelled Reasons</h1>

    <div class="actions">
        <a href="{{ route('modules.edit.case-reasons.add') }}" class="add-btn">+ Add New Cancelled Reason</a>
        <div class="search-container">
            <input type="text" id="searchInput" placeholder="Search cancelled reasons...">
        </div>
    </div>

    <div class="table-container">
        <table id="caseReasonsTable">
            <thead>
                <tr>
                    <th>Reason Code</th>
                    <th>Reason Name</th>
                    <th>Description</th>
                    <th>Status</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                @forelse($caseReasons as $reason)
                <tr>
                    <td>{{ $reason->reason_code }}</td>
                    <td>{{ $reason->reason_name }}</td>
                    <td>{{ Str::limit($reason->reason_description, 50) }}</td>
                    <td>
                        <span class="status-badge {{ $reason->status ? 'status-active' : 'status-inactive' }}">
                            {{ $reason->status ? 'Active' : 'Inactive' }}
                        </span>
                    </td>
                    <td>
                        <a href="{{ route('modules.edit.case-reasons.show', $reason->reason_code) }}" class="action-btn view-btn">View</a>
                        <a href="{{ route('modules.edit.case-reasons.edit', $reason->reason_code) }}" class="action-btn edit-btn">Edit</a>
                        <form action="{{ route('case-reasons.destroy', $reason->reason_code) }}" method="POST" style="display: inline;">
                            @csrf
                            @method('DELETE')
                            <button type="submit" class="action-btn delete-btn" onclick="return confirm('Are you sure you want to delete this cancelled reason?')">Delete</button>
                        </form>
                    </td>
                </tr>
                @empty
                <tr>
                    <td colspan="5" style="text-align: center; padding: 40px; color: #6b7280; font-size: 1.1rem;">
                        No cancelled reasons found. <a href="{{ route('modules.edit.case-reasons.add') }}" class="add-btn" style="display: inline-block; margin-left: 10px;">Add your first cancelled reason</a>
                    </td>
                </tr>
                @endforelse
            </tbody>
        </table>
    </div>

    <!-- Pagination -->
    <div class="pagination-container" style="margin-top: 30px; text-align: center;">
        {{ $caseReasons->links() }}
    </div>
</div>

<script>
    // Search functionality
    document.getElementById('searchInput').addEventListener('input', function() {
        const searchTerm = this.value.toLowerCase();
        const rows = document.querySelectorAll('#caseReasonsTable tbody tr');

        rows.forEach(row => {
            if (row.cells.length > 1) { // Skip the "no data" row
                const text = row.textContent.toLowerCase();
                row.style.display = text.includes(searchTerm) ? '' : 'none';
            }
        });
    });
</script>
@endsection

