@extends('layouts.master')

@section('title', 'View Cancelled Reason - Prolex Law Firm')

@section('content')
<style>
    .container {
        max-width: 900px;
        margin: 40px auto;
        background-color: #f8fafc;
        padding: 30px;
        border-radius: 12px;
        box-shadow: 0 4px 6px rgba(0,0,0,0.1);
    }

    h1 {
        text-align: center;
        color: #1e40af;
        margin-bottom: 30px;
        font-size: 2.5rem;
        font-weight: 700;
    }

    .info-section {
        background: white;
        border-radius: 8px;
        padding: 25px;
        margin-bottom: 25px;
        border: 1px solid #e2e8f0;
        box-shadow: 0 2px 4px rgba(0,0,0,0.05);
    }

    .section-title {
        color: #2d3748;
        font-size: 1.5rem;
        font-weight: 600;
        margin-bottom: 20px;
        border-bottom: 2px solid #e2e8f0;
        padding-bottom: 10px;
    }

    .info-grid {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
        gap: 20px;
        margin-bottom: 20px;
    }

    .info-item {
        padding: 15px;
        background-color: #f8fafc;
        border-radius: 6px;
        border-left: 4px solid #3b82f6;
    }

    .info-label {
        font-weight: 600;
        color: #4a5568;
        font-size: 0.9rem;
        margin-bottom: 5px;
        text-transform: uppercase;
        letter-spacing: 0.5px;
    }

    .info-value {
        color: #2d3748;
        font-size: 1rem;
        font-weight: 500;
    }

    .description-box {
        background-color: #f8fafc;
        border-radius: 6px;
        padding: 20px;
        border-left: 4px solid #10b981;
        margin-top: 15px;
    }

    .description-text {
        color: #2d3748;
        font-size: 1rem;
        line-height: 1.6;
        white-space: pre-wrap;
    }

    .status-badge {
        padding: 6px 12px;
        border-radius: 20px;
        font-size: 0.85rem;
        font-weight: 600;
        text-transform: uppercase;
        display: inline-block;
    }

    .status-active {
        background-color: #d1fae5;
        color: #059669; 
    }

    .status-inactive {
        background-color: #fee2e2;
        color: #dc2626;
    }

    .priority-badge {
        padding: 6px 12px;
        border-radius: 20px;
        font-size: 0.85rem;
        font-weight: 600;
        text-transform: uppercase;
        display: inline-block;
    }

    .priority-low {
        background-color: #e0f2fe;
        color: #0369a1;
    }

    .priority-medium {
        background-color: #fef3c7;
        color: #d97706;
    }

    .priority-high {
        background-color: #fee2e2;
        color: #dc2626;
    }

    .priority-urgent {
        background-color: #fce7f3;
        color: #be185d;
    }

    .approval-badge {
        padding: 6px 12px;
        border-radius: 20px;
        font-size: 0.85rem;
        font-weight: 600;
        text-transform: uppercase;
        display: inline-block;
    }

    .approval-yes {
        background-color: #fee2e2;
        color: #dc2626;
    }

    .approval-no {
        background-color: #d1fae5;
        color: #059669;
    }

    .action-buttons {
        text-align: center;
        margin-top: 30px;
        padding-top: 20px;
        border-top: 1px solid #e2e8f0;
    }

    .action-btn {
        padding: 12px 24px;
        border: none;
        border-radius: 8px;
        font-size: 1rem;
        font-weight: 600;
        cursor: pointer;
        text-decoration: none;
        display: inline-block;
        margin: 0 10px;
        transition: all 0.3s ease;
    }

    .edit-btn {
        background-color: #f59e0b;
        color: white;
    }

    .edit-btn:hover {
        background-color: #d97706;
        transform: translateY(-2px);
    }

    .back-btn {
        background-color: #6b7280;
        color: white;
    }

    .back-btn:hover {
        background-color: #4b5563;
        transform: translateY(-2px);
    }

    .usage-info {
        background-color: #eff6ff;
        border: 1px solid #3b82f6;
        border-radius: 6px;
        padding: 20px;
        margin-top: 20px;
    }

    .usage-info h3 {
        color: #1e40af;
        margin-bottom: 15px;
        font-size: 1.2rem;
    }

    .usage-stats {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(150px, 1fr));
        gap: 15px;
    }

    .stat-item {
        text-align: center;
        padding: 15px;
        background-color: white;
        border-radius: 6px;
        border: 1px solid #e2e8f0;
    }

    .stat-number {
        font-size: 2rem;
        font-weight: 700;
        color: #1e40af;
        display: block;
    }

    .stat-label {
        font-size: 0.9rem;
        color: #6b7280;
        margin-top: 5px;
    }
</style>

<div class="container">
    <a href="{{ route('modules.edit.case-reasons.list') }}" class="back-btn action-btn">← Back to Cancelled Reasons</a>
    <h1>Cancelled Reason Details</h1>

    <div class="info-section">
        <h2 class="section-title">Basic Information</h2>

        <div class="info-grid">
            <div class="info-item">
                <div class="info-label">Reason Code</div>
                <div class="info-value">{{ $caseReason->reason_code }}</div>
            </div>

            <div class="info-item">
                <div class="info-label">Reason Name</div>
                <div class="info-value">{{ $caseReason->reason_name }}</div>
            </div>

            <div class="info-item">
                <div class="info-label">Status</div>
                <div class="info-value">
                    <span class="status-badge {{ $caseReason->status ? 'status-active' : 'status-inactive' }}">
                        {{ $caseReason->status ? 'Active' : 'Inactive' }}
                    </span>
                </div>
            </div>

            <div class="info-item">
                <div class="info-label">Created</div>
                <div class="info-value">{{ $caseReason->created_at->format('M d, Y H:i') }}</div>
            </div>
        </div>

        <div class="description-box">
            <div class="info-label" style="margin-bottom: 10px;">Description</div>
            <div class="description-text">{{ $caseReason->reason_description ?: 'No description provided.' }}</div>
        </div>
    </div>

    <div class="info-section">
        <h2 class="section-title">Usage Information</h2>

        <div class="usage-info">
            <h3>Statistics</h3>
            <div class="usage-stats">
                <div class="stat-item">
                    <span class="stat-number">{{ $caseReason->legalCases->count() }}</span>
                    <div class="stat-label">Cases Using This Reason</div>
                </div>

                <div class="stat-item">
                    <span class="stat-number">{{ $caseReason->updated_at->diffForHumans() }}</span>
                    <div class="stat-label">Last Updated</div>
                </div>
            </div>
        </div>
    </div>

    <div class="action-buttons">
        <a href="{{ route('modules.edit.case-reasons.edit', $caseReason->reason_code) }}" class="action-btn edit-btn">Edit Cancelled Reason</a>
        <a href="{{ route('modules.edit.case-reasons.list') }}" class="action-btn back-btn">Back to Cancelled Reasons</a>
    </div>
</div>
@endsection

