@extends('layouts.master')

@section('title', 'Case Roles - Prolex Law Firm')

@section('content')
<style>
    .container {
        max-width: 1200px;
        margin: 40px auto;
        background-color: #f8f9fa;
        padding: 30px;
        border-radius: 10px;
        box-shadow: 0 4px 6px rgba(0,0,0,0.1);
    }

    h1 {
        text-align: center;
        color: #1e40af;
        margin-bottom: 30px;
        font-size: 2.5rem;
        font-weight: 700;
    }

    .back-btn {
        display: inline-block;
        background-color: #6b7280;
        color: white;
        padding: 10px 20px;
        text-decoration: none;
        border-radius: 5px;
        margin-bottom: 20px;
        transition: background-color 0.3s ease;
    }

    .back-btn:hover {
        background-color: #4b5563;
    }

    .add-btn {
        display: inline-block;
        background-color: #10b981;
        color: white;
        padding: 10px 20px;
        text-decoration: none;
        border-radius: 5px;
        margin-bottom: 20px;
        transition: background-color 0.3s ease;
    }

    .add-btn:hover {
        background-color: #059669;
    }

    .search-container {
        margin-bottom: 20px;
        display: flex;
        justify-content: space-between;
        align-items: center;
    }

    .search-container input {
        padding: 8px 12px;
        border: 1px solid #d1d5db;
        border-radius: 5px;
        width: 300px;
    }

    table {
        width: 100%;
        border-collapse: collapse;
        background-color: white;
        border-radius: 8px;
        overflow: hidden;
        box-shadow: 0 2px 4px rgba(0,0,0,0.1);
    }

    th, td {
        padding: 12px 15px;
        text-align: left;
        border-bottom: 1px solid #e5e7eb;
    }

    th {
        background-color: #f3f4f6;
        font-weight: 600;
        color: #374151;
    }

    tr:hover {
        background-color: #f9fafb;
    }

    .action-btn {
        padding: 6px 12px;
        text-decoration: none;
        border-radius: 4px;
        font-size: 0.875rem;
        margin-right: 5px;
        display: inline-block;
    }

    .view-btn {
        background-color: #3b82f6;
        color: white;
    }

    .view-btn:hover {
        background-color: #2563eb;
    }

    .edit-btn {
        background-color: #f59e0b;
        color: white;
    }

    .edit-btn:hover {
        background-color: #d97706;
    }

    .delete-btn {
        background-color: #ef4444;
        color: white;
    }

    .delete-btn:hover {
        background-color: #dc2626;
    }

    .no-data {
        text-align: center;
        padding: 40px;
        color: #6b7280;
        font-size: 1.1rem;
    }
</style>

<div class="container">
    <a href="{{ route('modules.edit.case-roles') }}" class="back-btn">← Back to Case Roles</a>
    <h1>Case Roles</h1>
    <div class="actions">
        <a href="{{ route('modules.edit.case-roles.add') }}" class="add-btn">+ Add New Case Role</a>
        <div class="search-container">
            <input type="text" id="searchInput" placeholder="Search case roles...">
        </div>
    </div>

    <table id="caseRolesTable">
        <thead>
            <tr>
                <th>ID</th>
                <th>Role Name</th>
                <th>Description</th>
                <th>Status</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            @forelse($caseRoles as $caseRole)
                <tr>
                    <td>{{ $caseRole->role_id }}</td>
                    <td>{{ $caseRole->role_name }}</td>
                    <td>{{ $caseRole->description ?? 'N/A' }}</td>
                    <td>{{ $caseRole->is_active ? 'Active' : 'Inactive' }}</td>
                    <td>
                        <a href="{{ route('modules.edit.case-roles.show', $caseRole->role_id) }}" class="action-btn view-btn">View</a>
                        <a href="{{ route('modules.edit.case-roles.edit', $caseRole->role_id) }}" class="action-btn edit-btn">Edit</a>
                        <form action="{{ route('case-roles.destroy', $caseRole->role_id) }}" method="POST" style="display: inline;">
                            @csrf
                            @method('DELETE')
                            <button type="submit" class="action-btn delete-btn" onclick="return confirm('Are you sure you want to delete this case role?')">Delete</button>
                        </form>
                    </td>
                </tr>
            @empty
                <tr>
                    <td colspan="5" class="no-data">
                        No case roles found. <a href="{{ route('modules.edit.case-roles.add') }}" class="add-btn" style="display: inline-block; margin-left: 10px;">Add your first case role</a>
                    </td>
                </tr>
            @endforelse
        </tbody>
    </table>
</div>

<script>
    // Search functionality
    document.getElementById('searchInput').addEventListener('input', function() {
        const filter = this.value.toLowerCase();
        const rows = document.querySelectorAll('#caseRolesTable tbody tr');

        rows.forEach(row => {
            const text = row.textContent.toLowerCase();
            row.style.display = text.includes(filter) ? '' : 'none';
        });
    });
</script>
@endsection
