@extends('layouts.master')

@section('title', 'View Case Role - Prolex Law Firm')

@section('content')
<style>
    .container {
        max-width: 800px;
        margin: 40px auto;
        background-color: #f8f9fa;
        padding: 30px;
        border-radius: 10px;
        box-shadow: 0 4px 6px rgba(0,0,0,0.1);
    }

    h1 {
        text-align: center;
        color: #1e40af;
        margin-bottom: 30px;
        font-size: 2.5rem;
        font-weight: 700;
    }

    .back-btn {
        display: inline-block;
        background-color: #6b7280;
        color: white;
        padding: 10px 20px;
        text-decoration: none;
        border-radius: 5px;
        margin-bottom: 20px;
        transition: background-color 0.3s ease;
    }

    .back-btn:hover {
        background-color: #4b5563;
    }

    .edit-btn {
        display: inline-block;
        background-color: #f59e0b;
        color: white;
        padding: 10px 20px;
        text-decoration: none;
        border-radius: 5px;
        margin-bottom: 20px;
        transition: background-color 0.3s ease;
    }

    .edit-btn:hover {
        background-color: #d97706;
    }

    .detail-group {
        margin-bottom: 20px;
        padding: 15px;
        background-color: white;
        border-radius: 8px;
        box-shadow: 0 2px 4px rgba(0,0,0,0.1);
    }

    .detail-label {
        font-weight: 600;
        color: #374151;
        margin-bottom: 5px;
    }

    .detail-value {
        color: #6b7280;
        font-size: 1rem;
    }

    .status-active {
        color: #10b981;
        font-weight: 600;
    }

    .status-inactive {
        color: #ef4444;
        font-weight: 600;
    }
</style>

<div class="container">
    <a href="{{ route('modules.edit.case-roles.list') }}" class="back-btn">← Back to Case Roles List</a>
    <a href="{{ route('modules.edit.case-roles.edit', $caseRole->role_id) }}" class="edit-btn">Edit Role</a>
    <h1>Case Role Details</h1>

    <div class="detail-group">
        <div class="detail-label">Role ID</div>
        <div class="detail-value">{{ $caseRole->role_id }}</div>
    </div>

    <div class="detail-group">
        <div class="detail-label">Role Name</div>
        <div class="detail-value">{{ $caseRole->role_name }}</div>
    </div>

    <div class="detail-group">
        <div class="detail-label">Description</div>
        <div class="detail-value">{{ $caseRole->description ?? 'No description provided.' }}</div>
    </div>

    <div class="detail-group">
        <div class="detail-label">Status</div>
        <div class="detail-value">
            <span class="{{ $caseRole->is_active ? 'status-active' : 'status-inactive' }}">
                {{ $caseRole->is_active ? 'Active' : 'Inactive' }}
            </span>
        </div>
    </div>

    <div class="detail-group">
        <div class="detail-label">Created At</div>
        <div class="detail-value">{{ $caseRole->created_at->format('d M Y, H:i') }}</div>
    </div>

    <div class="detail-group">
        <div class="detail-label">Updated At</div>
        <div class="detail-value">{{ $caseRole->updated_at->format('d M Y, H:i') }}</div>
    </div>
</div>
@endsection
