@extends('layouts.master')

@section('title', 'Case Details - Prolex Law Firm')

@section('content')
<style>
    .container {
        max-width: 800px;
        margin: 40px auto;
        background-color: #f8fafc;
        padding: 30px;
        border-radius: 12px;
        box-shadow: 0 4px 6px rgba(0,0,0,0.1);
    }

    h1 {
        text-align: center;
        color: #1e40af;
        margin-bottom: 30px;
        font-size: 2.5rem;
        font-weight: 700;
    }

    .case-details {
        background: white;
        border-radius: 8px;
        padding: 25px;
        box-shadow: 0 2px 4px rgba(0,0,0,0.05);
    }

    .detail-row {
        display: flex;
        margin-bottom: 15px;
        padding: 10px 0;
        border-bottom: 1px solid #e2e8f0;
    }

    .detail-row:last-child {
        border-bottom: none;
        margin-bottom: 0;
    }

    .detail-label {
        font-weight: 600;
        color: #374151;
        width: 200px;
        flex-shrink: 0;
    }

    .detail-value {
        color: #4b5563;
        flex: 1;
    }

    .actions {
        margin-top: 30px;
        text-align: center;
    }

    .action-btn {
        padding: 12px 24px;
        border: none;
        border-radius: 8px;
        font-size: 1rem;
        font-weight: 600;
        cursor: pointer;
        text-decoration: none;
        display: inline-block;
        margin: 0 10px;
        transition: all 0.3s ease;
    }

    .edit-btn {
        background: linear-gradient(135deg, #f59e0b, #d97706);
        color: white;
    }

    .edit-btn:hover {
        transform: translateY(-2px);
        box-shadow: 0 6px 12px rgba(245, 158, 11, 0.4);
    }

    .back-btn {
        background: linear-gradient(135deg, #6b7280, #4b5563);
        color: white;
    }

    .back-btn:hover {
        transform: translateY(-2px);
        box-shadow: 0 6px 12px rgba(107, 114, 128, 0.4);
    }

    .status-badge {
        padding: 6px 12px;
        border-radius: 20px;
        font-size: 0.9rem;
        font-weight: 500;
        text-transform: uppercase;
        display: inline-block;
    }

    .status-ongoing {
        background-color: #fef3c7;
        color: #d97706;
    }

    .status-settled {
        background-color: #d1fae5;
        color: #059669;
    }
</style>

<div class="container">
    <h1>Case Details</h1>

    <div class="case-details">
        <div class="detail-row">
            <div class="detail-label">Case ID:</div>
            <div class="detail-value">{{ $case->case_code }}</div>
        </div>

        <div class="detail-row">
            <div class="detail-label">Client Name:</div>
            <div class="detail-value">{{ $case->client ? $case->client->full_name : 'N/A' }}</div>
        </div>

        <div class="detail-row">
            <div class="detail-label">Case Type:</div>
            <div class="detail-value">{{ $case->type }}</div>
        </div>

        <div class="detail-row">
            <div class="detail-label">Case Category:</div>
            <div class="detail-value">{{ $case->caseCategory ? $case->caseCategory->category_description : 'N/A' }}</div>
        </div>

        <div class="detail-row">
            <div class="detail-label">Assigned Lawyer:</div>
            <div class="detail-value">{{ $case->lawyer ? $case->lawyer->full_name : 'N/A' }}</div>
        </div>

        <div class="detail-row">
            <div class="detail-label">Status:</div>
            <div class="detail-value">
                <span class="status-badge status-{{ strtolower($case->status) }}">
                    {{ $case->status }}
                </span>
            </div>
        </div>

        <div class="detail-row">
            <div class="detail-label">Created At:</div>
            <div class="detail-value">{{ $case->created_at->format('M d, Y H:i') }}</div>
        </div>

        <div class="detail-row">
            <div class="detail-label">Last Updated:</div>
            <div class="detail-value">{{ $case->updated_at->format('M d, Y H:i') }}</div>
        </div>
    </div>

    <div class="actions">
        <a href="{{ route('case.edit', $case->id) }}" class="action-btn edit-btn">Edit Case</a>
        <a href="{{ route('modules.edit.cases') }}" class="action-btn back-btn">Back to Cases</a>
    </div>
</div>
@endsection

