@extends('layouts.master')

@section('title', 'Case Status - Prolex Law Firm')

@section('content')
<style>
    .container {
        max-width: 1200px;
        margin: 40px auto;
        background-color: #f8fafc;
        padding: 30px;
        border-radius: 12px;
        box-shadow: 0 4px 6px rgba(0,0,0,0.1);
    }

    h1 {
        text-align: center;
        color: #1e40af;
        margin-bottom: 30px;
        font-size: 2.5rem;
        font-weight: 700;
    }

    .options-grid {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(280px, 1fr));
        gap: 20px;
        margin-bottom: 30px;
    }

    .option-item {
        background: white;
        padding: 25px;
        border-radius: 10px;
        box-shadow: 0 2px 4px rgba(0,0,0,0.05);
        text-decoration: none;
        color: #374151;
        transition: all 0.3s ease;
        border: 2px solid transparent;
    }

    .option-item:hover {
        transform: translateY(-2px);
        box-shadow: 0 6px 12px rgba(0,0,0,0.1);
        border-color: #3b82f6;
    }

    .option-item h3 {
        color: #1e40af;
        margin-bottom: 10px;
        font-size: 1.3rem;
        font-weight: 600;
    }

    .option-item p {
        color: #6b7280;
        font-size: 0.95rem;
        line-height: 1.5;
    }

    .option-icon {
        width: 50px;
        height: 50px;
        background: linear-gradient(135deg, #3b82f6, #1d4ed8);
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        margin-bottom: 15px;
    }

    .option-icon svg {
        width: 24px;
        height: 24px;
        fill: white;
    }

    .back-btn {
        background: #6b7280;
        color: white;
        padding: 12px 24px;
        border: none;
        border-radius: 8px;
        font-size: 1rem;
        font-weight: 600;
        cursor: pointer;
        transition: all 0.3s ease;
        text-decoration: none;
        display: inline-block;
        margin-bottom: 20px;
    }

    .back-btn:hover {
        background: #4b5563;
        transform: translateY(-1px);
    }
</style>

<div class="container">
    <a href="{{ route('modules.edit.case') }}" class="back-btn">← Back to Cases</a>
    <h1>Case Status Management</h1>

    <div class="options-grid">
        <a href="{{ route('modules.edit.case-status.list') }}" class="option-item">
            <div class="option-icon">
                <svg viewBox="0 0 24 24">
                    <path d="M3 13h8V3H3v10zm0 8h8v-6H3v6zm10 0h8V11h-8v10zm0-18v6h8V3h-8z"/>
                </svg>
            </div>
            <h3>View All Case Status</h3>
            <p>View and manage all case statuses in the system</p>
        </a>

        <a href="{{ route('modules.edit.case-status.add') }}" class="option-item">
            <div class="option-icon">
                <svg viewBox="0 0 24 24">
                    <path d="M19 13h-6v6h-2v-6H5v-2h6V5h2v6h6v2z"/>
                </svg>
            </div>
            <h3>Add New Case Status</h3>
            <p>Create a new case status for your legal cases</p>
        </a>
    </div>
</div>
@endsection

