@extends('layouts.master')

@section('title', 'Edit Case Status - Prolex Law Firm')

@section('content')
<style>
    .container {
        max-width: 800px;
        margin: 40px auto;
        background-color: #f8fafc;
        padding: 30px;
        border-radius: 12px;
        box-shadow: 0 4px 6px rgba(0,0,0,0.1);
    }

    h1 {
        text-align: center;
        color: #1e40af;
        margin-bottom: 30px;
        font-size: 2.5rem;
        font-weight: 700;
    }

    .form-section {
        background: white;
        border-radius: 8px;
        padding: 25px;
        margin-bottom: 25px;
        border: 1px solid #e2e8f0;
        box-shadow: 0 2px 4px rgba(0,0,0,0.05);
    }

    .section-title {
        color: #2d3748;
        font-size: 1.5rem;
        font-weight: 600;
        margin-bottom: 20px;
        border-bottom: 2px solid #e2e8f0;
        padding-bottom: 10px;
    }

    .form-group {
        margin-bottom: 20px;
    }

    .form-row {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
        gap: 20px;
    }

    label {
        display: block;
        margin-bottom: 8px;
        font-weight: 600;
        color: #4a5568;
        font-size: 0.95rem;
    }

    input, select, textarea {
        width: 100%;
        padding: 12px 16px;
        border: 2px solid #e2e8f0;
        border-radius: 6px;
        font-size: 1rem;
        transition: all 0.3s ease;
        background-color: #ffffff;
    }

    input:focus, select:focus, textarea:focus {
        outline: none;
        border-color: #3b82f6;
        box-shadow: 0 0 0 3px rgba(59, 130, 246, 0.1);
    }

    textarea {
        resize: vertical;
        min-height: 100px;
    }

    .required::after {
        content: ' *';
        color: #e53e3e;
    }

    .form-help {
        font-size: 0.85rem;
        color: #6b7280;
        margin-top: 5px;
        font-style: italic;
    }

    .submit-btn {
        background: linear-gradient(135deg, #3b82f6, #1d4ed8);
        color: white;
        padding: 15px 40px;
        border: none;
        border-radius: 8px;
        font-size: 1.1rem;
        font-weight: 600;
        cursor: pointer;
        transition: all 0.3s ease;
        box-shadow: 0 4px 6px rgba(59, 130, 246, 0.3);
    }

    .submit-btn:hover {
        transform: translateY(-2px);
        box-shadow: 0 6px 12px rgba(59, 130, 246, 0.4);
    }

    .submit-btn:active {
        transform: translateY(0);
    }

    .back-btn {
        background: #6b7280;
        color: white;
        padding: 12px 24px;
        border: none;
        border-radius: 8px;
        font-size: 1rem;
        font-weight: 600;
        cursor: pointer;
        transition: all 0.3s ease;
        text-decoration: none;
        display: inline-block;
        margin-bottom: 20px;
    }

    .back-btn:hover {
        background: #4b5563;
        transform: translateY(-1px);
    }

    .current-info {
        background-color: #e0f2fe;
        border: 1px solid #0ea5e9;
        border-radius: 6px;
        padding: 15px;
        margin-bottom: 20px;
    }

    .current-info h3 {
        color: #0369a1;
        margin-bottom: 10px;
        font-size: 1.1rem;
    }

    .current-info p {
        color: #0c4a6e;
        margin: 5px 0;
    }
</style>

<div class="container">
    <a href="{{ route('modules.edit.case-status.show', $caseStatus->status_code) }}" class="back-btn">← Back to Case Status Details</a>
    <h1>Edit Case Status</h1>

    <div class="current-info">
        <h3>Current Information</h3>
        <p><strong>Status Code:</strong> {{ $caseStatus->status_code }}</p>
        <p><strong>Status Name:</strong> {{ $caseStatus->status_name }}</p>
        <p><strong>Status:</strong> {{ $caseStatus->is_active ? 'Active' : 'Inactive' }}</p>
        <p><strong>Color:</strong> <span style="display: inline-block; width: 20px; height: 20px; background-color: {{ $caseStatus->color_code }}; border-radius: 50%; border: 1px solid #ccc; vertical-align: middle; margin-left: 5px;"></span> {{ $caseStatus->color_code }}</p>
        @if($caseStatus->status_description)
            <p><strong>Description:</strong> {{ $caseStatus->status_description }}</p>
        @endif
    </div>

    <form id="editCaseStatusForm" action="{{ route('case-status.update', $caseStatus->status_code) }}" method="POST">
        @csrf
        @method('PUT')

        <div class="form-section">
            <h2 class="section-title">Basic Information</h2>

            <div class="form-row">
                <div class="form-group">
                    <label for="status_code" class="required">Status Code</label>
                    <input type="text" id="status_code" name="status_code" value="{{ $caseStatus->status_code }}" required placeholder="e.g., ACTIVE, PENDING, CLOSED" maxlength="20">
                    <div class="form-help">Unique code for this status (max 20 characters)</div>
                </div>

                <div class="form-group">
                    <label for="status_name" class="required">Status Name</label>
                    <input type="text" id="status_name" name="status_name" value="{{ $caseStatus->status_name }}" required placeholder="e.g., Active, Pending, Closed" maxlength="255">
                    <div class="form-help">Display name for this case status</div>
                </div>
            </div>

            <div class="form-group">
                <label for="status_description">Description</label>
                <textarea id="status_description" name="status_description" rows="4" placeholder="Provide a detailed description of this case status...">{{ $caseStatus->status_description }}</textarea>
                <div class="form-help">Optional: Describe when and how this case status should be used</div>
            </div>
        </div>



        <div style="text-align: center; margin-top: 30px;">
            <button type="submit" class="submit-btn">Update Case Status</button>
        </div>
    </form>
</div>

<script>
    // Form validation
    document.getElementById('editCaseStatusForm').addEventListener('submit', function(e) {
        const statusCode = document.getElementById('status_code').value.trim();
        const statusName = document.getElementById('status_name').value.trim();

        if (!statusCode) {
            e.preventDefault();
            alert('Please enter a status code.');
            return false;
        }

        if (!statusName) {
            e.preventDefault();
            alert('Please enter a status name.');
            return false;
        }

        // Validate status code length
        if (statusCode.length > 20) {
            e.preventDefault();
            alert('Status code cannot exceed 20 characters.');
            return false;
        }

        // Validate status name length
        if (statusName.length < 2) {
            e.preventDefault();
            alert('Status name must be at least 2 characters long.');
            return false;
        }

        if (statusName.length > 255) {
            e.preventDefault();
            alert('Status name cannot exceed 255 characters.');
            return false;
        }
    });
</script>
@endsection

