@extends('layouts.master')

@section('title', 'Case Status List - Prolex Law Firm')

@section('content')
<style>
    .container {
        max-width: 1200px;
        margin: 40px auto;
        background-color: #f8fafc;
        padding: 30px;
        border-radius: 12px;
        box-shadow: 0 4px 6px rgba(0,0,0,0.1);
    }

    h1 {
        text-align: center;
        color: #1e40af;
        margin-bottom: 30px;
        font-size: 2.5rem;
        font-weight: 700;
    }

    .actions {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-bottom: 20px;
    }

    .add-btn {
        background: linear-gradient(135deg, #3b82f6, #1d4ed8);
        color: white;
        padding: 12px 24px;
        border: none;
        border-radius: 8px;
        font-size: 1rem;
        font-weight: 600;
        cursor: pointer;
        transition: all 0.3s ease;
        text-decoration: none;
        display: inline-block;
    }

    .add-btn:hover {
        transform: translateY(-2px);
        box-shadow: 0 6px 12px rgba(59, 130, 246, 0.4);
    }

    .search-container {
        display: flex;
        align-items: center;
        gap: 10px;
    }

    #searchInput {
        padding: 10px 15px;
        border: 2px solid #e2e8f0;
        border-radius: 6px;
        font-size: 1rem;
        width: 300px;
    }

    #searchInput:focus {
        outline: none;
        border-color: #3b82f6;
        box-shadow: 0 0 0 3px rgba(59, 130, 246, 0.1);
    }

    .table-container {
        background: white;
        border-radius: 8px;
        overflow: hidden;
        box-shadow: 0 2px 4px rgba(0,0,0,0.05);
    }

    table {
        width: 100%;
        border-collapse: collapse;
    }

    th, td {
        padding: 15px;
        text-align: left;
        border-bottom: 1px solid #e2e8f0;
    }

    th {
        background-color: #f8fafc;
        font-weight: 600;
        color: #374151;
        font-size: 0.95rem;
    }

    td {
        color: #4b5563;
        font-size: 0.9rem;
    }

    tr:hover {
        background-color: #f9fafb;
    }

    .action-btn {
        padding: 6px 12px;
        border: none;
        border-radius: 4px;
        font-size: 0.85rem;
        font-weight: 500;
        cursor: pointer;
        text-decoration: none;
        display: inline-block;
        margin-right: 5px;
    }

    .edit-btn {
        background-color: #f59e0b;
        color: white;
    }

    .edit-btn:hover {
        background-color: #d97706;
    }

    .delete-btn {
        background-color: #ef4444;
        color: white;
    }

    .delete-btn:hover {
        background-color: #dc2626;
    }

    .view-btn {
        background-color: #10b981;
        color: white;
    }

    .view-btn:hover {
        background-color: #059669;
    }

    .back-btn {
        background: #6b7280;
        color: white;
        padding: 12px 24px;
        border: none;
        border-radius: 8px;
        font-size: 1rem;
        font-weight: 600;
        cursor: pointer;
        transition: all 0.3s ease;
        text-decoration: none;
        display: inline-block;
        margin-bottom: 20px;
    }

    .back-btn:hover {
        background: #4b5563;
        transform: translateY(-1px);
    }
</style>

<div class="container">
    <a href="{{ route('modules.edit.case-status') }}" class="back-btn">← Back to Case Status</a>
    <h1>Case Status</h1>

    <div class="actions">
        <a href="{{ route('modules.edit.case-status.add') }}" class="add-btn">+ Add New Case Status</a>
        <div class="search-container">
            <input type="text" id="searchInput" placeholder="Search case statuses...">
        </div>
    </div>

    <div class="table-container">
        <table id="caseStatusTable">
            <thead>
                <tr>
                    <th>Status Name</th>
                    <th>Description</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                @forelse($caseStatuses ?? [] as $status)
                <tr>
                    <td>{{ $status->status_name }}</td>
                    <td>{{ Str::limit($status->status_description ?? '', 50) }}</td>
                    <td>
                        <a href="{{ route('modules.edit.case-status.show', $status->status_code) }}" class="action-btn view-btn">View</a>
                        <a href="{{ route('modules.edit.case-status.edit', $status->status_code) }}" class="action-btn edit-btn">Edit</a>
                        <form action="{{ route('case-status.destroy', $status->status_code) }}" method="POST" style="display: inline;">
                            @csrf
                            @method('DELETE')
                            <button type="submit" class="action-btn delete-btn" onclick="return confirm('Are you sure you want to delete this case status?')">Delete</button>
                        </form>
                    </td>
                </tr>
                @empty
                <tr>
                    <td colspan="3" style="text-align: center; padding: 40px; color: #6b7280; font-size: 1.1rem;">
                        No case statuses found. <a href="{{ route('modules.edit.case-status.add') }}" class="add-btn" style="display: inline-block; margin-left: 10px;">Add your first case status</a>
                    </td>
                </tr>
                @endforelse
            </tbody>
        </table>
    </div>
</div>

<script>
    // Search functionality
    document.getElementById('searchInput').addEventListener('input', function() {
        const searchTerm = this.value.toLowerCase();
        const rows = document.querySelectorAll('#caseStatusTable tbody tr');

        rows.forEach(row => {
            if (row.cells.length > 1) { // Skip the "no data" row
                const text = row.textContent.toLowerCase();
                row.style.display = text.includes(searchTerm) ? '' : 'none';
            }
        });
    });
</script>
@endsection

