@extends('layouts.master')

@section('title', 'Case Status Details - Prolex Law Firm')

@section('content')
<style>
    .container {
        max-width: 800px;
        margin: 40px auto;
        background-color: #f8fafc;
        padding: 30px;
        border-radius: 12px;
        box-shadow: 0 4px 6px rgba(0,0,0,0.1);
    }

    h1 {
        text-align: center;
        color: #1e40af;
        margin-bottom: 30px;
        font-size: 2.5rem;
        font-weight: 700;
    }

    .details-section {
        background: white;
        border-radius: 8px;
        padding: 25px;
        margin-bottom: 25px;
        border: 1px solid #e2e8f0;
        box-shadow: 0 2px 4px rgba(0,0,0,0.05);
    }

    .section-title {
        color: #2d3748;
        font-size: 1.5rem;
        font-weight: 600;
        margin-bottom: 20px;
        border-bottom: 2px solid #e2e8f0;
        padding-bottom: 10px;
    }

    .detail-row {
        display: flex;
        margin-bottom: 15px;
        padding: 10px 0;
        border-bottom: 1px solid #f1f5f9;
    }

    .detail-row:last-child {
        border-bottom: none;
    }

    .detail-label {
        font-weight: 600;
        color: #4a5568;
        width: 150px;
        flex-shrink: 0;
    }

    .detail-value {
        color: #2d3748;
        flex: 1;
    }

    .status-badge {
        padding: 4px 12px;
        border-radius: 20px;
        font-size: 0.85rem;
        font-weight: 500;
        text-transform: uppercase;
        display: inline-block;
    }

    .status-active {
        background-color: #d1fae5;
        color: #059669;
    }

    .status-inactive {
        background-color: #fee2e2;
        color: #dc2626;
    }

    .action-buttons {
        display: flex;
        gap: 15px;
        justify-content: center;
        margin-top: 30px;
    }

    .action-btn {
        padding: 12px 24px;
        border: none;
        border-radius: 8px;
        font-size: 1rem;
        font-weight: 600;
        cursor: pointer;
        transition: all 0.3s ease;
        text-decoration: none;
        display: inline-block;
    }

    .edit-btn {
        background-color: #f59e0b;
        color: white;
    }

    .edit-btn:hover {
        background-color: #d97706;
        transform: translateY(-2px);
    }

    .delete-btn {
        background-color: #ef4444;
        color: white;
    }

    .delete-btn:hover {
        background-color: #dc2626;
        transform: translateY(-2px);
    }

    .back-btn {
        background: #6b7280;
        color: white;
        padding: 12px 24px;
        border: none;
        border-radius: 8px;
        font-size: 1rem;
        font-weight: 600;
        cursor: pointer;
        transition: all 0.3s ease;
        text-decoration: none;
        display: inline-block;
        margin-bottom: 20px;
    }

    .back-btn:hover {
        background: #4b5563;
        transform: translateY(-1px);
    }

    .description-box {
        background-color: #f8fafc;
        padding: 15px;
        border-radius: 6px;
        border-left: 4px solid #3b82f6;
        margin-top: 10px;
    }

    .no-description {
        color: #9ca3af;
        font-style: italic;
    }
</style>

<div class="container">
    <a href="{{ route('modules.edit.case-status.list') }}" class="back-btn">← Back to Case Status List</a>
    <h1>Case Status Details</h1>

    <div class="details-section">
        <h2 class="section-title">Status Information</h2>

        <div class="detail-row">
            <div class="detail-label">Status Name:</div>
            <div class="detail-value">{{ $caseStatus->status_name }}</div>
        </div>

        <div class="detail-row">
            <div class="detail-label">Description:</div>
            <div class="detail-value">
                @if($caseStatus->status_description)
                    <div class="description-box">{{ $caseStatus->status_description }}</div>
                @else
                    <span class="no-description">No description provided</span>
                @endif
            </div>
        </div>

        <div class="detail-row">
            <div class="detail-label">Status:</div>
            <div class="detail-value">
                <span class="status-badge {{ $caseStatus->is_active ? 'status-active' : 'status-inactive' }}">
                    {{ $caseStatus->is_active ? 'Active' : 'Inactive' }}
                </span>
            </div>
        </div>

        <div class="detail-row">
            <div class="detail-label">Created:</div>
            <div class="detail-value">{{ $caseStatus->created_at->format('M d, Y H:i') }}</div>
        </div>

        <div class="detail-row">
            <div class="detail-label">Last Updated:</div>
            <div class="detail-value">{{ $caseStatus->updated_at->format('M d, Y H:i') }}</div>
        </div>
    </div>

    <div class="action-buttons">
        <a href="{{ route('modules.edit.case-status.edit', $caseStatus->status_code) }}" class="action-btn edit-btn">Edit Status</a>
        <form action="{{ route('case-status.destroy', $caseStatus->status_code) }}" method="POST" style="display: inline;">
            @csrf
            @method('DELETE')
            <button type="submit" class="action-btn delete-btn" onclick="return confirm('Are you sure you want to delete this case status?')">Delete Status</button>
        </form>
    </div>
</div>
@endsection

