@extends('layouts.master')

@section('title', 'Add Case Reason - Prolex Law Firm')

@section('content')
<style>
    .container {
        max-width: 1200px;
        margin: 40px auto;
        background-color: #f8fafc;
        padding: 30px;
        border-radius: 12px;
        box-shadow: 0 4px 6px rgba(0,0,0,0.1);
    }

    h1 {
        text-align: center;
        color: #1e40af;
        margin-bottom: 30px;
        font-size: 2.5rem;
        font-weight: 700;
    }

    .form-section {
        background: white;
        border-radius: 8px;
        padding: 25px;
        margin-bottom: 25px;
        border: 1px solid #e2e8f0;
        box-shadow: 0 2px 4px rgba(0,0,0,0.05);
    }

    .section-title {
        color: #2d3748;
        font-size: 1.5rem;
        font-weight: 600;
        margin-bottom: 20px;
        border-bottom: 2px solid #e2e8f0;
        padding-bottom: 10px;
    }

    .form-group {
        margin-bottom: 20px;
    }

    .form-row {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
        gap: 20px;
    }

    label {
        display: block;
        margin-bottom: 8px;
        font-weight: 600;
        color: #4a5568;
        font-size: 0.95rem;
    }

    input, select, textarea {
        width: 100%;
        padding: 12px 16px;
        border: 2px solid #e2e8f0;
        border-radius: 6px;
        font-size: 1rem;
        transition: all 0.3s ease;
        background-color: #ffffff;
    }

    input:focus, select:focus, textarea:focus {
        outline: none;
        border-color: #3b82f6;
        box-shadow: 0 0 0 3px rgba(59, 130, 246, 0.1);
    }

    textarea {
        resize: vertical;
        min-height: 100px;
    }

    .required::after {
        content: ' *';
        color: #e53e3e;
    }

    .button-group {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-top: 30px;
    }

    .submit-btn, .refresh-btn, .back-btn {
        padding: 15px 40px;
        border: none;
        border-radius: 8px;
        font-size: 1.1rem;
        font-weight: 600;
        cursor: pointer;
        transition: all 0.3s ease;
        box-shadow: 0 4px 6px rgba(59, 130, 246, 0.3);
    }

    .submit-btn {
        background: linear-gradient(135deg, #3b82f6, #1d4ed8);
        color: white;
    }

    .refresh-btn {
        background: linear-gradient(135deg, #f59e0b, #d97706);
        color: white;
    }

    .back-btn {
        background: linear-gradient(135deg, #6b7280, #4b5563);
        color: white;
        text-decoration: none;
        display: inline-block;
    }

    .submit-btn:hover, .refresh-btn:hover, .back-btn:hover {
        transform: translateY(-2px);
        box-shadow: 0 6px 12px rgba(59, 130, 246, 0.4);
    }

    .submit-btn:active, .refresh-btn:active, .back-btn:active {
        transform: translateY(0);
    }
</style>

<div class="container">
    <h1>Add Case Reason</h1>

    @if(session('success'))
        <div style="background-color: #d1fae5; color: #065f46; padding: 15px; border-radius: 6px; margin-bottom: 20px; border: 1px solid #a7f3d0;">
            {{ session('success') }}
        </div>
    @endif

    @if($errors->any())
        <div style="background-color: #fee2e2; color: #991b1b; padding: 15px; border-radius: 6px; margin-bottom: 20px; border: 1px solid #fecaca;">
            <ul style="margin: 0; padding-left: 20px;">
                @foreach($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    <form id="caseReasonForm" action="{{ route('case-reasons.store') }}" method="POST">
        @csrf

        <div class="form-section">
            <div class="section-title">Case Reason Information</div>

            <div class="form-row">
                <div class="form-group">
                    <label for="reason_code" class="required">Reason Code</label>
                    <input type="text" id="reason_code" name="reason_code" required placeholder="e.g., CR001, CLIENT_REQ">
                </div>

                <div class="form-group">
                    <label for="reason_name" class="required">Reason Name</label>
                    <input type="text" id="reason_name" name="reason_name" required placeholder="e.g., Client Request">
                </div>
            </div>

            <div class="form-group">
                <label for="reason_description" class="required">Reason Description</label>
                <textarea id="reason_description" name="reason_description" rows="4" required placeholder="Provide a detailed description of this case reason..."></textarea>
            </div>

            <div class="form-row">
                <div class="form-group">
                    <label for="priority" class="required">Priority Level</label>
                    <select id="priority" name="priority" required>
                        <option value="">Select Priority</option>
                        <option value="low">Low</option>
                        <option value="medium">Medium</option>
                        <option value="high">High</option>
                    </select>
                </div>

                <div class="form-group">
                    <label for="is_active" class="required">Status</label>
                    <select id="is_active" name="is_active" required>
                        <option value="">Select Status</option>
                        <option value="1">Active</option>
                        <option value="0">Inactive</option>
                    </select>
                </div>
            </div>

            <div class="form-group">
                <label>
                    <input type="checkbox" name="requires_approval" value="1"> Requires Approval
                </label>
            </div>
        </div>

        <div class="button-group">
            <a href="{{ route('modules.edit.case') }}" class="back-btn">Back to Cases</a>
            <div>
                <button type="button" class="refresh-btn" onclick="resetForm()">Refresh</button>
                <button type="submit" class="submit-btn">Save Case Reason</button>
            </div>
        </div>
    </form>
</div>

<script>
    function resetForm() {
        document.getElementById('caseReasonForm').reset();
    }

    document.getElementById('caseReasonForm').addEventListener('submit', function(e) {
        const submitBtn = document.querySelector('.submit-btn');
        submitBtn.disabled = true;
        submitBtn.innerHTML = 'Saving...';
    });
</script>

@endsection

